PROGRAM_NAME='iRoom_iBezel_Demo'
/*
  Dealer Name: iRoom  
  System Name: iBezel
*/

define_device

    dvIRoom_iBezel  = 0:FIRST_LOCAL_PORT:0
    vdvIRoom_iBezel  = 33001:1:1
    dvTP             = 10001:1:1


define_constant

    TP_VERSION = 118
    TP_STATUS = 119

    BTN_HOME	= 10
    BTN_1	= 11
    BTN_2	= 12
    BTN_3	= 13
    BTN_4	= 14
    BTN_5	= 15
    BTN_6 	= 16
    BTN_7	= 17
    BTN_8	= 18

    DIG_INPUT_0	= 20
    DIG_INPUT_1	= 21
    DIG_INPUT_2	= 22
    DIG_INPUT_3	= 23
    DIG_INPUT_4	= 24
    DIG_INPUT_5	= 25
    DIG_INPUT_6	= 26
    DIG_INPUT_7	= 27
    DIG_INPUT_8	= 28

    PROXIMITY_SENSOR  = 30
    PLUGDRIVE_DOCKED  = 31
    CLACKDRIVE_CLOSED = 32	
    DOCK_FEEDBACK     = 33
    RELAY_FEEDBACK    = 34
    IBEZEL_TOUCHCODE  = 35

    HOME_BUTTON_LEVEL = 10
    LED_1_LEVEL = 11
    LED_2_LEVEL = 12
    LED_3_LEVEL = 13
    LED_4_LEVEL = 14
    LED_5_LEVEL = 15
    LED_6_LEVEL = 16
    LED_7_LEVEL = 17
    LED_8_LEVEL = 18
    VOLUME_LEVEL = 19
    IRDETECTOR_LEVEL = 20
    
    BTN_REBOOT = 36
    BTN_REQ_INFO = 37

define_variable

    // Target device IP
    // iBezel
    // char iBezel_IP[15] = '172.16.112.190'
    // iTopLock
    char iBezel_IP[15] = '172.16.112.155'
    // Default port
    integer iBezel_PORT = 13601

constant Integer IBEZEL_BUTTONS[] =
{
    BTN_HOME, BTN_1, BTN_2, BTN_3, BTN_4, 
    BTN_5, BTN_6, BTN_7, BTN_8
};

constant Integer IBEZEL_DIGITALINPUTS[] =
{
    DIG_INPUT_0, DIG_INPUT_1, DIG_INPUT_2, DIG_INPUT_3,
    DIG_INPUT_4, DIG_INPUT_5, DIG_INPUT_6, DIG_INPUT_7,
    DIG_INPUT_8
};

constant Integer IBEZEL_OTHER[] =
{
  PROXIMITY_SENSOR, PLUGDRIVE_DOCKED, CLACKDRIVE_CLOSED, DOCK_FEEDBACK,
  RELAY_FEEDBACK, IBEZEL_TOUCHCODE
};

constant Integer IBEZEL_LEVELS[] =
{
  HOME_BUTTON_LEVEL, LED_1_LEVEL, LED_2_LEVEL,
  LED_3_LEVEL, LED_4_LEVEL, LED_5_LEVEL, LED_6_LEVEL,
  LED_7_LEVEL, LED_8_LEVEL,  IRDETECTOR_LEVEL, VOLUME_LEVEL
}

define_module 'iRoom_iBezel' IROOM_IBEZEL( 
    vdvIRoom_iBezel,
    dvIRoom_iBezel,
    iBezel_IP,
    iBezel_PORT,
    IBEZEL_BUTTONS,
    IBEZEL_DIGITALINPUTS,
    IBEZEL_OTHER,
    IBEZEL_LEVELS)

define_start
// THIS LINE BELOW IS VERY IMPORTANT
// Default is 8 now (1-20)
set_virtual_level_count (vdvIRoom_iBezel, 20)

define_event

data_event [dvTP]
{
    online:
    {
	send_command vdvIRoom_iBezel, "'GET_VERSION?;'";
	send_command vdvIRoom_iBezel, "'CLEAR_ALL;'";
	send_command vdvIRoom_iBezel, "'REQUEST_ALL;'";
    }
    command:
    {
	send_command vdvIRoom_iBezel, data.text;
    }
}

// Events related to iBezel Channels
channel_event[vdvIRoom_iBezel, IBEZEL_DIGITALINPUTS]
{
    on:
    {
	integer btn;
	btn = get_last( IBEZEL_DIGITALINPUTS );
	on[dvTP, IBEZEL_DIGITALINPUTS[btn]]; 
		
	switch (IBEZEL_DIGITALINPUTS[btn])
	{
	    case DIG_INPUT_0:
	    {
		send_string 0, "'DIG_INPUT_0 On Event'";
	    }
	    case DIG_INPUT_1:
	    {
		send_string 0, "'DIG_INPUT_1 On Event'";
	    }
	    case DIG_INPUT_2:
	    {
		send_string 0, "'DIG_INPUT_2 On Event'";
	    }
	    case DIG_INPUT_3:
	    {
		send_string 0, "'DIG_INPUT_3 On Event'";
	    }
	    case DIG_INPUT_4:
	    {
		send_string 0, "'DIG_INPUT_4 On Event'";
	    }
	    case DIG_INPUT_5:
	    {
		send_string 0, "'DIG_INPUT_5 On Event'";
	    }
	    case DIG_INPUT_6:
	    {
		send_string 0, "'DIG_INPUT_6 On Event'";
	    }
	    case DIG_INPUT_7:
	    {
		send_string 0, "'DIG_INPUT_7 On Event'";
	    }
	    case DIG_INPUT_8:
	    {
		send_string 0, "'DIG_INPUT_8 On Event'";
	    }
	    default:
	    {
		send_string 0, "'DIG_INPUT Not recognised'";
	    }
	}
    }

    off:
    {
	integer btn;
	btn = Get_Last( IBEZEL_DIGITALINPUTS );
	off[dvTP, IBEZEL_DIGITALINPUTS[btn]]; 
		
	switch (IBEZEL_DIGITALINPUTS[btn])
	{
	    case DIG_INPUT_0:
	    {
		send_string 0, "'DIG_INPUT_0 Off Event'";
	    }
	    case DIG_INPUT_1:
	    {
		send_string 0, "'DIG_INPUT_1 Off Event'";
	    }
	    case DIG_INPUT_2:
	    {
		send_string 0, "'DIG_INPUT_2 Off Event'";
	    }
	    case DIG_INPUT_3:
	    {
		send_string 0, "'DIG_INPUT_3 Off Event'";
	    }
	    case DIG_INPUT_4:
	    {
		send_string 0, "'DIG_INPUT_4 Off Event'";
	    }
	    case DIG_INPUT_5:
	    {
		send_string 0, "'DIG_INPUT_5 Off Event'";
	    }
	    case DIG_INPUT_6:
	    {
		send_string 0, "'DIG_INPUT_6 Off Event'";
	    }
	    case DIG_INPUT_7:
	    {
		send_string 0, "'DIG_INPUT_7 Off Event'";
	    }
	    case DIG_INPUT_8:
	    {
		send_string 0, "'DIG_INPUT_8 Off Event'";
	    }
	    default:
	    {
		send_string 0, "'DIG_INPUT Not recognised'";
	    }
	}
    }
}

// Events related to iBezel Digital Inputs
channel_event[vdvIRoom_iBezel, IBEZEL_BUTTONS]
{
    on:
    {
	integer btn;
	btn = Get_Last( IBEZEL_BUTTONS );
	on[dvTP, IBEZEL_BUTTONS[btn]]; 

	switch (IBEZEL_BUTTONS[btn])
	{
	    case BTN_HOME:
	    {
		send_string 0  , "'BTN_HOME On Event'";
	    }
	    case BTN_1:
	    {
		send_string 0  , "'BTN_1 On Event'";
	    }
	    case BTN_2:
	    {
		send_string 0 , "'BTN_2 On Event'";
	    }
	    case BTN_3:
	    {
		send_string 0 , "'BTN_3 On Event'";
	    }
	    case BTN_4	:
	    {
		send_string 0 , "'BTN_4 On Event'";
	    }
	    case BTN_5	:
	    {
		send_string 0 , "'BTN_5 On Event'";
	    }
	    case BTN_6	:
	    {
		send_string 0 , "'BTN_6 On Event'";
	    }
	    case BTN_7:
	    {
		send_string 0 , "'BTN_7 On Event'";
	    }
	    case BTN_8:
	    {
		send_string 0 , "'BTN_8 On Event'";
	    }
	    default :
	    {
		send_string 0 , "'Button Not recognised'";
	    }
	}
    }

    off:
    {
	integer btn;
	btn = Get_Last( IBEZEL_BUTTONS );
	off[dvTP, IBEZEL_BUTTONS[btn]]; 

	switch (IBEZEL_BUTTONS[btn])
	{
	    case BTN_HOME:
	    {
		send_string 0 , "'BTN_HOME Off Event'"
	    }
	    case BTN_1:
	    {
		send_string 0 , "'BTN_1 Off Event'";
	    }
	    case BTN_2:
	    {
		send_string 0 , "'BTN_2 Off Event'";
	    }
	    case BTN_3:
	    {
		send_string 0 , "'BTN_3 Off Event'";
	    }
	    case BTN_4:
	    {
		send_string 0  , "'BTN_4 Off Event'";
	    }
	    case BTN_5:
	    {
		send_string 0 , "'BTN_5 Off Event'";
	    }
	    case BTN_6:
	    {
		send_string 0  , "'BTN_6 Off Event'";
	    }
	    case BTN_7:
	    {
		send_string 0 , "'BTN_7 Off Event'";
	    }
	    case BTN_8:
	    {
		send_string 0 , "'BTN_8 Off Event'";
	    }
	    default :
	    {
		send_string 0 , "'Button Not recognised'";
	    }
	}
    }
}

// Events related to iBezel Digital Inputs
channel_event[vdvIRoom_iBezel, IBEZEL_OTHER]
{
    on:
    {
	integer btn;
	btn = Get_Last( IBEZEL_OTHER );
	on[dvTP, IBEZEL_OTHER[btn]];

	switch (IBEZEL_OTHER[btn])
	{   
	    case PLUGDRIVE_DOCKED:
	    {
		send_string 0 , "'PLUGDRIVE_DOCKED Off Event'";
	    }
	    case CLACKDRIVE_CLOSED:
	    {
		send_string 0 , "'CLACKDRIVE_CLOSED On Event'";
	    }
	    case DOCK_FEEDBACK:
	    {
		send_string 0 , "'DOCK_FEEDBACK On Event'";
	    }
	    case RELAY_FEEDBACK:
	    {
		send_string 0 , "'RELAY_FEEDBACK On Event'";
	    }
	    case PROXIMITY_SENSOR:
	    {
		send_string 0 , "'PROXIMITY_SENSOR On Event'";
	    }
	    case IBEZEL_TOUCHCODE:
	    {
		send_string 0 , "'IBEZEL_TOUCHCODE On Event'";
	    }
	    default:
	    {
		send_string 0 , "'Not recognised'";
	    }
	}
    }

    off:
    {
	integer btn;
	btn = Get_Last( IBEZEL_OTHER );
	off[dvTP, IBEZEL_OTHER[btn]]; 

	switch (IBEZEL_OTHER[btn])
	{
	    case PLUGDRIVE_DOCKED:
	    {
		send_string 0 , "'PLUGDRIVE_DOCKED Off Event'";
	    }
	    case CLACKDRIVE_CLOSED:
	    {
		send_string 0 , "'CLACKDRIVE_CLOSE Off Event'";
	    }
	    case DOCK_FEEDBACK:
	    {
		send_string 0 , "'DOCK_FEEDBACK Off Event'";
	    }
	    case RELAY_FEEDBACK:
	    {
		send_string 0 , "'RELAY_FEEDBACK Off Event'";
	    }
	    case PROXIMITY_SENSOR:
	    {
		send_string 0 , "'PROXIMITY_SENSOR Off Event'";
	    }
	    case IBEZEL_TOUCHCODE :
	    {
		send_string 0 , "'IBEZEL_TOUCHCODE Off Event'";
	    }
	    default:
	    {
		send_string 0 , "'Not recognised'";
	    }
	}
    }
}

level_event [vdvIRoom_iBezel, IBEZEL_LEVELS]
{
    integer led;
    led = Get_Last( IBEZEL_LEVELS );
    send_level dvTP, IBEZEL_LEVELS[led], level.value;

    switch (IBEZEL_LEVELS[led])
    {
	case HOME_BUTTON_LEVEL:
	{
	    send_string 0 , "'HOME_BUTTON Level Set To ', itoa(LEVEL.VALUE), '%'";
	}
	case LED_1_LEVEl:
	{
	    send_string 0 , "'LED_1 Level Set To ', itoa(LEVEL.VALUE), '%'";
	}
	case LED_2_LEVEl:
	{
	    send_string 0 , "'LED_2 Level Set To ', itoa(LEVEL.VALUE), '%'";
	}
	case LED_3_LEVEL:
	{
	    send_string 0 , "'LED_3 Level Set To ', itoa(LEVEL.VALUE), '%'";
	}
	case LED_4_LEVEL:
	{
	    send_string 0 , "'LED_4 Level Set To ', itoa(LEVEL.VALUE), '%'";
	}
	case LED_5_LEVEL:
	{
	    send_string 0 , "'LED_5 Level Set To ', itoa(LEVEL.VALUE), '%'";
	}
	case LED_6_LEVEL:
	{
	    send_string 0 , "'LED_6 Level Set To ', itoa(LEVEL.VALUE), '%'";
	}
	case LED_7_LEVEL:
	{
	    send_string 0 , "'LED_7 Level Set To ', itoa(LEVEL.VALUE), '%'";
	}
	case LED_8_LEVEL:
	{
	    send_string 0 , "'LED_8 Level Set To ', itoa(LEVEL.VALUE), '%'";
	}
	case IRDETECTOR_LEVEL:
	{
	    send_string 0 , "'IRDETECTOR_LEVEL Level Set To ', itoa(LEVEL.VALUE)";
	}
	case VOLUME_LEVEL:
	{
	    send_string 0 , "'VOLUME_LEVEL Level Set To ', itoa(LEVEL.VALUE), '%'";
	}
    }
}

data_event[vdvIRoom_iBezel]
{
    string:
    {
	char cmdHeader[30], value[100], cmd[100];

	while (find_string( data.text, ';',  1 ) > 0)
	{
	    cmd = remove_string( data.text, ';', 1 );
	    cmdHeader = remove_string( cmd, ' ', 1 );
	    value = left_string( cmd, length_string( cmd ) - 1 );   // Drop the'?' char from the end.

	    switch (cmdHeader)
	    {
		case 'VERSION ':
		{
		    send_string 0, "'Version ', value";
		}
		case 'STATUS ':
		{
		    send_string 0, "'Status ', value";
		}
		case 'DOCKINGSTATE ':
		{
		    send_command dvTP, "'^TXT-',itoa( DOCK_FEEDBACK ),',0,',value";
		}
		case 'IBEZELMODE ':
		{
		    send_command dvTP, "'^TXT-',itoa( IBEZEL_TOUCHCODE ),',0,',value";
		}
		case 'PLUGDRIVE ':
		{
		    send_command dvTP, "'^TXT-',itoa( PLUGDRIVE_DOCKED ),',0,',value";
		}
		case 'CLACKDRIVE ':
		{
		    send_command dvTP, "'^TXT-',itoa( CLACKDRIVE_CLOSED ),',0,',value";
		}
		default:
		{
		    // send_string 0, "'default:cmdHeader<UNHANDLED>:', cmdHeader";
		}
	    }
	}
    }
}

define_program

