/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.common.resources;

import com.wibu.common.Pair;
import com.wibu.common.resources.BaseError;
import com.wibu.common.resources.BaseErrorInitializer;
import com.wibu.common.resources.GenericError;
import com.wibu.common.resources.GenericErrorGenerator;
import com.wibu.common.resources.Localizable;
import com.wibu.common.resources.LocalizedException;
import com.wibu.common.resources.LocalizedMessage;
import com.wibu.common.resources.NonLocalizedMessage;
import com.wibu.common.resources.Replacement;
import java.util.Map;

public class LocalizedError
extends LocalizedMessage {
    private final BaseError baseError;

    public LocalizedError(BaseErrorInitializer baseErrorInitializer, Replacement ... replacementArray) {
        this(baseErrorInitializer, Replacement.fromMultiple(replacementArray));
    }

    LocalizedError(BaseErrorInitializer baseErrorInitializer, Map<String, Localizable> map) {
        super(GenericError.GenericError.toError(), LocalizedError.getErrorParameters(baseErrorInitializer, map));
        this.baseError = baseErrorInitializer.toError();
    }

    private static Map<String, Localizable> getErrorParameters(BaseErrorInitializer baseErrorInitializer, Map<String, Localizable> map) {
        BaseError baseError = baseErrorInitializer.toError();
        LocalizedMessage localizedMessage = null;
        try {
            localizedMessage = new LocalizedMessage(baseError, map);
        }
        catch (LocalizedException localizedException) {
            throw new LocalizedException(localizedException, GenericErrorGenerator.CannotInitializeError(GenericError.GenericError.name()));
        }
        String string = String.format("0x%08x", baseError.getCode());
        return Replacement.fromMultiple(new Pair<String, NonLocalizedMessage>("code", new NonLocalizedMessage(string)), new Pair<String, LocalizedMessage>("message", localizedMessage));
    }

    public BaseError getBaseError() {
        return this.baseError;
    }
}

