/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Component;
import org.hibernate.tuple.component.ComponentTuplizer;
import org.hibernate.tuple.component.DynamicMapComponentTuplizer;
import org.hibernate.tuple.component.PojoComponentTuplizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTuplizerFactory
implements Serializable {
    private static final Class[] COMPONENT_TUP_CTOR_SIG = new Class[]{Component.class};
    private Map<EntityMode, Class<? extends ComponentTuplizer>> defaultImplClassByMode = ComponentTuplizerFactory.buildBaseMapping();

    public void registerDefaultTuplizerClass(EntityMode entityMode, Class<? extends ComponentTuplizer> tuplizerClass) {
        assert (this.isComponentTuplizerImplementor(tuplizerClass)) : "Specified tuplizer class [" + tuplizerClass.getName() + "] does not implement " + ComponentTuplizer.class.getName();
        assert (this.hasProperConstructor(tuplizerClass)) : "Specified tuplizer class [" + tuplizerClass.getName() + "] is not properly instantiatable";
        this.defaultImplClassByMode.put(entityMode, tuplizerClass);
    }

    public ComponentTuplizer constructTuplizer(String tuplizerClassName, Component metadata) {
        try {
            Class tuplizerClass = ReflectHelper.classForName(tuplizerClassName);
            return this.constructTuplizer(tuplizerClass, metadata);
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Could not locate specified tuplizer class [" + tuplizerClassName + "]");
        }
    }

    public ComponentTuplizer constructTuplizer(Class<? extends ComponentTuplizer> tuplizerClass, Component metadata) {
        Constructor<? extends ComponentTuplizer> constructor = this.getProperConstructor(tuplizerClass);
        assert (constructor != null) : "Unable to locate proper constructor for tuplizer [" + tuplizerClass.getName() + "]";
        try {
            return constructor.newInstance(metadata);
        }
        catch (Throwable t) {
            throw new HibernateException("Unable to instantiate default tuplizer [" + tuplizerClass.getName() + "]", t);
        }
    }

    public ComponentTuplizer constructDefaultTuplizer(EntityMode entityMode, Component metadata) {
        Class<? extends ComponentTuplizer> tuplizerClass = this.defaultImplClassByMode.get((Object)entityMode);
        if (tuplizerClass == null) {
            throw new HibernateException("could not determine default tuplizer class to use [" + (Object)((Object)entityMode) + "]");
        }
        return this.constructTuplizer(tuplizerClass, metadata);
    }

    private boolean isComponentTuplizerImplementor(Class tuplizerClass) {
        return ReflectHelper.implementsInterface(tuplizerClass, ComponentTuplizer.class);
    }

    private boolean hasProperConstructor(Class tuplizerClass) {
        return this.getProperConstructor(tuplizerClass) != null;
    }

    private Constructor<? extends ComponentTuplizer> getProperConstructor(Class<? extends ComponentTuplizer> clazz) {
        Constructor<? extends ComponentTuplizer> constructor = null;
        try {
            constructor = clazz.getDeclaredConstructor(COMPONENT_TUP_CTOR_SIG);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException e) {
                constructor = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return constructor;
    }

    private static Map<EntityMode, Class<? extends ComponentTuplizer>> buildBaseMapping() {
        ConcurrentHashMap<EntityMode, Class<? extends ComponentTuplizer>> map = new ConcurrentHashMap<EntityMode, Class<? extends ComponentTuplizer>>();
        map.put(EntityMode.POJO, PojoComponentTuplizer.class);
        map.put(EntityMode.MAP, DynamicMapComponentTuplizer.class);
        return map;
    }
}

