/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.lang.reflect.Constructor;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.internal.UnsavedValueFactory;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.VersionValue;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.binding.AbstractPluralAttributeBinding;
import org.hibernate.metamodel.binding.AssociationAttributeBinding;
import org.hibernate.metamodel.binding.AttributeBinding;
import org.hibernate.metamodel.binding.BasicAttributeBinding;
import org.hibernate.metamodel.binding.EntityBinding;
import org.hibernate.metamodel.binding.SimpleValueBinding;
import org.hibernate.metamodel.binding.SingularAttributeBinding;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.tuple.BaselineAttributeInformation;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.NonIdentifierAttribute;
import org.hibernate.tuple.StandardProperty;
import org.hibernate.tuple.entity.EntityBasedAssociationAttribute;
import org.hibernate.tuple.entity.EntityBasedBasicAttribute;
import org.hibernate.tuple.entity.EntityBasedCompositionAttribute;
import org.hibernate.tuple.entity.VersionProperty;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;

public final class PropertyFactory {
    private PropertyFactory() {
    }

    public static IdentifierProperty buildIdentifierAttribute(PersistentClass mappedEntity, IdentifierGenerator generator) {
        String mappedUnsavedValue = mappedEntity.getIdentifier().getNullValue();
        Type type = mappedEntity.getIdentifier().getType();
        Property property = mappedEntity.getIdentifierProperty();
        IdentifierValue unsavedValue = UnsavedValueFactory.getUnsavedIdentifierValue(mappedUnsavedValue, PropertyFactory.getGetter(property), type, PropertyFactory.getConstructor(mappedEntity));
        if (property == null) {
            return new IdentifierProperty(type, mappedEntity.hasEmbeddedIdentifier(), mappedEntity.hasIdentifierMapper(), unsavedValue, generator);
        }
        return new IdentifierProperty(property.getName(), property.getNodeName(), type, mappedEntity.hasEmbeddedIdentifier(), unsavedValue, generator);
    }

    public static IdentifierProperty buildIdentifierProperty(EntityBinding mappedEntity, IdentifierGenerator generator) {
        BasicAttributeBinding property = mappedEntity.getHierarchyDetails().getEntityIdentifier().getValueBinding();
        String mappedUnsavedValue = property.getUnsavedValue();
        Type type = property.getHibernateTypeDescriptor().getResolvedTypeMapping();
        IdentifierValue unsavedValue = UnsavedValueFactory.getUnsavedIdentifierValue(mappedUnsavedValue, PropertyFactory.getGetter(property), type, PropertyFactory.getConstructor(mappedEntity));
        if (property == null) {
            return new IdentifierProperty(type, mappedEntity.getHierarchyDetails().getEntityIdentifier().isEmbedded(), mappedEntity.getHierarchyDetails().getEntityIdentifier().isIdentifierMapper(), unsavedValue, generator);
        }
        return new IdentifierProperty(property.getAttribute().getName(), null, type, mappedEntity.getHierarchyDetails().getEntityIdentifier().isEmbedded(), unsavedValue, generator);
    }

    public static VersionProperty buildVersionProperty(EntityPersister persister, SessionFactoryImplementor sessionFactory, int attributeNumber, Property property, boolean lazyAvailable) {
        String mappedUnsavedValue = ((KeyValue)property.getValue()).getNullValue();
        VersionValue unsavedValue = UnsavedValueFactory.getUnsavedVersionValue(mappedUnsavedValue, PropertyFactory.getGetter(property), (VersionType)property.getType(), PropertyFactory.getConstructor(property.getPersistentClass()));
        boolean lazy = lazyAvailable && property.isLazy();
        return new VersionProperty(persister, sessionFactory, attributeNumber, property.getName(), property.getValue().getType(), new BaselineAttributeInformation.Builder().setLazy(lazy).setInsertable(property.isInsertable()).setUpdateable(property.isUpdateable()).setValueGenerationStrategy(property.getValueGenerationStrategy()).setNullable(property.isOptional()).setDirtyCheckable(property.isUpdateable() && !lazy).setVersionable(property.isOptimisticLocked()).setCascadeStyle(property.getCascadeStyle()).createInformation(), unsavedValue);
    }

    public static VersionProperty buildVersionProperty(EntityPersister persister, BasicAttributeBinding property, boolean lazyAvailable) {
        throw new NotYetImplementedException();
    }

    public static NonIdentifierAttribute buildEntityBasedAttribute(EntityPersister persister, SessionFactoryImplementor sessionFactory, int attributeNumber, Property property, boolean lazyAvailable) {
        Type type = property.getValue().getType();
        NonIdentifierAttributeNature nature = PropertyFactory.decode(type);
        boolean alwaysDirtyCheck = type.isAssociationType() && ((AssociationType)type).isAlwaysDirtyChecked();
        switch (nature) {
            case BASIC: {
                return new EntityBasedBasicAttribute(persister, sessionFactory, attributeNumber, property.getName(), type, new BaselineAttributeInformation.Builder().setLazy(lazyAvailable && property.isLazy()).setInsertable(property.isInsertable()).setUpdateable(property.isUpdateable()).setValueGenerationStrategy(property.getValueGenerationStrategy()).setNullable(property.isOptional()).setDirtyCheckable(alwaysDirtyCheck || property.isUpdateable()).setVersionable(property.isOptimisticLocked()).setCascadeStyle(property.getCascadeStyle()).setFetchMode(property.getValue().getFetchMode()).createInformation());
            }
            case COMPOSITE: {
                return new EntityBasedCompositionAttribute(persister, sessionFactory, attributeNumber, property.getName(), (CompositeType)type, new BaselineAttributeInformation.Builder().setLazy(lazyAvailable && property.isLazy()).setInsertable(property.isInsertable()).setUpdateable(property.isUpdateable()).setValueGenerationStrategy(property.getValueGenerationStrategy()).setNullable(property.isOptional()).setDirtyCheckable(alwaysDirtyCheck || property.isUpdateable()).setVersionable(property.isOptimisticLocked()).setCascadeStyle(property.getCascadeStyle()).setFetchMode(property.getValue().getFetchMode()).createInformation());
            }
            case ENTITY: 
            case ANY: 
            case COLLECTION: {
                return new EntityBasedAssociationAttribute(persister, sessionFactory, attributeNumber, property.getName(), (AssociationType)type, new BaselineAttributeInformation.Builder().setLazy(lazyAvailable && property.isLazy()).setInsertable(property.isInsertable()).setUpdateable(property.isUpdateable()).setValueGenerationStrategy(property.getValueGenerationStrategy()).setNullable(property.isOptional()).setDirtyCheckable(alwaysDirtyCheck || property.isUpdateable()).setVersionable(property.isOptimisticLocked()).setCascadeStyle(property.getCascadeStyle()).setFetchMode(property.getValue().getFetchMode()).createInformation());
            }
        }
        throw new HibernateException("Internal error");
    }

    private static NonIdentifierAttributeNature decode(Type type) {
        if (type.isAssociationType()) {
            AssociationType associationType = (AssociationType)type;
            if (type.isComponentType()) {
                return NonIdentifierAttributeNature.ANY;
            }
            return type.isCollectionType() ? NonIdentifierAttributeNature.COLLECTION : NonIdentifierAttributeNature.ENTITY;
        }
        if (type.isComponentType()) {
            return NonIdentifierAttributeNature.COMPOSITE;
        }
        return NonIdentifierAttributeNature.BASIC;
    }

    @Deprecated
    public static StandardProperty buildStandardProperty(Property property, boolean lazyAvailable) {
        Type type = property.getValue().getType();
        boolean alwaysDirtyCheck = type.isAssociationType() && ((AssociationType)type).isAlwaysDirtyChecked();
        return new StandardProperty(property.getName(), type, lazyAvailable && property.isLazy(), property.isInsertable(), property.isUpdateable(), property.getValueGenerationStrategy(), property.isOptional(), alwaysDirtyCheck || property.isUpdateable(), property.isOptimisticLocked(), property.getCascadeStyle(), property.getValue().getFetchMode());
    }

    public static StandardProperty buildStandardProperty(AttributeBinding property, boolean lazyAvailable) {
        boolean alwaysDirtyCheck;
        Type type = property.getHibernateTypeDescriptor().getResolvedTypeMapping();
        boolean bl = alwaysDirtyCheck = type.isAssociationType() && ((AssociationType)type).isAlwaysDirtyChecked();
        if (property.getAttribute().isSingular()) {
            SingularAttributeBinding singularAttributeBinding = (SingularAttributeBinding)property;
            CascadeStyle cascadeStyle = singularAttributeBinding.isAssociation() ? ((AssociationAttributeBinding)((Object)singularAttributeBinding)).getCascadeStyle() : CascadeStyles.NONE;
            FetchMode fetchMode = singularAttributeBinding.isAssociation() ? ((AssociationAttributeBinding)((Object)singularAttributeBinding)).getFetchMode() : FetchMode.DEFAULT;
            return new StandardProperty(singularAttributeBinding.getAttribute().getName(), type, lazyAvailable && singularAttributeBinding.isLazy(), true, true, null, singularAttributeBinding.isNullable(), alwaysDirtyCheck || PropertyFactory.areAllValuesIncludedInUpdate(singularAttributeBinding), singularAttributeBinding.isIncludedInOptimisticLocking(), cascadeStyle, fetchMode);
        }
        AbstractPluralAttributeBinding pluralAttributeBinding = (AbstractPluralAttributeBinding)property;
        CascadeStyle cascadeStyle = pluralAttributeBinding.isAssociation() ? pluralAttributeBinding.getCascadeStyle() : CascadeStyles.NONE;
        FetchMode fetchMode = pluralAttributeBinding.isAssociation() ? pluralAttributeBinding.getFetchMode() : FetchMode.DEFAULT;
        return new StandardProperty(pluralAttributeBinding.getAttribute().getName(), type, lazyAvailable && pluralAttributeBinding.isLazy(), true, true, null, false, true, pluralAttributeBinding.isIncludedInOptimisticLocking(), cascadeStyle, fetchMode);
    }

    private static boolean areAllValuesIncludedInUpdate(SingularAttributeBinding attributeBinding) {
        if (attributeBinding.hasDerivedValue()) {
            return false;
        }
        for (SimpleValueBinding valueBinding : attributeBinding.getSimpleValueBindings()) {
            if (valueBinding.isIncludeInUpdate()) continue;
            return false;
        }
        return true;
    }

    private static Constructor getConstructor(PersistentClass persistentClass) {
        if (persistentClass == null || !persistentClass.hasPojoRepresentation()) {
            return null;
        }
        try {
            return ReflectHelper.getDefaultConstructor(persistentClass.getMappedClass());
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Constructor getConstructor(EntityBinding entityBinding) {
        if (entityBinding == null || entityBinding.getEntity() == null) {
            return null;
        }
        try {
            return ReflectHelper.getDefaultConstructor(entityBinding.getEntity().getClassReference());
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Getter getGetter(Property mappingProperty) {
        if (mappingProperty == null || !mappingProperty.getPersistentClass().hasPojoRepresentation()) {
            return null;
        }
        PropertyAccessor pa = PropertyAccessorFactory.getPropertyAccessor(mappingProperty, EntityMode.POJO);
        return pa.getGetter(mappingProperty.getPersistentClass().getMappedClass(), mappingProperty.getName());
    }

    private static Getter getGetter(AttributeBinding mappingProperty) {
        if (mappingProperty == null || mappingProperty.getContainer().getClassReference() == null) {
            return null;
        }
        PropertyAccessor pa = PropertyAccessorFactory.getPropertyAccessor(mappingProperty, EntityMode.POJO);
        return pa.getGetter(mappingProperty.getContainer().getClassReference(), mappingProperty.getAttribute().getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NonIdentifierAttributeNature {
        BASIC,
        COMPOSITE,
        ANY,
        ENTITY,
        COLLECTION;

    }
}

