/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.relational.AbstractConstraint;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.Constraint;
import org.hibernate.metamodel.relational.Table;

public class UniqueKey
extends AbstractConstraint
implements Constraint {
    protected UniqueKey(Table table, String name) {
        super(table, name);
    }

    public String getExportIdentifier() {
        StringBuilder sb = new StringBuilder(this.getTable().getLoggableValueQualifier());
        sb.append(".UK");
        for (Column column : this.getColumns()) {
            sb.append('_').append(column.getColumnName().getName());
        }
        return sb.toString();
    }

    public String[] sqlCreateStrings(Dialect dialect) {
        String s = dialect.getUniqueDelegate().getAlterTableToAddUniqueKeyCommand(this);
        return StringHelper.toArrayElement(s);
    }

    public String[] sqlDropStrings(Dialect dialect) {
        String s = dialect.getUniqueDelegate().getAlterTableToDropUniqueKeyCommand(this);
        return StringHelper.toArrayElement(s);
    }

    protected String sqlConstraintStringInAlterTable(Dialect dialect) {
        return "";
    }
}

