/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.metamodel.relational.Column;
import org.hibernate.metamodel.relational.DerivedValue;
import org.hibernate.metamodel.relational.ForeignKey;
import org.hibernate.metamodel.relational.PrimaryKey;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableSpecification
implements TableSpecification {
    private static final AtomicInteger tableCounter = new AtomicInteger(0);
    private final int tableNumber;
    private final LinkedHashMap<String, SimpleValue> values = new LinkedHashMap();
    private final PrimaryKey primaryKey = new PrimaryKey(this);
    private final List<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();

    public AbstractTableSpecification() {
        this.tableNumber = tableCounter.getAndIncrement();
    }

    @Override
    public int getTableNumber() {
        return this.tableNumber;
    }

    @Override
    public Iterable<SimpleValue> values() {
        return this.values.values();
    }

    @Override
    public Column locateOrCreateColumn(String name) {
        if (this.values.containsKey(name)) {
            return (Column)this.values.get(name);
        }
        Column column = new Column((TableSpecification)this, this.values.size(), name);
        this.values.put(name, column);
        return column;
    }

    @Override
    public DerivedValue locateOrCreateDerivedValue(String fragment) {
        if (this.values.containsKey(fragment)) {
            return (DerivedValue)this.values.get(fragment);
        }
        DerivedValue value = new DerivedValue(this, this.values.size(), fragment);
        this.values.put(fragment, value);
        return value;
    }

    @Override
    public Tuple createTuple(String name) {
        return new Tuple(this, name);
    }

    @Override
    public Iterable<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public ForeignKey createForeignKey(TableSpecification targetTable, String name) {
        ForeignKey fk = new ForeignKey(this, targetTable, name);
        this.foreignKeys.add(fk);
        return fk;
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }
}

