/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.relational.AuxiliaryDatabaseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuxiliaryDatabaseObject
implements AuxiliaryDatabaseObject {
    private static final String EXPORT_IDENTIFIER_PREFIX = "auxiliary-object-" + UUID.randomUUID();
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final String exportIdentifier;
    private final Set<String> dialectScopes;

    protected AbstractAuxiliaryDatabaseObject(Set<String> dialectScopes) {
        this.dialectScopes = dialectScopes == null ? new HashSet() : dialectScopes;
        this.exportIdentifier = EXPORT_IDENTIFIER_PREFIX + '.' + counter.getAndIncrement();
    }

    public void addDialectScope(String dialectName) {
        this.dialectScopes.add(dialectName);
    }

    public Iterable<String> getDialectScopes() {
        return this.dialectScopes;
    }

    @Override
    public boolean appliesToDialect(Dialect dialect) {
        return this.dialectScopes.isEmpty() || this.dialectScopes.contains(dialect.getClass().getName());
    }

    @Override
    public String getExportIdentifier() {
        return this.exportIdentifier;
    }
}

