/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueKey
extends Constraint {
    private Map<Column, String> columnOrderMap = new HashMap<Column, String>();

    @Override
    public String sqlConstraintString(Dialect dialect, String constraintName, String defaultCatalog, String defaultSchema) {
        return "";
    }

    @Override
    public String sqlCreateString(Dialect dialect, Mapping p, String defaultCatalog, String defaultSchema) {
        return dialect.getUniqueDelegate().getAlterTableToAddUniqueKeyCommand(this, defaultCatalog, defaultSchema);
    }

    @Override
    public String sqlDropString(Dialect dialect, String defaultCatalog, String defaultSchema) {
        return dialect.getUniqueDelegate().getAlterTableToDropUniqueKeyCommand(this, defaultCatalog, defaultSchema);
    }

    public void addColumn(Column column, String order) {
        this.addColumn(column);
        if (StringHelper.isNotEmpty(order)) {
            this.columnOrderMap.put(column, order);
        }
    }

    public Map<Column, String> getColumnOrderMap() {
        return this.columnOrderMap;
    }

    @Override
    public String generatedConstraintNamePrefix() {
        return "UK_";
    }
}

