/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class SequenceStructure
implements DatabaseStructure {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)SequenceStructure.class.getName());
    private final String sequenceName;
    private final int initialValue;
    private final int incrementSize;
    private final Class numberType;
    private final String sql;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public SequenceStructure(Dialect dialect, String sequenceName, int initialValue, int incrementSize, Class numberType) {
        this.sequenceName = sequenceName;
        this.initialValue = initialValue;
        this.incrementSize = incrementSize;
        this.numberType = numberType;
        this.sql = dialect.getSequenceNextValString(sequenceName);
    }

    public String getName() {
        return this.sequenceName;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public int getTimesAccessed() {
        return this.accessCounter;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public AccessCallback buildCallback(final SessionImplementor session) {
        return new AccessCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            public IntegralDataTypeHolder getNextValue() {
                SequenceStructure.this.accessCounter++;
                try {
                    PreparedStatement st = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(SequenceStructure.this.sql);
                    try {
                        IntegralDataTypeHolder integralDataTypeHolder;
                        ResultSet rs = session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(st);
                        try {
                            rs.next();
                            IntegralDataTypeHolder value = IdentifierGeneratorHelper.getIntegralDataTypeHolder(SequenceStructure.this.numberType);
                            value.initialize(rs, 1L);
                            if (LOG.isDebugEnabled()) {
                                LOG.debugf("Sequence value obtained: %s", value.makeValue());
                            }
                            integralDataTypeHolder = value;
                        }
                        catch (Throwable throwable) {
                            try {
                                session.getTransactionCoordinator().getJdbcCoordinator().release(rs, st);
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            session.getTransactionCoordinator().getJdbcCoordinator().release(rs, st);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return integralDataTypeHolder;
                    }
                    finally {
                        session.getTransactionCoordinator().getJdbcCoordinator().release(st);
                    }
                }
                catch (SQLException sqle) {
                    throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not get next sequence value", SequenceStructure.this.sql);
                }
            }

            public String getTenantIdentifier() {
                return session.getTenantIdentifier();
            }
        };
    }

    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        int sourceIncrementSize = this.applyIncrementSizeToSourceValues ? this.incrementSize : 1;
        return dialect.getCreateSequenceStrings(this.sequenceName, this.initialValue, sourceIncrementSize);
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    public boolean isPhysicalSequence() {
        return true;
    }
}

