/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class GUIDGenerator
implements IdentifierGenerator {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(GUIDGenerator.class);
    private static boolean WARNED;

    public GUIDGenerator() {
        if (!WARNED) {
            WARNED = true;
            LOG.deprecatedUuidGenerator(UUIDGenerator.class.getName(), UUIDGenerationStrategy.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        String sql = session.getFactory().getDialect().getSelectGUIDString();
        PreparedStatement st = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(sql);
        try {
            String result;
            ResultSet rs = session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(st);
            try {
                if (!rs.next()) {
                    throw new HibernateException("The database returned no GUID identity value");
                }
                result = rs.getString(1);
            }
            finally {
                session.getTransactionCoordinator().getJdbcCoordinator().release(rs, st);
            }
            LOG.guidGenerated(result);
            String string = result;
            session.getTransactionCoordinator().getJdbcCoordinator().release(st);
            return string;
        }
        catch (Throwable throwable) {
            try {
                session.getTransactionCoordinator().getJdbcCoordinator().release(st);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not retrieve GUID", sql);
            }
        }
    }
}

