/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.bytecode.instrumentation.spi.FieldInterceptor;
import org.hibernate.engine.internal.EntityEntryExtraStateHolder;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.EntityEntryExtraState;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityEntry
implements Serializable {
    private final Serializable id;
    private Object[] loadedState;
    private Object version;
    private final EntityPersister persister;
    private transient EntityKey cachedEntityKey;
    private final transient Object rowId;
    private final transient PersistenceContext persistenceContext;
    private EntityEntryExtraState next;
    private transient int compressedState;
    private static final Object[] DEFAULT_DELETED_STATE = null;

    @Deprecated
    public EntityEntry(Status status, Object[] loadedState, Object rowId, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, EntityMode entityMode, String tenantId, boolean disableVersionIncrement, boolean lazyPropertiesAreUnfetched, PersistenceContext persistenceContext) {
        this(status, loadedState, rowId, id, version, lockMode, existsInDatabase, persister, disableVersionIncrement, lazyPropertiesAreUnfetched, persistenceContext);
    }

    public EntityEntry(Status status, Object[] loadedState, Object rowId, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, EntityPersister persister, boolean disableVersionIncrement, boolean lazyPropertiesAreUnfetched, PersistenceContext persistenceContext) {
        this.setCompressedValue(EnumState.STATUS, status);
        this.setCompressedValue(EnumState.PREVIOUS_STATUS, null);
        if (status != Status.READ_ONLY) {
            this.loadedState = loadedState;
        }
        this.id = id;
        this.rowId = rowId;
        this.setCompressedValue(BooleanState.EXISTS_IN_DATABASE, existsInDatabase);
        this.version = version;
        this.setCompressedValue(EnumState.LOCK_MODE, lockMode);
        this.setCompressedValue(BooleanState.IS_BEING_REPLICATED, disableVersionIncrement);
        this.setCompressedValue(BooleanState.LOADED_WITH_LAZY_PROPERTIES_UNFETCHED, lazyPropertiesAreUnfetched);
        this.persister = persister;
        this.persistenceContext = persistenceContext;
    }

    private EntityEntry(SessionFactoryImplementor factory, String entityName, Serializable id, Status status, Status previousStatus, Object[] loadedState, Object[] deletedState, Object version, LockMode lockMode, boolean existsInDatabase, boolean isBeingReplicated, boolean loadedWithLazyPropertiesUnfetched, PersistenceContext persistenceContext) {
        this.persister = factory == null ? null : factory.getEntityPersister(entityName);
        this.id = id;
        this.setCompressedValue(EnumState.STATUS, status);
        this.setCompressedValue(EnumState.PREVIOUS_STATUS, previousStatus);
        this.loadedState = loadedState;
        this.setDeletedState(deletedState);
        this.version = version;
        this.setCompressedValue(EnumState.LOCK_MODE, lockMode);
        this.setCompressedValue(BooleanState.EXISTS_IN_DATABASE, existsInDatabase);
        this.setCompressedValue(BooleanState.IS_BEING_REPLICATED, isBeingReplicated);
        this.setCompressedValue(BooleanState.LOADED_WITH_LAZY_PROPERTIES_UNFETCHED, loadedWithLazyPropertiesUnfetched);
        this.rowId = null;
        this.persistenceContext = persistenceContext;
    }

    public LockMode getLockMode() {
        return (LockMode)((Object)this.getCompressedValue(EnumState.LOCK_MODE));
    }

    public void setLockMode(LockMode lockMode) {
        this.setCompressedValue(EnumState.LOCK_MODE, lockMode);
    }

    public Status getStatus() {
        return (Status)((Object)this.getCompressedValue(EnumState.STATUS));
    }

    private Status getPreviousStatus() {
        return (Status)((Object)this.getCompressedValue(EnumState.PREVIOUS_STATUS));
    }

    public void setStatus(Status status) {
        Status currentStatus;
        if (status == Status.READ_ONLY) {
            this.loadedState = null;
        }
        if ((currentStatus = this.getStatus()) != status) {
            this.setCompressedValue(EnumState.PREVIOUS_STATUS, currentStatus);
            this.setCompressedValue(EnumState.STATUS, status);
        }
    }

    public Serializable getId() {
        return this.id;
    }

    public Object[] getLoadedState() {
        return this.loadedState;
    }

    public Object[] getDeletedState() {
        EntityEntryExtraStateHolder extra = this.getExtraState(EntityEntryExtraStateHolder.class);
        return extra != null ? extra.getDeletedState() : DEFAULT_DELETED_STATE;
    }

    public void setDeletedState(Object[] deletedState) {
        EntityEntryExtraStateHolder extra = this.getExtraState(EntityEntryExtraStateHolder.class);
        if (extra == null && deletedState == DEFAULT_DELETED_STATE) {
            return;
        }
        if (extra == null) {
            extra = new EntityEntryExtraStateHolder();
            this.addExtraState(extra);
        }
        extra.setDeletedState(deletedState);
    }

    public boolean isExistsInDatabase() {
        return this.getCompressedValue(BooleanState.EXISTS_IN_DATABASE);
    }

    public Object getVersion() {
        return this.version;
    }

    public EntityPersister getPersister() {
        return this.persister;
    }

    public EntityKey getEntityKey() {
        if (this.cachedEntityKey == null) {
            if (this.getId() == null) {
                throw new IllegalStateException("cannot generate an EntityKey when id is null.");
            }
            this.cachedEntityKey = new EntityKey(this.getId(), this.getPersister());
        }
        return this.cachedEntityKey;
    }

    public String getEntityName() {
        return this.persister == null ? null : this.persister.getEntityName();
    }

    public boolean isBeingReplicated() {
        return this.getCompressedValue(BooleanState.IS_BEING_REPLICATED);
    }

    public Object getRowId() {
        return this.rowId;
    }

    public void postUpdate(Object entity, Object[] updatedState, Object nextVersion) {
        FieldInterceptor interceptor;
        this.loadedState = updatedState;
        this.setLockMode(LockMode.WRITE);
        if (this.getPersister().isVersioned()) {
            this.version = nextVersion;
            this.getPersister().setPropertyValue(entity, this.getPersister().getVersionProperty(), nextVersion);
        }
        if (this.getPersister().getInstrumentationMetadata().isInstrumented() && (interceptor = this.getPersister().getInstrumentationMetadata().extractInterceptor(entity)) != null) {
            interceptor.clearDirty();
        }
        if (entity instanceof SelfDirtinessTracker) {
            ((SelfDirtinessTracker)entity).$$_hibernate_clearDirtyAttributes();
        }
        this.persistenceContext.getSession().getFactory().getCustomEntityDirtinessStrategy().resetDirty(entity, this.getPersister(), (Session)((Object)this.persistenceContext.getSession()));
    }

    public void postDelete() {
        this.setCompressedValue(EnumState.PREVIOUS_STATUS, this.getStatus());
        this.setCompressedValue(EnumState.STATUS, Status.GONE);
        this.setCompressedValue(BooleanState.EXISTS_IN_DATABASE, false);
    }

    public void postInsert(Object[] insertedState) {
        this.setCompressedValue(BooleanState.EXISTS_IN_DATABASE, true);
    }

    public boolean isNullifiable(boolean earlyInsert, SessionImplementor session) {
        if (this.getStatus() == Status.SAVING) {
            return true;
        }
        if (earlyInsert) {
            return !this.isExistsInDatabase();
        }
        return session.getPersistenceContext().getNullifiableEntityKeys().contains(this.getEntityKey());
    }

    public Object getLoadedValue(String propertyName) {
        if (this.loadedState == null || propertyName == null) {
            return null;
        }
        int propertyIndex = ((UniqueKeyLoadable)this.persister).getPropertyIndex(propertyName);
        return this.loadedState[propertyIndex];
    }

    public boolean requiresDirtyCheck(Object entity) {
        return this.isModifiableEntity() && !this.isUnequivocallyNonDirty(entity);
    }

    private boolean isUnequivocallyNonDirty(Object entity) {
        if (entity instanceof SelfDirtinessTracker) {
            return ((SelfDirtinessTracker)entity).$$_hibernate_hasDirtyAttributes();
        }
        CustomEntityDirtinessStrategy customEntityDirtinessStrategy = this.persistenceContext.getSession().getFactory().getCustomEntityDirtinessStrategy();
        if (customEntityDirtinessStrategy.canDirtyCheck(entity, this.getPersister(), (Session)((Object)this.persistenceContext.getSession()))) {
            return !customEntityDirtinessStrategy.isDirty(entity, this.getPersister(), (Session)((Object)this.persistenceContext.getSession()));
        }
        if (this.getPersister().hasMutableProperties()) {
            return false;
        }
        if (this.getPersister().getInstrumentationMetadata().isInstrumented()) {
            return !this.getPersister().getInstrumentationMetadata().extractInterceptor(entity).isDirty();
        }
        return false;
    }

    public boolean isModifiableEntity() {
        Status status = this.getStatus();
        Status previousStatus = this.getPreviousStatus();
        return this.getPersister().isMutable() && status != Status.READ_ONLY && (status != Status.DELETED || previousStatus != Status.READ_ONLY);
    }

    public void forceLocked(Object entity, Object nextVersion) {
        this.loadedState[this.persister.getVersionProperty()] = this.version = nextVersion;
        this.setLockMode(LockMode.FORCE);
        this.persister.setPropertyValue(entity, this.getPersister().getVersionProperty(), nextVersion);
    }

    public boolean isReadOnly() {
        Status status = this.getStatus();
        if (status != Status.MANAGED && status != Status.READ_ONLY) {
            throw new HibernateException("instance was not in a valid state");
        }
        return status == Status.READ_ONLY;
    }

    public void setReadOnly(boolean readOnly, Object entity) {
        if (readOnly == this.isReadOnly()) {
            return;
        }
        if (readOnly) {
            this.setStatus(Status.READ_ONLY);
            this.loadedState = null;
        } else {
            if (!this.persister.isMutable()) {
                throw new IllegalStateException("Cannot make an immutable entity modifiable.");
            }
            this.setStatus(Status.MANAGED);
            this.loadedState = this.getPersister().getPropertyValues(entity);
            this.persistenceContext.getNaturalIdHelper().manageLocalNaturalIdCrossReference(this.persister, this.id, this.loadedState, null, CachedNaturalIdValueSource.LOAD);
        }
    }

    public String toString() {
        return "EntityEntry" + MessageHelper.infoString(this.getPersister().getEntityName(), this.id) + '(' + (Object)((Object)this.getStatus()) + ')';
    }

    public boolean isLoadedWithLazyPropertiesUnfetched() {
        return this.getCompressedValue(BooleanState.LOADED_WITH_LAZY_PROPERTIES_UNFETCHED);
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        Status previousStatus = this.getPreviousStatus();
        oos.writeObject(this.getEntityName());
        oos.writeObject(this.id);
        oos.writeObject(this.getStatus().name());
        oos.writeObject(previousStatus == null ? "" : previousStatus.name());
        oos.writeObject(this.loadedState);
        oos.writeObject(this.getDeletedState());
        oos.writeObject(this.version);
        oos.writeObject(this.getLockMode().toString());
        oos.writeBoolean(this.isExistsInDatabase());
        oos.writeBoolean(this.isBeingReplicated());
        oos.writeBoolean(this.isLoadedWithLazyPropertiesUnfetched());
    }

    public static EntityEntry deserialize(ObjectInputStream ois, PersistenceContext persistenceContext) throws IOException, ClassNotFoundException {
        String previousStatusString;
        return new EntityEntry(persistenceContext.getSession().getFactory(), (String)ois.readObject(), (Serializable)ois.readObject(), Status.valueOf((String)ois.readObject()), (previousStatusString = (String)ois.readObject()).length() == 0 ? null : Status.valueOf(previousStatusString), (Object[])ois.readObject(), (Object[])ois.readObject(), ois.readObject(), LockMode.valueOf((String)ois.readObject()), ois.readBoolean(), ois.readBoolean(), ois.readBoolean(), persistenceContext);
    }

    public void addExtraState(EntityEntryExtraState extraState) {
        if (this.next == null) {
            this.next = extraState;
        } else {
            this.next.addExtraState(extraState);
        }
    }

    public <T extends EntityEntryExtraState> T getExtraState(Class<T> extraStateType) {
        if (this.next == null) {
            return null;
        }
        if (extraStateType.isAssignableFrom(this.next.getClass())) {
            return (T)this.next;
        }
        return this.next.getExtraState(extraStateType);
    }

    private <E extends Enum<E>> void setCompressedValue(EnumState<E> state, E value) {
        this.compressedState &= ((EnumState)state).getUnsetMask();
        this.compressedState |= ((EnumState)state).getValue(value) << ((EnumState)state).getOffset();
    }

    private <E extends Enum<E>> E getCompressedValue(EnumState<E> state) {
        int index = ((this.compressedState & ((EnumState)state).getMask()) >> ((EnumState)state).getOffset()) - 1;
        return (E)(index == -1 ? null : ((EnumState)state).getEnumConstants()[index]);
    }

    private void setCompressedValue(BooleanState state, boolean value) {
        this.compressedState &= state.getUnsetMask();
        this.compressedState |= state.getValue(value) << state.getOffset();
    }

    private boolean getCompressedValue(BooleanState state) {
        return (this.compressedState & state.getMask()) >> state.getOffset() == 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BooleanState {
        EXISTS_IN_DATABASE(13),
        IS_BEING_REPLICATED(14),
        LOADED_WITH_LAZY_PROPERTIES_UNFETCHED(15);

        private final int offset;
        private final int mask;
        private final int unsetMask;

        private BooleanState(int offset) {
            this.offset = offset;
            this.mask = 1 << offset;
            this.unsetMask = 0xFFFF & ~this.mask;
        }

        private int getValue(boolean value) {
            return value ? 1 : 0;
        }

        private int getOffset() {
            return this.offset;
        }

        private int getMask() {
            return this.mask;
        }

        private int getUnsetMask() {
            return this.unsetMask;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumState<E extends Enum<E>> {
        private static final EnumState<LockMode> LOCK_MODE = new EnumState<LockMode>(0, LockMode.class);
        private static final EnumState<Status> STATUS = new EnumState<Status>(4, Status.class);
        private static final EnumState<Status> PREVIOUS_STATUS = new EnumState<Status>(8, Status.class);
        private final int offset;
        private final E[] enumConstants;
        private final int mask;
        private final int unsetMask;

        private EnumState(int offset, Class<E> enumType) {
            Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
            if (enumConstants.length > 15) {
                throw new AssertionFailure("Cannot store enum type " + enumType.getName() + " in compressed state as it has too many values.");
            }
            this.offset = offset;
            this.enumConstants = enumConstants;
            this.mask = 15 << offset;
            this.unsetMask = 0xFFFF & ~this.mask;
        }

        private int getValue(E value) {
            return value != null ? ((Enum)value).ordinal() + 1 : 0;
        }

        private int getOffset() {
            return this.offset;
        }

        private int getMask() {
            return this.mask;
        }

        private int getUnsetMask() {
            return this.unsetMask;
        }

        private E[] getEnumConstants() {
            return this.enumConstants;
        }
    }
}

