/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.cursor.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.cursor.spi.RefCursorSupport;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.spi.InjectService;
import org.jboss.logging.Logger;

public class StandardRefCursorSupport
implements RefCursorSupport {
    private static final Logger log = Logger.getLogger(StandardRefCursorSupport.class);
    private JdbcServices jdbcServices;
    private static Integer refCursorTypeCode;
    private static Method getResultSetByPositionMethod;
    private static Method getResultSetByNameMethod;

    @InjectService
    public void injectJdbcServices(JdbcServices jdbcServices) {
        this.jdbcServices = jdbcServices;
    }

    public void registerRefCursorParameter(CallableStatement statement, int position) {
        if (this.jdbcServices.getExtractedMetaDataSupport().supportsRefCursors()) {
            try {
                statement.registerOutParameter(position, this.refCursorTypeCode());
            }
            catch (SQLException e) {
                throw this.jdbcServices.getSqlExceptionHelper().convert(e, "Error registering REF_CURSOR parameter [" + position + "]");
            }
        }
        try {
            this.jdbcServices.getDialect().registerResultSetOutParameter(statement, position);
        }
        catch (SQLException e) {
            throw this.jdbcServices.getSqlExceptionHelper().convert(e, "Error asking dialect to register ref cursor parameter [" + position + "]");
        }
    }

    public void registerRefCursorParameter(CallableStatement statement, String name) {
        if (this.jdbcServices.getExtractedMetaDataSupport().supportsRefCursors()) {
            try {
                statement.registerOutParameter(name, this.refCursorTypeCode());
            }
            catch (SQLException e) {
                throw this.jdbcServices.getSqlExceptionHelper().convert(e, "Error registering REF_CURSOR parameter [" + name + "]");
            }
        }
        try {
            this.jdbcServices.getDialect().registerResultSetOutParameter(statement, name);
        }
        catch (SQLException e) {
            throw this.jdbcServices.getSqlExceptionHelper().convert(e, "Error asking dialect to register ref cursor parameter [" + name + "]");
        }
    }

    public ResultSet getResultSet(CallableStatement statement, int position) {
        if (this.jdbcServices.getExtractedMetaDataSupport().supportsRefCursors()) {
            try {
                return (ResultSet)this.getResultSetByPositionMethod().invoke((Object)statement, position, ResultSet.class);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof SQLException) {
                    throw this.jdbcServices.getSqlExceptionHelper().convert((SQLException)e.getTargetException(), "Error extracting REF_CURSOR parameter [" + position + "]");
                }
                throw new HibernateException("Unexpected error extracting REF_CURSOR parameter [" + position + "]", e.getTargetException());
            }
            catch (Exception e) {
                throw new HibernateException("Unexpected error extracting REF_CURSOR parameter [" + position + "]", e);
            }
        }
        try {
            return this.jdbcServices.getDialect().getResultSet(statement, position);
        }
        catch (SQLException e) {
            throw this.jdbcServices.getSqlExceptionHelper().convert(e, "Error asking dialect to extract ResultSet from CallableStatement parameter [" + position + "]");
        }
    }

    public ResultSet getResultSet(CallableStatement statement, String name) {
        if (this.jdbcServices.getExtractedMetaDataSupport().supportsRefCursors()) {
            try {
                return (ResultSet)this.getResultSetByNameMethod().invoke((Object)statement, name, ResultSet.class);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof SQLException) {
                    throw this.jdbcServices.getSqlExceptionHelper().convert((SQLException)e.getTargetException(), "Error extracting REF_CURSOR parameter [" + name + "]");
                }
                throw new HibernateException("Unexpected error extracting REF_CURSOR parameter [" + name + "]", e.getTargetException());
            }
            catch (Exception e) {
                throw new HibernateException("Unexpected error extracting REF_CURSOR parameter [" + name + "]", e);
            }
        }
        try {
            return this.jdbcServices.getDialect().getResultSet(statement, name);
        }
        catch (SQLException e) {
            throw this.jdbcServices.getSqlExceptionHelper().convert(e, "Error asking dialect to extract ResultSet from CallableStatement parameter [" + name + "]");
        }
    }

    public static boolean supportsRefCursors(DatabaseMetaData meta) {
        try {
            return (Boolean)meta.getClass().getMethod("supportsRefCursors", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.trace((Object)"JDBC DatabaseMetaData class does not define supportsRefCursors method...");
        }
        catch (Exception e) {
            log.debug((Object)("Unexpected error trying to gauge level of JDBC REF_CURSOR support : " + e.getMessage()));
        }
        return false;
    }

    private int refCursorTypeCode() {
        if (refCursorTypeCode == null) {
            try {
                refCursorTypeCode = (Integer)Types.class.getField("REF_CURSOR").get(null);
            }
            catch (NoSuchFieldException e) {
                throw new HibernateException("java.sql.Types class does not define REF_CURSOR field...");
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Unexpected error trying to determine REF_CURSOR field value : " + e.getMessage());
            }
        }
        return refCursorTypeCode;
    }

    private Method getResultSetByPositionMethod() {
        if (getResultSetByPositionMethod == null) {
            try {
                getResultSetByPositionMethod = CallableStatement.class.getMethod("getObject", Integer.TYPE, Class.class);
            }
            catch (NoSuchMethodException e) {
                throw new HibernateException("CallableStatement class does not define getObject(int,Class) method");
            }
            catch (Exception e) {
                throw new HibernateException("Unexpected error trying to access CallableStatement#getObject(int,Class)");
            }
        }
        return getResultSetByPositionMethod;
    }

    private Method getResultSetByNameMethod() {
        if (getResultSetByNameMethod == null) {
            try {
                getResultSetByNameMethod = CallableStatement.class.getMethod("getObject", String.class, Class.class);
            }
            catch (NoSuchMethodException e) {
                throw new HibernateException("CallableStatement class does not define getObject(String,Class) method");
            }
            catch (Exception e) {
                throw new HibernateException("Unexpected error trying to access CallableStatement#getObject(String,Class)");
            }
        }
        return getResultSetByNameMethod;
    }
}

