/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.SessionEventListener;
import org.hibernate.engine.spi.SessionEventListenerManager;

public class SessionEventListenerManagerImpl
implements SessionEventListenerManager,
Serializable {
    private List<SessionEventListener> listenerList;

    public void addListener(SessionEventListener ... listeners) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<SessionEventListener>();
        }
        Collections.addAll(this.listenerList, listeners);
    }

    public void transactionCompletion(boolean successful) {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.transactionCompletion(successful);
        }
    }

    public void jdbcConnectionAcquisitionStart() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.jdbcConnectionAcquisitionStart();
        }
    }

    public void jdbcConnectionAcquisitionEnd() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.jdbcConnectionAcquisitionEnd();
        }
    }

    public void jdbcConnectionReleaseStart() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.jdbcConnectionReleaseStart();
        }
    }

    public void jdbcConnectionReleaseEnd() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.jdbcConnectionReleaseEnd();
        }
    }

    public void jdbcPrepareStatementStart() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.jdbcPrepareStatementStart();
        }
    }

    public void jdbcPrepareStatementEnd() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.jdbcPrepareStatementEnd();
        }
    }

    public void jdbcExecuteStatementStart() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.jdbcExecuteStatementStart();
        }
    }

    public void jdbcExecuteStatementEnd() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.jdbcExecuteStatementEnd();
        }
    }

    public void jdbcExecuteBatchStart() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.jdbcExecuteBatchStart();
        }
    }

    public void jdbcExecuteBatchEnd() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.jdbcExecuteBatchEnd();
        }
    }

    public void cachePutStart() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.cachePutStart();
        }
    }

    public void cachePutEnd() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.cachePutEnd();
        }
    }

    public void cacheGetStart() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.cacheGetStart();
        }
    }

    public void cacheGetEnd(boolean hit) {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.cacheGetEnd(hit);
        }
    }

    public void flushStart() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.flushStart();
        }
    }

    public void flushEnd(int numberOfEntities, int numberOfCollections) {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.flushEnd(numberOfEntities, numberOfCollections);
        }
    }

    public void partialFlushStart() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.partialFlushStart();
        }
    }

    public void partialFlushEnd(int numberOfEntities, int numberOfCollections) {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.partialFlushEnd(numberOfEntities, numberOfCollections);
        }
    }

    public void dirtyCalculationStart() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.dirtyCalculationStart();
        }
    }

    public void dirtyCalculationEnd(boolean dirty) {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.dirtyCalculationEnd(dirty);
        }
    }

    public void end() {
        if (this.listenerList == null) {
            return;
        }
        for (SessionEventListener listener : this.listenerList) {
            listener.end();
        }
    }
}

