/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.relational.UniqueKey;

public class DefaultUniqueDelegate
implements UniqueDelegate {
    protected final Dialect dialect;

    public DefaultUniqueDelegate(Dialect dialect) {
        this.dialect = dialect;
    }

    public String getColumnDefinitionUniquenessFragment(Column column) {
        return "";
    }

    public String getTableCreationUniqueConstraintsFragment(Table table) {
        return "";
    }

    public String getAlterTableToAddUniqueKeyCommand(org.hibernate.mapping.UniqueKey uniqueKey, String defaultCatalog, String defaultSchema) {
        String tableName = uniqueKey.getTable().getQualifiedName(this.dialect, defaultCatalog, defaultSchema);
        String constraintName = this.dialect.quote(uniqueKey.getName());
        return "alter table " + tableName + " add constraint " + constraintName + " " + this.uniqueConstraintSql(uniqueKey);
    }

    protected String uniqueConstraintSql(org.hibernate.mapping.UniqueKey uniqueKey) {
        StringBuilder sb = new StringBuilder();
        sb.append("unique (");
        Iterator<Column> columnIterator = uniqueKey.columnIterator();
        while (columnIterator.hasNext()) {
            Column column = columnIterator.next();
            sb.append(column.getQuotedName(this.dialect));
            if (uniqueKey.getColumnOrderMap().containsKey(column)) {
                sb.append(" ").append(uniqueKey.getColumnOrderMap().get(column));
            }
            if (!columnIterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append(')').toString();
    }

    public String getAlterTableToDropUniqueKeyCommand(org.hibernate.mapping.UniqueKey uniqueKey, String defaultCatalog, String defaultSchema) {
        StringBuilder buf = new StringBuilder("alter table ");
        buf.append(uniqueKey.getTable().getQualifiedName(this.dialect, defaultCatalog, defaultSchema));
        buf.append(" drop constraint ");
        if (this.dialect.supportsIfExistsBeforeConstraintName()) {
            buf.append("if exists ");
        }
        buf.append(this.dialect.quote(uniqueKey.getName()));
        if (this.dialect.supportsIfExistsAfterConstraintName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }

    public String getColumnDefinitionUniquenessFragment(org.hibernate.metamodel.relational.Column column) {
        return "";
    }

    public String getTableCreationUniqueConstraintsFragment(org.hibernate.metamodel.relational.Table table) {
        return "";
    }

    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey) {
        String tableName = uniqueKey.getTable().getQualifiedName(this.dialect);
        String constraintName = this.dialect.quote(uniqueKey.getName());
        return "alter table " + tableName + " add constraint " + constraintName + this.uniqueConstraintSql(uniqueKey);
    }

    protected String uniqueConstraintSql(UniqueKey uniqueKey) {
        StringBuilder sb = new StringBuilder(" unique (");
        Iterator<org.hibernate.metamodel.relational.Column> columnIterator = uniqueKey.getColumns().iterator();
        while (columnIterator.hasNext()) {
            Column column = (Column)((Object)columnIterator.next());
            sb.append(column.getQuotedName(this.dialect));
            if (!columnIterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append(')').toString();
    }

    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey) {
        String tableName = uniqueKey.getTable().getQualifiedName(this.dialect);
        String constraintName = this.dialect.quote(uniqueKey.getName());
        return "alter table " + tableName + " drop constraint " + constraintName;
    }
}

