/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.internal.util.JdbcExceptionHelper;

public class MySQL5Dialect
extends MySQLDialect {
    private static final ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sqle) {
            try {
                int sqlState = Integer.valueOf(JdbcExceptionHelper.extractSqlState(sqle));
                switch (sqlState) {
                    case 23000: {
                        return this.extractUsingTemplate(" for key '", "'", sqle.getMessage());
                    }
                }
                return null;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    };

    protected void registerVarcharTypes() {
        this.registerColumnType(12, "longtext");
        this.registerColumnType(12, 65535L, "varchar($l)");
        this.registerColumnType(-1, "longtext");
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }
}

