/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations.reflection;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.ConstructorResult;
import javax.persistence.Convert;
import javax.persistence.Converts;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.FetchType;
import javax.persistence.FieldResult;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Index;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import javax.persistence.MapKeyTemporal;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NamedStoredProcedureQueries;
import javax.persistence.NamedStoredProcedureQuery;
import javax.persistence.NamedSubgraph;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.ParameterMode;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.QueryHint;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.StoredProcedureParameter;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.ReflectionUtil;
import org.hibernate.cfg.annotations.reflection.PersistentAttributeFilter;
import org.hibernate.cfg.annotations.reflection.XMLContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAOverriddenAnnotationReader
implements AnnotationReader {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(JPAOverriddenAnnotationReader.class);
    private static final String SCHEMA_VALIDATION = "Activate schema validation for more information";
    private static final String WORD_SEPARATOR = "-";
    private static final Map<Class, String> annotationToXml = new HashMap<Class, String>();
    private XMLContext xmlContext;
    private final AnnotatedElement element;
    private String className;
    private String propertyName;
    private PropertyType propertyType;
    private transient Annotation[] annotations;
    private transient Map<Class, Annotation> annotationsMap;
    private transient List<Element> elementsForProperty;
    private AccessibleObject mirroredAttribute;

    public JPAOverriddenAnnotationReader(AnnotatedElement el, XMLContext xmlContext) {
        this.element = el;
        this.xmlContext = xmlContext;
        if (el instanceof Class) {
            Class clazz = (Class)el;
            this.className = clazz.getName();
        } else if (el instanceof Field) {
            Field field = (Field)el;
            this.className = field.getDeclaringClass().getName();
            this.propertyName = field.getName();
            this.propertyType = PropertyType.FIELD;
            String expectedGetter = "get" + Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1);
            try {
                this.mirroredAttribute = field.getDeclaringClass().getDeclaredMethod(expectedGetter, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else if (el instanceof Method) {
            Method method = (Method)el;
            this.className = method.getDeclaringClass().getName();
            this.propertyName = method.getName();
            if (ReflectionUtil.isProperty((Method)method, null, (Filter)PersistentAttributeFilter.INSTANCE)) {
                if (this.propertyName.startsWith("get")) {
                    this.propertyName = Introspector.decapitalize(this.propertyName.substring("get".length()));
                } else if (this.propertyName.startsWith("is")) {
                    this.propertyName = Introspector.decapitalize(this.propertyName.substring("is".length()));
                } else {
                    throw new RuntimeException("Method " + this.propertyName + " is not a property getter");
                }
                this.propertyType = PropertyType.PROPERTY;
                try {
                    this.mirroredAttribute = method.getDeclaringClass().getDeclaredField(this.propertyName);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            } else {
                this.propertyType = PropertyType.METHOD;
            }
        } else {
            this.className = null;
            this.propertyName = null;
        }
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        this.initAnnotations();
        return (T)this.annotationsMap.get(annotationType);
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
        this.initAnnotations();
        return this.annotationsMap.containsKey(annotationType);
    }

    public Annotation[] getAnnotations() {
        this.initAnnotations();
        return this.annotations;
    }

    private void initAnnotations() {
        block12: {
            if (this.annotations != null) break block12;
            XMLContext.Default defaults = this.xmlContext.getDefault(this.className);
            if (this.className != null && this.propertyName == null) {
                Element tree = this.xmlContext.getXMLTree(this.className);
                Annotation[] annotations = this.getPhysicalAnnotations();
                ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.length + 5);
                this.annotationsMap = new HashMap<Class, Annotation>(annotations.length + 5);
                for (Annotation annotation : annotations) {
                    if (annotationToXml.containsKey(annotation.annotationType())) continue;
                    annotationList.add(annotation);
                }
                this.addIfNotNull(annotationList, (Annotation)this.getEntity(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getMappedSuperclass(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getEmbeddable(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getTable(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getSecondaryTables(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getPrimaryKeyJoinColumns(tree, defaults, true));
                this.addIfNotNull(annotationList, (Annotation)this.getIdClass(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getCacheable(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getInheritance(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getDiscriminatorValue(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getDiscriminatorColumn(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getSequenceGenerator(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getTableGenerator(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getNamedQueries(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getNamedNativeQueries(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getNamedStoredProcedureQueries(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getNamedEntityGraphs(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getSqlResultSetMappings(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getExcludeDefaultListeners(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getExcludeSuperclassListeners(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getAccessType(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getAttributeOverrides(tree, defaults, true));
                this.addIfNotNull(annotationList, (Annotation)this.getAssociationOverrides(tree, defaults, true));
                this.addIfNotNull(annotationList, (Annotation)this.getEntityListeners(tree, defaults));
                this.addIfNotNull(annotationList, (Annotation)this.getConverts(tree, defaults));
                this.annotations = annotationList.toArray(new Annotation[annotationList.size()]);
                for (Annotation ann : this.annotations) {
                    this.annotationsMap.put(ann.annotationType(), ann);
                }
                this.checkForOrphanProperties(tree);
            } else if (this.className != null) {
                Element tree = this.xmlContext.getXMLTree(this.className);
                Annotation[] annotations = this.getPhysicalAnnotations();
                ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.length + 5);
                this.annotationsMap = new HashMap<Class, Annotation>(annotations.length + 5);
                for (Annotation annotation : annotations) {
                    if (annotationToXml.containsKey(annotation.annotationType())) continue;
                    annotationList.add(annotation);
                }
                this.preCalculateElementsForProperty(tree);
                Transient transientAnn = this.getTransient(defaults);
                if (transientAnn != null) {
                    annotationList.add((Annotation)transientAnn);
                } else {
                    if (defaults.canUseJavaAnnotations()) {
                        Access annotation = this.getPhysicalAnnotation(Access.class);
                        this.addIfNotNull(annotationList, (Annotation)annotation);
                    }
                    this.getId(annotationList, defaults);
                    this.getEmbeddedId(annotationList, defaults);
                    this.getEmbedded(annotationList, defaults);
                    this.getBasic(annotationList, defaults);
                    this.getVersion(annotationList, defaults);
                    this.getAssociation(ManyToOne.class, annotationList, defaults);
                    this.getAssociation(OneToOne.class, annotationList, defaults);
                    this.getAssociation(OneToMany.class, annotationList, defaults);
                    this.getAssociation(ManyToMany.class, annotationList, defaults);
                    this.getAssociation(Any.class, annotationList, defaults);
                    this.getAssociation(ManyToAny.class, annotationList, defaults);
                    this.getElementCollection(annotationList, defaults);
                    this.addIfNotNull(annotationList, this.getSequenceGenerator(this.elementsForProperty, defaults));
                    this.addIfNotNull(annotationList, this.getTableGenerator(this.elementsForProperty, defaults));
                    this.addIfNotNull(annotationList, this.getConvertsForAttribute(this.elementsForProperty, defaults));
                }
                this.processEventAnnotations(annotationList, defaults);
                for (Annotation ann : this.annotations = annotationList.toArray(new Annotation[annotationList.size()])) {
                    this.annotationsMap.put(ann.annotationType(), ann);
                }
            } else {
                this.annotations = this.getPhysicalAnnotations();
                this.annotationsMap = new HashMap<Class, Annotation>(this.annotations.length + 5);
                for (Annotation ann : this.annotations) {
                    this.annotationsMap.put(ann.annotationType(), ann);
                }
            }
        }
    }

    private Annotation getConvertsForAttribute(List<Element> elementsForProperty, XMLContext.Default defaults) {
        HashMap<String, Convert> convertAnnotationsMap = new HashMap<String, Convert>();
        for (Element element : elementsForProperty) {
            boolean isBasic = "basic".equals(element.getName());
            boolean isEmbedded = "embedded".equals(element.getName());
            boolean canHaveConverts = isBasic || isEmbedded;
            if (!canHaveConverts) continue;
            String attributeNamePrefix = isBasic ? null : this.propertyName;
            this.applyXmlDefinedConverts(element, defaults, attributeNamePrefix, convertAnnotationsMap);
        }
        if (defaults.canUseJavaAnnotations()) {
            this.applyPhysicalConvertAnnotations(this.propertyName, convertAnnotationsMap);
        }
        if (!convertAnnotationsMap.isEmpty()) {
            AnnotationDescriptor groupingDescriptor = new AnnotationDescriptor(Converts.class);
            groupingDescriptor.setValue("value", (Object)convertAnnotationsMap.values().toArray(new Convert[convertAnnotationsMap.size()]));
            return AnnotationFactory.create((AnnotationDescriptor)groupingDescriptor);
        }
        return null;
    }

    private Converts getConverts(Element tree, XMLContext.Default defaults) {
        HashMap<String, Convert> convertAnnotationsMap = new HashMap<String, Convert>();
        if (tree != null) {
            this.applyXmlDefinedConverts(tree, defaults, null, convertAnnotationsMap);
        }
        if (defaults.canUseJavaAnnotations()) {
            this.applyPhysicalConvertAnnotations(null, convertAnnotationsMap);
        }
        if (!convertAnnotationsMap.isEmpty()) {
            AnnotationDescriptor groupingDescriptor = new AnnotationDescriptor(Converts.class);
            groupingDescriptor.setValue("value", (Object)convertAnnotationsMap.values().toArray(new Convert[convertAnnotationsMap.size()]));
            return (Converts)AnnotationFactory.create((AnnotationDescriptor)groupingDescriptor);
        }
        return null;
    }

    private void applyXmlDefinedConverts(Element containingElement, XMLContext.Default defaults, String attributeNamePrefix, Map<String, Convert> convertAnnotationsMap) {
        List convertElements = containingElement.elements("convert");
        for (Element convertElement : convertElements) {
            AnnotationDescriptor convertAnnotationDescriptor = new AnnotationDescriptor(Convert.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(convertAnnotationDescriptor, convertElement, "attribute-name", false);
            JPAOverriddenAnnotationReader.copyBooleanAttribute(convertAnnotationDescriptor, convertElement, "disable-conversion");
            Attribute converterClassAttr = convertElement.attribute("converter");
            if (converterClassAttr != null) {
                String converterClassName = XMLContext.buildSafeClassName(converterClassAttr.getValue(), defaults);
                try {
                    Class converterClass = ReflectHelper.classForName(converterClassName, this.getClass());
                    convertAnnotationDescriptor.setValue("converter", (Object)converterClass);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find specified converter class id-class: " + converterClassName, e);
                }
            }
            Convert convertAnnotation = (Convert)AnnotationFactory.create((AnnotationDescriptor)convertAnnotationDescriptor);
            String qualifiedAttributeName = this.qualifyConverterAttributeName(attributeNamePrefix, convertAnnotation.attributeName());
            convertAnnotationsMap.put(qualifiedAttributeName, convertAnnotation);
        }
    }

    private String qualifyConverterAttributeName(String attributeNamePrefix, String specifiedAttributeName) {
        String qualifiedAttributeName = StringHelper.isNotEmpty(specifiedAttributeName) ? (StringHelper.isNotEmpty(attributeNamePrefix) ? attributeNamePrefix + '.' + specifiedAttributeName : specifiedAttributeName) : "";
        return qualifiedAttributeName;
    }

    private void applyPhysicalConvertAnnotations(String attributeNamePrefix, Map<String, Convert> convertAnnotationsMap) {
        Converts physicalGroupingAnnotation;
        String qualifiedAttributeName;
        Convert physicalAnnotation = this.getPhysicalAnnotation(Convert.class);
        if (physicalAnnotation != null && !convertAnnotationsMap.containsKey(qualifiedAttributeName = this.qualifyConverterAttributeName(attributeNamePrefix, physicalAnnotation.attributeName()))) {
            convertAnnotationsMap.put(qualifiedAttributeName, physicalAnnotation);
        }
        if ((physicalGroupingAnnotation = this.getPhysicalAnnotation(Converts.class)) != null) {
            for (Convert convertAnnotation : physicalGroupingAnnotation.value()) {
                String qualifiedAttributeName2 = this.qualifyConverterAttributeName(attributeNamePrefix, convertAnnotation.attributeName());
                if (convertAnnotationsMap.containsKey(qualifiedAttributeName2)) continue;
                convertAnnotationsMap.put(qualifiedAttributeName2, convertAnnotation);
            }
        }
    }

    private void checkForOrphanProperties(Element tree) {
        Element element;
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(this.className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        Element element2 = element = tree != null ? tree.element("attributes") : null;
        if (element != null) {
            HashSet<String> properties = new HashSet<String>();
            for (Field field : clazz.getFields()) {
                properties.add(field.getName());
            }
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                String name = ((Method)accessibleObject).getName();
                if (name.startsWith("get")) {
                    properties.add(Introspector.decapitalize(name.substring("get".length())));
                    continue;
                }
                if (!name.startsWith("is")) continue;
                properties.add(Introspector.decapitalize(name.substring("is".length())));
            }
            for (Element subelement : element.elements()) {
                String propertyName = subelement.attributeValue("name");
                if (properties.contains(propertyName)) continue;
                LOG.propertyNotFound(StringHelper.qualify(this.className, propertyName));
            }
        }
    }

    private Annotation addIfNotNull(List<Annotation> annotationList, Annotation annotation) {
        if (annotation != null) {
            annotationList.add(annotation);
        }
        return annotation;
    }

    private Annotation getTableGenerator(List<Element> elementsForProperty, XMLContext.Default defaults) {
        for (Element element : elementsForProperty) {
            Element subelement = element != null ? element.element(annotationToXml.get(TableGenerator.class)) : null;
            if (subelement == null) continue;
            return JPAOverriddenAnnotationReader.buildTableGeneratorAnnotation(subelement, defaults);
        }
        if (elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(TableGenerator.class);
        }
        return null;
    }

    private Annotation getSequenceGenerator(List<Element> elementsForProperty, XMLContext.Default defaults) {
        for (Element element : elementsForProperty) {
            Element subelement = element != null ? element.element(annotationToXml.get(SequenceGenerator.class)) : null;
            if (subelement == null) continue;
            return JPAOverriddenAnnotationReader.buildSequenceGeneratorAnnotation(subelement);
        }
        if (elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(SequenceGenerator.class);
        }
        return null;
    }

    private void processEventAnnotations(List<Annotation> annotationList, XMLContext.Default defaults) {
        boolean eventElement = false;
        for (Element element : this.elementsForProperty) {
            AnnotationDescriptor ad;
            String elementName = element.getName();
            if ("pre-persist".equals(elementName)) {
                ad = new AnnotationDescriptor(PrePersist.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if ("pre-remove".equals(elementName)) {
                ad = new AnnotationDescriptor(PreRemove.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if ("pre-update".equals(elementName)) {
                ad = new AnnotationDescriptor(PreUpdate.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if ("post-persist".equals(elementName)) {
                ad = new AnnotationDescriptor(PostPersist.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if ("post-remove".equals(elementName)) {
                ad = new AnnotationDescriptor(PostRemove.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if ("post-update".equals(elementName)) {
                ad = new AnnotationDescriptor(PostUpdate.class);
                annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
                eventElement = true;
                continue;
            }
            if (!"post-load".equals(elementName)) continue;
            ad = new AnnotationDescriptor(PostLoad.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            eventElement = true;
        }
        if (!eventElement && defaults.canUseJavaAnnotations()) {
            PrePersist ann = this.getPhysicalAnnotation(PrePersist.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getPhysicalAnnotation(PreRemove.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getPhysicalAnnotation(PreUpdate.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getPhysicalAnnotation(PostPersist.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getPhysicalAnnotation(PostRemove.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getPhysicalAnnotation(PostUpdate.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
            ann = this.getPhysicalAnnotation(PostLoad.class);
            this.addIfNotNull(annotationList, (Annotation)ann);
        }
    }

    private EntityListeners getEntityListeners(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("entity-listeners") : null;
        if (element != null) {
            ArrayList<Class> entityListenerClasses = new ArrayList<Class>();
            for (Element subelement : element.elements("entity-listener")) {
                String className = subelement.attributeValue("class");
                try {
                    entityListenerClasses.add(ReflectHelper.classForName(XMLContext.buildSafeClassName(className, defaults), this.getClass()));
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find " + element.getPath() + ".class: " + className, e);
                }
            }
            AnnotationDescriptor ad = new AnnotationDescriptor(EntityListeners.class);
            ad.setValue("value", (Object)entityListenerClasses.toArray(new Class[entityListenerClasses.size()]));
            return (EntityListeners)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(EntityListeners.class);
        }
        return null;
    }

    private JoinTable overridesDefaultsInJoinTable(Annotation annotation, XMLContext.Default defaults) {
        boolean defaultToJoinTable = !this.isPhysicalAnnotationPresent(JoinColumn.class) && !this.isPhysicalAnnotationPresent(JoinColumns.class);
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        defaultToJoinTable = defaultToJoinTable && (annotationClass == ManyToMany.class && StringHelper.isEmpty(((ManyToMany)annotation).mappedBy()) || annotationClass == OneToMany.class && StringHelper.isEmpty(((OneToMany)annotation).mappedBy()) || annotationClass == ElementCollection.class);
        Class<JoinTable> annotationType = JoinTable.class;
        if (defaultToJoinTable && (StringHelper.isNotEmpty(defaults.getCatalog()) || StringHelper.isNotEmpty(defaults.getSchema()))) {
            JoinTable table;
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            if (defaults.canUseJavaAnnotations() && (table = this.getPhysicalAnnotation(annotationType)) != null) {
                ad.setValue("name", (Object)table.name());
                ad.setValue("schema", (Object)table.schema());
                ad.setValue("catalog", (Object)table.catalog());
                ad.setValue("uniqueConstraints", (Object)table.uniqueConstraints());
                ad.setValue("joinColumns", (Object)table.joinColumns());
                ad.setValue("inverseJoinColumns", (Object)table.inverseJoinColumns());
            }
            if (StringHelper.isEmpty((String)ad.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                ad.setValue("schema", (Object)defaults.getSchema());
            }
            if (StringHelper.isEmpty((String)ad.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                ad.setValue("catalog", (Object)defaults.getCatalog());
            }
            return (JoinTable)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(annotationType);
        }
        return null;
    }

    private void getJoinTable(List<Annotation> annotationList, Element tree, XMLContext.Default defaults) {
        this.addIfNotNull(annotationList, (Annotation)this.buildJoinTable(tree, defaults));
    }

    private JoinTable buildJoinTable(Element tree, XMLContext.Default defaults) {
        Element subelement = tree == null ? null : tree.element("join-table");
        Class<JoinTable> annotationType = JoinTable.class;
        if (subelement == null) {
            return null;
        }
        AnnotationDescriptor annotation = new AnnotationDescriptor(annotationType);
        JPAOverriddenAnnotationReader.copyStringAttribute(annotation, subelement, "name", false);
        JPAOverriddenAnnotationReader.copyStringAttribute(annotation, subelement, "catalog", false);
        if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
            annotation.setValue("catalog", (Object)defaults.getCatalog());
        }
        JPAOverriddenAnnotationReader.copyStringAttribute(annotation, subelement, "schema", false);
        if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
            annotation.setValue("schema", (Object)defaults.getSchema());
        }
        JPAOverriddenAnnotationReader.buildUniqueConstraints(annotation, subelement);
        JPAOverriddenAnnotationReader.buildIndex(annotation, subelement);
        annotation.setValue("joinColumns", (Object)this.getJoinColumns(subelement, false));
        annotation.setValue("inverseJoinColumns", (Object)this.getJoinColumns(subelement, true));
        return (JoinTable)AnnotationFactory.create((AnnotationDescriptor)annotation);
    }

    private void getAssociation(Class<? extends Annotation> annotationType, List<Annotation> annotationList, XMLContext.Default defaults) {
        String xmlName = annotationToXml.get(annotationType);
        for (Element element : this.elementsForProperty) {
            if (!xmlName.equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            this.addTargetClass(element, ad, "target-entity", defaults);
            this.getFetchType(ad, element);
            this.getCascades(ad, element, defaults);
            this.getJoinTable(annotationList, element, defaults);
            this.buildJoinColumns(annotationList, element);
            PrimaryKeyJoinColumns annotation = this.getPrimaryKeyJoinColumns(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            JPAOverriddenAnnotationReader.copyBooleanAttribute(ad, element, "optional");
            JPAOverriddenAnnotationReader.copyBooleanAttribute(ad, element, "orphan-removal");
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "mapped-by", false);
            this.getOrderBy(annotationList, element);
            this.getMapKey(annotationList, element);
            this.getMapKeyClass(annotationList, element, defaults);
            this.getMapKeyColumn(annotationList, element);
            this.getOrderColumn(annotationList, element);
            this.getMapKeyTemporal(annotationList, element);
            this.getMapKeyEnumerated(annotationList, element);
            annotation = this.getMapKeyAttributeOverrides(element, defaults);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            this.buildMapKeyJoinColumns(annotationList, element);
            this.getAssociationId(annotationList, element);
            this.getMapsId(annotationList, element);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getAccessType(annotationList, element);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            Annotation annotation = this.getPhysicalAnnotation(annotationType);
            if (annotation != null) {
                annotationList.add(annotation);
                annotation = this.overridesDefaultsInJoinTable(annotation, defaults);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(JoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(JoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(PrimaryKeyJoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(PrimaryKeyJoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKey.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(OrderBy.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AttributeOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AssociationOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Lob.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Enumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Temporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Column.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Columns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyClass.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyTemporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyEnumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyJoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyJoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(OrderColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Cascade.class);
                this.addIfNotNull(annotationList, annotation);
            } else if (this.isPhysicalAnnotationPresent(ElementCollection.class)) {
                annotation = this.overridesDefaultsInJoinTable((Annotation)this.getPhysicalAnnotation(ElementCollection.class), defaults);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKey.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(OrderBy.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AttributeOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AssociationOverride.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Lob.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Enumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Temporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(Column.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(OrderColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyClass.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyTemporal.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyEnumerated.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyJoinColumn.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(MapKeyJoinColumns.class);
                this.addIfNotNull(annotationList, annotation);
                annotation = this.getPhysicalAnnotation(CollectionTable.class);
                this.addIfNotNull(annotationList, annotation);
            }
        }
    }

    private void buildMapKeyJoinColumns(List<Annotation> annotationList, Element element) {
        MapKeyJoinColumn[] joinColumns = this.getMapKeyJoinColumns(element);
        if (joinColumns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyJoinColumns.class);
            ad.setValue("value", (Object)joinColumns);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private MapKeyJoinColumn[] getMapKeyJoinColumns(Element element) {
        List subelements = element != null ? element.elements("map-key-join-column") : null;
        ArrayList<MapKeyJoinColumn> joinColumns = new ArrayList<MapKeyJoinColumn>();
        if (subelements != null) {
            for (Element subelement : subelements) {
                AnnotationDescriptor column = new AnnotationDescriptor(MapKeyJoinColumn.class);
                JPAOverriddenAnnotationReader.copyStringAttribute(column, subelement, "name", false);
                JPAOverriddenAnnotationReader.copyStringAttribute(column, subelement, "referenced-column-name", false);
                JPAOverriddenAnnotationReader.copyBooleanAttribute(column, subelement, "unique");
                JPAOverriddenAnnotationReader.copyBooleanAttribute(column, subelement, "nullable");
                JPAOverriddenAnnotationReader.copyBooleanAttribute(column, subelement, "insertable");
                JPAOverriddenAnnotationReader.copyBooleanAttribute(column, subelement, "updatable");
                JPAOverriddenAnnotationReader.copyStringAttribute(column, subelement, "column-definition", false);
                JPAOverriddenAnnotationReader.copyStringAttribute(column, subelement, "table", false);
                joinColumns.add((MapKeyJoinColumn)AnnotationFactory.create((AnnotationDescriptor)column));
            }
        }
        return joinColumns.toArray(new MapKeyJoinColumn[joinColumns.size()]);
    }

    private AttributeOverrides getMapKeyAttributeOverrides(Element tree, XMLContext.Default defaults) {
        List<AttributeOverride> attributes = this.buildAttributeOverrides(tree, "map-key-attribute-override");
        return this.mergeAttributeOverrides(defaults, attributes, false);
    }

    private Cacheable getCacheable(Element element, XMLContext.Default defaults) {
        String attValue;
        if (element != null && (attValue = element.attributeValue("cacheable")) != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Cacheable.class);
            ad.setValue("value", (Object)Boolean.valueOf(attValue));
            return (Cacheable)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(Cacheable.class);
        }
        return null;
    }

    private void getMapKeyEnumerated(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("map-key-enumerated") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyEnumerated.class);
            EnumType value = EnumType.valueOf((String)subelement.getTextTrim());
            ad.setValue("value", (Object)value);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKeyTemporal(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("map-key-temporal") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyTemporal.class);
            TemporalType value = TemporalType.valueOf((String)subelement.getTextTrim());
            ad.setValue("value", (Object)value);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getOrderColumn(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("order-column") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(OrderColumn.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, subelement, "name", false);
            JPAOverriddenAnnotationReader.copyBooleanAttribute(ad, subelement, "nullable");
            JPAOverriddenAnnotationReader.copyBooleanAttribute(ad, subelement, "insertable");
            JPAOverriddenAnnotationReader.copyBooleanAttribute(ad, subelement, "updatable");
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, subelement, "column-definition", false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapsId(List<Annotation> annotationList, Element element) {
        String attrVal = element.attributeValue("maps-id");
        if (attrVal != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapsId.class);
            ad.setValue("value", (Object)attrVal);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getAssociationId(List<Annotation> annotationList, Element element) {
        String attrVal = element.attributeValue("id");
        if ("true".equals(attrVal)) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Id.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void addTargetClass(Element element, AnnotationDescriptor ad, String nodeName, XMLContext.Default defaults) {
        String className = element.attributeValue(nodeName);
        if (className != null) {
            Class clazz;
            try {
                clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(className, defaults), this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new AnnotationException("Unable to find " + element.getPath() + " " + nodeName + ": " + className, e);
            }
            ad.setValue(JPAOverriddenAnnotationReader.getJavaAttributeNameFromXMLOne(nodeName), (Object)clazz);
        }
    }

    private void getElementCollection(List<Annotation> annotationList, XMLContext.Default defaults) {
        for (Element element : this.elementsForProperty) {
            if (!"element-collection".equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(ElementCollection.class);
            this.addTargetClass(element, ad, "target-class", defaults);
            this.getFetchType(ad, element);
            this.getOrderBy(annotationList, element);
            this.getOrderColumn(annotationList, element);
            this.getMapKey(annotationList, element);
            this.getMapKeyClass(annotationList, element, defaults);
            this.getMapKeyTemporal(annotationList, element);
            this.getMapKeyEnumerated(annotationList, element);
            this.getMapKeyColumn(annotationList, element);
            this.buildMapKeyJoinColumns(annotationList, element);
            Column annotation = this.getColumn(element.element("column"), false, element);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            this.getTemporal(annotationList, element);
            this.getEnumerated(annotationList, element);
            this.getLob(annotationList, element);
            ArrayList<AttributeOverride> attributes = new ArrayList<AttributeOverride>();
            attributes.addAll(this.buildAttributeOverrides(element, "map-key-attribute-override"));
            attributes.addAll(this.buildAttributeOverrides(element, "attribute-override"));
            annotation = this.mergeAttributeOverrides(defaults, attributes, false);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getAssociationOverrides(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            this.getCollectionTable(annotationList, element, defaults);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getAccessType(annotationList, element);
        }
    }

    private void getOrderBy(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("order-by") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(OrderBy.class);
            JPAOverriddenAnnotationReader.copyStringElement(subelement, ad, "value");
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKey(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("map-key") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKey.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, subelement, "name", false);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKeyColumn(List<Annotation> annotationList, Element element) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("map-key-column") : null;
        if (subelement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyColumn.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, subelement, "name", false);
            JPAOverriddenAnnotationReader.copyBooleanAttribute(ad, subelement, "unique");
            JPAOverriddenAnnotationReader.copyBooleanAttribute(ad, subelement, "nullable");
            JPAOverriddenAnnotationReader.copyBooleanAttribute(ad, subelement, "insertable");
            JPAOverriddenAnnotationReader.copyBooleanAttribute(ad, subelement, "updatable");
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, subelement, "column-definition", false);
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, subelement, "table", false);
            JPAOverriddenAnnotationReader.copyIntegerAttribute(ad, subelement, "length");
            JPAOverriddenAnnotationReader.copyIntegerAttribute(ad, subelement, "precision");
            JPAOverriddenAnnotationReader.copyIntegerAttribute(ad, subelement, "scale");
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getMapKeyClass(List<Annotation> annotationList, Element element, XMLContext.Default defaults) {
        Element subelement;
        String nodeName = "map-key-class";
        Element element2 = subelement = element != null ? element.element(nodeName) : null;
        if (subelement != null) {
            String mapKeyClassName = subelement.attributeValue("class");
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKeyClass.class);
            if (StringHelper.isNotEmpty(mapKeyClassName)) {
                Class clazz;
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(mapKeyClassName, defaults), this.getClass());
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find " + element.getPath() + " " + nodeName + ": " + mapKeyClassName, e);
                }
                ad.setValue("value", (Object)clazz);
            }
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getCollectionTable(List<Annotation> annotationList, Element element, XMLContext.Default defaults) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("collection-table") : null;
        if (subelement != null) {
            JoinColumn[] joinColumns;
            AnnotationDescriptor annotation = new AnnotationDescriptor(CollectionTable.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(annotation, subelement, "name", false);
            JPAOverriddenAnnotationReader.copyStringAttribute(annotation, subelement, "catalog", false);
            if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
                annotation.setValue("catalog", (Object)defaults.getCatalog());
            }
            JPAOverriddenAnnotationReader.copyStringAttribute(annotation, subelement, "schema", false);
            if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
                annotation.setValue("schema", (Object)defaults.getSchema());
            }
            if ((joinColumns = this.getJoinColumns(subelement, false)).length > 0) {
                annotation.setValue("joinColumns", (Object)joinColumns);
            }
            JPAOverriddenAnnotationReader.buildUniqueConstraints(annotation, subelement);
            JPAOverriddenAnnotationReader.buildIndex(annotation, subelement);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)annotation));
        }
    }

    private void buildJoinColumns(List<Annotation> annotationList, Element element) {
        JoinColumn[] joinColumns = this.getJoinColumns(element, false);
        if (joinColumns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(JoinColumns.class);
            ad.setValue("value", (Object)joinColumns);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getCascades(AnnotationDescriptor ad, Element element, XMLContext.Default defaults) {
        List elements = element != null ? element.elements("cascade") : new ArrayList(0);
        ArrayList<CascadeType> cascades = new ArrayList<CascadeType>();
        for (Element subelement : elements) {
            if (subelement.element("cascade-all") != null) {
                cascades.add(CascadeType.ALL);
            }
            if (subelement.element("cascade-persist") != null) {
                cascades.add(CascadeType.PERSIST);
            }
            if (subelement.element("cascade-merge") != null) {
                cascades.add(CascadeType.MERGE);
            }
            if (subelement.element("cascade-remove") != null) {
                cascades.add(CascadeType.REMOVE);
            }
            if (subelement.element("cascade-refresh") != null) {
                cascades.add(CascadeType.REFRESH);
            }
            if (subelement.element("cascade-detach") == null) continue;
            cascades.add(CascadeType.DETACH);
        }
        if (Boolean.TRUE.equals(defaults.getCascadePersist()) && !cascades.contains(CascadeType.ALL) && !cascades.contains(CascadeType.PERSIST)) {
            cascades.add(CascadeType.PERSIST);
        }
        if (cascades.size() > 0) {
            ad.setValue("cascade", (Object)cascades.toArray(new CascadeType[cascades.size()]));
        }
    }

    private void getEmbedded(List<Annotation> annotationList, XMLContext.Default defaults) {
        Embedded annotation;
        for (Element element : this.elementsForProperty) {
            if (!"embedded".equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(Embedded.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            AttributeOverrides annotation2 = this.getAttributeOverrides(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation2);
            annotation2 = this.getAssociationOverrides(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation2);
            this.getAccessType(annotationList, element);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = this.getPhysicalAnnotation(Embedded.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
        }
    }

    private Transient getTransient(XMLContext.Default defaults) {
        for (Element element : this.elementsForProperty) {
            if (!"transient".equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(Transient.class);
            return (Transient)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(Transient.class);
        }
        return null;
    }

    private void getVersion(List<Annotation> annotationList, XMLContext.Default defaults) {
        Object annotation;
        for (Element element : this.elementsForProperty) {
            if (!"version".equals(element.getName())) continue;
            Columns annotation2 = this.buildColumns(element);
            this.addIfNotNull(annotationList, annotation2);
            this.getTemporal(annotationList, element);
            AnnotationDescriptor basic = new AnnotationDescriptor(Version.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)basic));
            this.getAccessType(annotationList, element);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = this.getPhysicalAnnotation(Version.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Column.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Columns.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
        }
    }

    private void getBasic(List<Annotation> annotationList, XMLContext.Default defaults) {
        for (Element element : this.elementsForProperty) {
            if (!"basic".equals(element.getName())) continue;
            Columns annotation = this.buildColumns(element);
            this.addIfNotNull(annotationList, annotation);
            this.getAccessType(annotationList, element);
            this.getTemporal(annotationList, element);
            this.getLob(annotationList, element);
            this.getEnumerated(annotationList, element);
            AnnotationDescriptor basic = new AnnotationDescriptor(Basic.class);
            this.getFetchType(basic, element);
            JPAOverriddenAnnotationReader.copyBooleanAttribute(basic, element, "optional");
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)basic));
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            Object annotation = this.getPhysicalAnnotation(Basic.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Lob.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Enumerated.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Column.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Columns.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
        }
    }

    private void getEnumerated(List<Annotation> annotationList, Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("enumerated") : null;
        if (subElement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Enumerated.class);
            String enumerated = subElement.getTextTrim();
            if ("ORDINAL".equalsIgnoreCase(enumerated)) {
                ad.setValue("value", (Object)EnumType.ORDINAL);
            } else if ("STRING".equalsIgnoreCase(enumerated)) {
                ad.setValue("value", (Object)EnumType.STRING);
            } else if (StringHelper.isNotEmpty(enumerated)) {
                throw new AnnotationException("Unknown EnumType: " + enumerated + ". " + SCHEMA_VALIDATION);
            }
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getLob(List<Annotation> annotationList, Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("lob") : null;
        if (subElement != null) {
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)new AnnotationDescriptor(Lob.class)));
        }
    }

    private void getFetchType(AnnotationDescriptor descriptor, Element element) {
        String fetchString;
        String string = fetchString = element != null ? element.attributeValue("fetch") : null;
        if (fetchString != null) {
            if ("eager".equalsIgnoreCase(fetchString)) {
                descriptor.setValue("fetch", (Object)FetchType.EAGER);
            } else if ("lazy".equalsIgnoreCase(fetchString)) {
                descriptor.setValue("fetch", (Object)FetchType.LAZY);
            }
        }
    }

    private void getEmbeddedId(List<Annotation> annotationList, XMLContext.Default defaults) {
        Object annotation;
        for (Element element : this.elementsForProperty) {
            if (!"embedded-id".equals(element.getName()) || !this.isProcessingId(defaults)) continue;
            AttributeOverrides annotation2 = this.getAttributeOverrides(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation2);
            annotation2 = this.getAssociationOverrides(element, defaults, false);
            this.addIfNotNull(annotationList, (Annotation)annotation2);
            AnnotationDescriptor ad = new AnnotationDescriptor(EmbeddedId.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
            this.getAccessType(annotationList, element);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = this.getPhysicalAnnotation(EmbeddedId.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Column.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Columns.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(GeneratedValue.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(TableGenerator.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(SequenceGenerator.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
        }
    }

    private void preCalculateElementsForProperty(Element tree) {
        Element element;
        this.elementsForProperty = new ArrayList<Element>();
        Element element2 = element = tree != null ? tree.element("attributes") : null;
        if (element != null) {
            for (Element subelement : element.elements()) {
                if (!this.propertyName.equals(subelement.attributeValue("name"))) continue;
                this.elementsForProperty.add(subelement);
            }
        }
        if (tree != null) {
            for (Element subelement : tree.elements()) {
                if (!this.propertyName.equals(subelement.attributeValue("method-name"))) continue;
                this.elementsForProperty.add(subelement);
            }
        }
    }

    private void getId(List<Annotation> annotationList, XMLContext.Default defaults) {
        Object annotation;
        for (Element element : this.elementsForProperty) {
            boolean processId;
            if (!"id".equals(element.getName()) || !(processId = this.isProcessingId(defaults))) continue;
            Columns annotation2 = this.buildColumns(element);
            this.addIfNotNull(annotationList, annotation2);
            annotation2 = this.buildGeneratedValue(element);
            this.addIfNotNull(annotationList, annotation2);
            this.getTemporal(annotationList, element);
            annotation2 = this.getTableGenerator(element, defaults);
            this.addIfNotNull(annotationList, annotation2);
            annotation2 = this.getSequenceGenerator(element, defaults);
            this.addIfNotNull(annotationList, annotation2);
            AnnotationDescriptor id = new AnnotationDescriptor(Id.class);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)id));
            this.getAccessType(annotationList, element);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = this.getPhysicalAnnotation(Id.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Column.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Columns.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(GeneratedValue.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(Temporal.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(TableGenerator.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(SequenceGenerator.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AttributeOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverride.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
            annotation = this.getPhysicalAnnotation(AssociationOverrides.class);
            this.addIfNotNull(annotationList, (Annotation)annotation);
        }
    }

    private boolean isProcessingId(XMLContext.Default defaults) {
        boolean isExplicit = defaults.getAccess() != null;
        boolean correctAccess = PropertyType.PROPERTY.equals((Object)this.propertyType) && AccessType.PROPERTY.equals((Object)defaults.getAccess()) || PropertyType.FIELD.equals((Object)this.propertyType) && AccessType.FIELD.equals((Object)defaults.getAccess());
        boolean hasId = defaults.canUseJavaAnnotations() && (this.isPhysicalAnnotationPresent(Id.class) || this.isPhysicalAnnotationPresent(EmbeddedId.class));
        boolean mirrorAttributeIsId = defaults.canUseJavaAnnotations() && this.mirroredAttribute != null && (this.mirroredAttribute.isAnnotationPresent(Id.class) || this.mirroredAttribute.isAnnotationPresent(EmbeddedId.class));
        boolean propertyIsDefault = PropertyType.PROPERTY.equals((Object)this.propertyType) && !mirrorAttributeIsId;
        return correctAccess || !isExplicit && hasId || !isExplicit && propertyIsDefault;
    }

    private Columns buildColumns(Element element) {
        List subelements = element.elements("column");
        ArrayList<Column> columns = new ArrayList<Column>(subelements.size());
        for (Element subelement : subelements) {
            columns.add(this.getColumn(subelement, false, element));
        }
        if (columns.size() > 0) {
            AnnotationDescriptor columnsDescr = new AnnotationDescriptor(Columns.class);
            columnsDescr.setValue("columns", (Object)columns.toArray(new Column[columns.size()]));
            return (Columns)AnnotationFactory.create((AnnotationDescriptor)columnsDescr);
        }
        return null;
    }

    private GeneratedValue buildGeneratedValue(Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("generated-value") : null;
        if (subElement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(GeneratedValue.class);
            String strategy = subElement.attributeValue("strategy");
            if ("TABLE".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", (Object)GenerationType.TABLE);
            } else if ("SEQUENCE".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", (Object)GenerationType.SEQUENCE);
            } else if ("IDENTITY".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", (Object)GenerationType.IDENTITY);
            } else if ("AUTO".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", (Object)GenerationType.AUTO);
            } else if (StringHelper.isNotEmpty(strategy)) {
                throw new AnnotationException("Unknown GenerationType: " + strategy + ". " + SCHEMA_VALIDATION);
            }
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, subElement, "generator", false);
            return (GeneratedValue)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void getTemporal(List<Annotation> annotationList, Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("temporal") : null;
        if (subElement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Temporal.class);
            String temporal = subElement.getTextTrim();
            if ("DATE".equalsIgnoreCase(temporal)) {
                ad.setValue("value", (Object)TemporalType.DATE);
            } else if ("TIME".equalsIgnoreCase(temporal)) {
                ad.setValue("value", (Object)TemporalType.TIME);
            } else if ("TIMESTAMP".equalsIgnoreCase(temporal)) {
                ad.setValue("value", (Object)TemporalType.TIMESTAMP);
            } else if (StringHelper.isNotEmpty(temporal)) {
                throw new AnnotationException("Unknown TemporalType: " + temporal + ". " + SCHEMA_VALIDATION);
            }
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private void getAccessType(List<Annotation> annotationList, Element element) {
        if (element == null) {
            return;
        }
        String access = element.attributeValue("access");
        if (access != null) {
            AccessType type;
            AnnotationDescriptor ad = new AnnotationDescriptor(Access.class);
            try {
                type = AccessType.valueOf((String)access);
            }
            catch (IllegalArgumentException e) {
                throw new AnnotationException(access + " is not a valid access type. Check you xml confguration.");
            }
            if (AccessType.PROPERTY.equals((Object)type) && this.element instanceof Method || AccessType.FIELD.equals((Object)type) && this.element instanceof Field) {
                return;
            }
            ad.setValue("value", (Object)type);
            annotationList.add(AnnotationFactory.create((AnnotationDescriptor)ad));
        }
    }

    private AssociationOverrides getAssociationOverrides(Element tree, XMLContext.Default defaults, boolean mergeWithAnnotations) {
        List<AssociationOverride> attributes = this.buildAssociationOverrides(tree, defaults);
        if (mergeWithAnnotations && defaults.canUseJavaAnnotations()) {
            AssociationOverride annotation = this.getPhysicalAnnotation(AssociationOverride.class);
            this.addAssociationOverrideIfNeeded(annotation, attributes);
            AssociationOverrides annotations = this.getPhysicalAnnotation(AssociationOverrides.class);
            if (annotations != null) {
                for (AssociationOverride current : annotations.value()) {
                    this.addAssociationOverrideIfNeeded(current, attributes);
                }
            }
        }
        if (attributes.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(AssociationOverrides.class);
            ad.setValue("value", (Object)attributes.toArray(new AssociationOverride[attributes.size()]));
            return (AssociationOverrides)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private List<AssociationOverride> buildAssociationOverrides(Element element, XMLContext.Default defaults) {
        List subelements = element == null ? null : element.elements("association-override");
        ArrayList<AssociationOverride> overrides = new ArrayList<AssociationOverride>();
        if (subelements != null && subelements.size() > 0) {
            for (Element current : subelements) {
                AnnotationDescriptor override = new AnnotationDescriptor(AssociationOverride.class);
                JPAOverriddenAnnotationReader.copyStringAttribute(override, current, "name", true);
                override.setValue("joinColumns", (Object)this.getJoinColumns(current, false));
                JoinTable joinTable = this.buildJoinTable(current, defaults);
                if (joinTable != null) {
                    override.setValue("joinTable", (Object)joinTable);
                }
                overrides.add((AssociationOverride)AnnotationFactory.create((AnnotationDescriptor)override));
            }
        }
        return overrides;
    }

    private JoinColumn[] getJoinColumns(Element element, boolean isInverse) {
        List subelements = element != null ? element.elements(isInverse ? "inverse-join-column" : "join-column") : null;
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>();
        if (subelements != null) {
            for (Element subelement : subelements) {
                AnnotationDescriptor column = new AnnotationDescriptor(JoinColumn.class);
                JPAOverriddenAnnotationReader.copyStringAttribute(column, subelement, "name", false);
                JPAOverriddenAnnotationReader.copyStringAttribute(column, subelement, "referenced-column-name", false);
                JPAOverriddenAnnotationReader.copyBooleanAttribute(column, subelement, "unique");
                JPAOverriddenAnnotationReader.copyBooleanAttribute(column, subelement, "nullable");
                JPAOverriddenAnnotationReader.copyBooleanAttribute(column, subelement, "insertable");
                JPAOverriddenAnnotationReader.copyBooleanAttribute(column, subelement, "updatable");
                JPAOverriddenAnnotationReader.copyStringAttribute(column, subelement, "column-definition", false);
                JPAOverriddenAnnotationReader.copyStringAttribute(column, subelement, "table", false);
                joinColumns.add((JoinColumn)AnnotationFactory.create((AnnotationDescriptor)column));
            }
        }
        return joinColumns.toArray(new JoinColumn[joinColumns.size()]);
    }

    private void addAssociationOverrideIfNeeded(AssociationOverride annotation, List<AssociationOverride> overrides) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AssociationOverride current : overrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                overrides.add(annotation);
            }
        }
    }

    private AttributeOverrides getAttributeOverrides(Element tree, XMLContext.Default defaults, boolean mergeWithAnnotations) {
        List<AttributeOverride> attributes = this.buildAttributeOverrides(tree, "attribute-override");
        return this.mergeAttributeOverrides(defaults, attributes, mergeWithAnnotations);
    }

    private AttributeOverrides mergeAttributeOverrides(XMLContext.Default defaults, List<AttributeOverride> attributes, boolean mergeWithAnnotations) {
        if (mergeWithAnnotations && defaults.canUseJavaAnnotations()) {
            AttributeOverride annotation = this.getPhysicalAnnotation(AttributeOverride.class);
            this.addAttributeOverrideIfNeeded(annotation, attributes);
            AttributeOverrides annotations = this.getPhysicalAnnotation(AttributeOverrides.class);
            if (annotations != null) {
                for (AttributeOverride current : annotations.value()) {
                    this.addAttributeOverrideIfNeeded(current, attributes);
                }
            }
        }
        if (attributes.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(AttributeOverrides.class);
            ad.setValue("value", (Object)attributes.toArray(new AttributeOverride[attributes.size()]));
            return (AttributeOverrides)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private List<AttributeOverride> buildAttributeOverrides(Element element, String nodeName) {
        List subelements = element == null ? null : element.elements(nodeName);
        return this.buildAttributeOverrides(subelements, nodeName);
    }

    private List<AttributeOverride> buildAttributeOverrides(List<Element> subelements, String nodeName) {
        ArrayList<AttributeOverride> overrides = new ArrayList<AttributeOverride>();
        if (subelements != null && subelements.size() > 0) {
            for (Element current : subelements) {
                if (!current.getName().equals(nodeName)) continue;
                AnnotationDescriptor override = new AnnotationDescriptor(AttributeOverride.class);
                JPAOverriddenAnnotationReader.copyStringAttribute(override, current, "name", true);
                Element column = current.element("column");
                override.setValue("column", (Object)this.getColumn(column, true, current));
                overrides.add((AttributeOverride)AnnotationFactory.create((AnnotationDescriptor)override));
            }
        }
        return overrides;
    }

    private Column getColumn(Element element, boolean isMandatory, Element current) {
        if (element != null) {
            AnnotationDescriptor column = new AnnotationDescriptor(Column.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(column, element, "name", false);
            JPAOverriddenAnnotationReader.copyBooleanAttribute(column, element, "unique");
            JPAOverriddenAnnotationReader.copyBooleanAttribute(column, element, "nullable");
            JPAOverriddenAnnotationReader.copyBooleanAttribute(column, element, "insertable");
            JPAOverriddenAnnotationReader.copyBooleanAttribute(column, element, "updatable");
            JPAOverriddenAnnotationReader.copyStringAttribute(column, element, "column-definition", false);
            JPAOverriddenAnnotationReader.copyStringAttribute(column, element, "table", false);
            JPAOverriddenAnnotationReader.copyIntegerAttribute(column, element, "length");
            JPAOverriddenAnnotationReader.copyIntegerAttribute(column, element, "precision");
            JPAOverriddenAnnotationReader.copyIntegerAttribute(column, element, "scale");
            return (Column)AnnotationFactory.create((AnnotationDescriptor)column);
        }
        if (isMandatory) {
            throw new AnnotationException(current.getPath() + ".column is mandatory. " + SCHEMA_VALIDATION);
        }
        return null;
    }

    private void addAttributeOverrideIfNeeded(AttributeOverride annotation, List<AttributeOverride> overrides) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AttributeOverride current : overrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                overrides.add(annotation);
            }
        }
    }

    private Access getAccessType(Element tree, XMLContext.Default defaults) {
        String access;
        String string = access = tree == null ? null : tree.attributeValue("access");
        if (access != null) {
            AccessType type;
            AnnotationDescriptor ad = new AnnotationDescriptor(Access.class);
            try {
                type = AccessType.valueOf((String)access);
            }
            catch (IllegalArgumentException e) {
                throw new AnnotationException(access + " is not a valid access type. Check you xml confguration.");
            }
            ad.setValue("value", (Object)type);
            return (Access)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations() && this.isPhysicalAnnotationPresent(Access.class)) {
            return this.getPhysicalAnnotation(Access.class);
        }
        if (defaults.getAccess() != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Access.class);
            ad.setValue("value", (Object)defaults.getAccess());
            return (Access)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private ExcludeSuperclassListeners getExcludeSuperclassListeners(Element tree, XMLContext.Default defaults) {
        return (ExcludeSuperclassListeners)this.getMarkerAnnotation(ExcludeSuperclassListeners.class, tree, defaults);
    }

    private ExcludeDefaultListeners getExcludeDefaultListeners(Element tree, XMLContext.Default defaults) {
        return (ExcludeDefaultListeners)this.getMarkerAnnotation(ExcludeDefaultListeners.class, tree, defaults);
    }

    private Annotation getMarkerAnnotation(Class<? extends Annotation> clazz, Element element, XMLContext.Default defaults) {
        Element subelement;
        Element element2 = subelement = element == null ? null : element.element(annotationToXml.get(clazz));
        if (subelement != null) {
            return AnnotationFactory.create((AnnotationDescriptor)new AnnotationDescriptor(clazz));
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(clazz);
        }
        return null;
    }

    private SqlResultSetMappings getSqlResultSetMappings(Element tree, XMLContext.Default defaults) {
        List<SqlResultSetMapping> results = JPAOverriddenAnnotationReader.buildSqlResultsetMappings(tree, defaults);
        if (defaults.canUseJavaAnnotations()) {
            SqlResultSetMapping annotation = this.getPhysicalAnnotation(SqlResultSetMapping.class);
            this.addSqlResultsetMappingIfNeeded(annotation, results);
            SqlResultSetMappings annotations = this.getPhysicalAnnotation(SqlResultSetMappings.class);
            if (annotations != null) {
                for (SqlResultSetMapping current : annotations.value()) {
                    this.addSqlResultsetMappingIfNeeded(current, results);
                }
            }
        }
        if (results.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(SqlResultSetMappings.class);
            ad.setValue("value", (Object)results.toArray(new SqlResultSetMapping[results.size()]));
            return (SqlResultSetMappings)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    public static List<NamedEntityGraph> buildNamedEntityGraph(Element element, XMLContext.Default defaults) {
        if (element == null) {
            return new ArrayList<NamedEntityGraph>();
        }
        ArrayList<NamedEntityGraph> namedEntityGraphList = new ArrayList<NamedEntityGraph>();
        List namedEntityGraphElements = element.elements("named-entity-graph");
        for (Element subElement : namedEntityGraphElements) {
            AnnotationDescriptor ann = new AnnotationDescriptor(NamedEntityGraph.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(ann, subElement, "name", false);
            JPAOverriddenAnnotationReader.copyBooleanAttribute(ann, subElement, "include-all-attributes");
            JPAOverriddenAnnotationReader.bindNamedAttributeNodes(subElement, ann);
            List subgraphNodes = subElement.elements("subgraph");
            JPAOverriddenAnnotationReader.bindNamedSubgraph(defaults, ann, subgraphNodes);
            List subclassSubgraphNodes = subElement.elements("subclass-subgraph");
            JPAOverriddenAnnotationReader.bindNamedSubgraph(defaults, ann, subclassSubgraphNodes);
            namedEntityGraphList.add((NamedEntityGraph)AnnotationFactory.create((AnnotationDescriptor)ann));
        }
        return namedEntityGraphList;
    }

    private static void bindNamedSubgraph(XMLContext.Default defaults, AnnotationDescriptor ann, List<Element> subgraphNodes) {
        ArrayList<NamedSubgraph> annSubgraphNodes = new ArrayList<NamedSubgraph>();
        for (Element subgraphNode : subgraphNodes) {
            Class clazz;
            AnnotationDescriptor annSubgraphNode = new AnnotationDescriptor(NamedSubgraph.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(annSubgraphNode, subgraphNode, "name", true);
            String clazzName = subgraphNode.attributeValue("class");
            try {
                clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(clazzName, defaults), JPAOverriddenAnnotationReader.class);
            }
            catch (ClassNotFoundException e) {
                throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
            }
            annSubgraphNode.setValue("type", (Object)clazz);
            JPAOverriddenAnnotationReader.bindNamedAttributeNodes(subgraphNode, annSubgraphNode);
            annSubgraphNodes.add((NamedSubgraph)AnnotationFactory.create((AnnotationDescriptor)annSubgraphNode));
        }
        ann.setValue("subgraphs", (Object)annSubgraphNodes.toArray(new NamedSubgraph[annSubgraphNodes.size()]));
    }

    private static void bindNamedAttributeNodes(Element subElement, AnnotationDescriptor ann) {
        List namedAttributeNodes = subElement.elements("named-attribute-node");
        ArrayList<NamedAttributeNode> annNamedAttributeNodes = new ArrayList<NamedAttributeNode>();
        for (Element namedAttributeNode : namedAttributeNodes) {
            AnnotationDescriptor annNamedAttributeNode = new AnnotationDescriptor(NamedAttributeNode.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(annNamedAttributeNode, namedAttributeNode, "value", "name", true);
            JPAOverriddenAnnotationReader.copyStringAttribute(annNamedAttributeNode, namedAttributeNode, "subgraph", false);
            JPAOverriddenAnnotationReader.copyStringAttribute(annNamedAttributeNode, namedAttributeNode, "key-subgraph", false);
            annNamedAttributeNodes.add((NamedAttributeNode)AnnotationFactory.create((AnnotationDescriptor)annNamedAttributeNode));
        }
        ann.setValue("attributeNodes", (Object)annNamedAttributeNodes.toArray(new NamedAttributeNode[annNamedAttributeNodes.size()]));
    }

    public static List<NamedStoredProcedureQuery> buildNamedStoreProcedureQueries(Element element, XMLContext.Default defaults) {
        if (element == null) {
            return new ArrayList<NamedStoredProcedureQuery>();
        }
        List namedStoredProcedureElements = element.elements("named-stored-procedure-query");
        ArrayList<NamedStoredProcedureQuery> namedStoredProcedureQueries = new ArrayList<NamedStoredProcedureQuery>();
        for (Object obj : namedStoredProcedureElements) {
            Object parameterElement2;
            Element subElement = (Element)obj;
            AnnotationDescriptor ann = new AnnotationDescriptor(NamedStoredProcedureQuery.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(ann, subElement, "name", true);
            JPAOverriddenAnnotationReader.copyStringAttribute(ann, subElement, "procedure-name", true);
            List elements = subElement.elements("parameter");
            ArrayList<StoredProcedureParameter> storedProcedureParameters = new ArrayList<StoredProcedureParameter>();
            for (Object parameterElement2 : elements) {
                Class clazz;
                AnnotationDescriptor parameterDescriptor = new AnnotationDescriptor(StoredProcedureParameter.class);
                JPAOverriddenAnnotationReader.copyStringAttribute(parameterDescriptor, (Element)parameterElement2, "name", false);
                String modeValue = parameterElement2.attributeValue("mode");
                if (modeValue == null) {
                    parameterDescriptor.setValue("mode", (Object)ParameterMode.IN);
                } else {
                    parameterDescriptor.setValue("mode", (Object)ParameterMode.valueOf((String)modeValue.toUpperCase(Locale.ROOT)));
                }
                String clazzName = parameterElement2.attributeValue("class");
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(clazzName, defaults), JPAOverriddenAnnotationReader.class);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
                }
                parameterDescriptor.setValue("type", (Object)clazz);
                storedProcedureParameters.add((StoredProcedureParameter)AnnotationFactory.create((AnnotationDescriptor)parameterDescriptor));
            }
            ann.setValue("parameters", (Object)storedProcedureParameters.toArray(new StoredProcedureParameter[storedProcedureParameters.size()]));
            elements = subElement.elements("result-class");
            ArrayList<Class> returnClasses = new ArrayList<Class>();
            parameterElement2 = elements.iterator();
            while (parameterElement2.hasNext()) {
                Class clazz;
                Element classElement = (Element)parameterElement2.next();
                String clazzName = classElement.getTextTrim();
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(clazzName, defaults), JPAOverriddenAnnotationReader.class);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
                }
                returnClasses.add(clazz);
            }
            ann.setValue("resultClasses", (Object)returnClasses.toArray(new Class[returnClasses.size()]));
            elements = subElement.elements("result-set-mapping");
            ArrayList<String> resultSetMappings = new ArrayList<String>();
            for (Element resultSetMappingElement : elements) {
                resultSetMappings.add(resultSetMappingElement.getTextTrim());
            }
            ann.setValue("resultSetMappings", (Object)resultSetMappings.toArray(new String[resultSetMappings.size()]));
            elements = subElement.elements("hint");
            JPAOverriddenAnnotationReader.buildQueryHints(elements, ann);
            namedStoredProcedureQueries.add((NamedStoredProcedureQuery)AnnotationFactory.create((AnnotationDescriptor)ann));
        }
        return namedStoredProcedureQueries;
    }

    public static List<SqlResultSetMapping> buildSqlResultsetMappings(Element element, XMLContext.Default defaults) {
        ArrayList<SqlResultSetMapping> builtResultSetMappings = new ArrayList<SqlResultSetMapping>();
        if (element == null) {
            return builtResultSetMappings;
        }
        for (Object resultSetMappingElementObject : element.elements("sql-result-set-mapping")) {
            Element resultSetMappingElement = (Element)resultSetMappingElementObject;
            AnnotationDescriptor resultSetMappingAnnotation = new AnnotationDescriptor(SqlResultSetMapping.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(resultSetMappingAnnotation, resultSetMappingElement, "name", true);
            ArrayList<EntityResult> entityResultAnnotations = null;
            ArrayList<ColumnResult> columnResultAnnotations = null;
            ArrayList<ConstructorResult> constructorResultAnnotations = null;
            for (Object resultElementObject : resultSetMappingElement.elements()) {
                Element resultElement = (Element)resultElementObject;
                if ("entity-result".equals(resultElement.getName())) {
                    if (entityResultAnnotations == null) {
                        entityResultAnnotations = new ArrayList<EntityResult>();
                    }
                    entityResultAnnotations.add(JPAOverriddenAnnotationReader.buildEntityResult(resultElement, defaults));
                    continue;
                }
                if ("column-result".equals(resultElement.getName())) {
                    if (columnResultAnnotations == null) {
                        columnResultAnnotations = new ArrayList<ColumnResult>();
                    }
                    columnResultAnnotations.add(JPAOverriddenAnnotationReader.buildColumnResult(resultElement, defaults));
                    continue;
                }
                if ("constructor-result".equals(resultElement.getName())) {
                    if (constructorResultAnnotations == null) {
                        constructorResultAnnotations = new ArrayList<ConstructorResult>();
                    }
                    constructorResultAnnotations.add(JPAOverriddenAnnotationReader.buildConstructorResult(resultElement, defaults));
                    continue;
                }
                LOG.debug("Encountered unrecognized sql-result-set-mapping sub-element : " + resultElement.getName());
            }
            if (entityResultAnnotations != null && !entityResultAnnotations.isEmpty()) {
                resultSetMappingAnnotation.setValue("entities", (Object)entityResultAnnotations.toArray(new EntityResult[entityResultAnnotations.size()]));
            }
            if (columnResultAnnotations != null && !columnResultAnnotations.isEmpty()) {
                resultSetMappingAnnotation.setValue("columns", (Object)columnResultAnnotations.toArray(new ColumnResult[columnResultAnnotations.size()]));
            }
            if (constructorResultAnnotations != null && !constructorResultAnnotations.isEmpty()) {
                resultSetMappingAnnotation.setValue("classes", (Object)constructorResultAnnotations.toArray(new ConstructorResult[constructorResultAnnotations.size()]));
            }
            builtResultSetMappings.add((SqlResultSetMapping)AnnotationFactory.create((AnnotationDescriptor)resultSetMappingAnnotation));
        }
        return builtResultSetMappings;
    }

    private static EntityResult buildEntityResult(Element entityResultElement, XMLContext.Default defaults) {
        AnnotationDescriptor entityResultDescriptor = new AnnotationDescriptor(EntityResult.class);
        Class entityClass = JPAOverriddenAnnotationReader.resolveClassReference(entityResultElement.attributeValue("entity-class"), defaults);
        entityResultDescriptor.setValue("entityClass", (Object)entityClass);
        JPAOverriddenAnnotationReader.copyStringAttribute(entityResultDescriptor, entityResultElement, "discriminator-column", false);
        ArrayList<FieldResult> fieldResultAnnotations = new ArrayList<FieldResult>();
        for (Element fieldResult : entityResultElement.elements("field-result")) {
            AnnotationDescriptor fieldResultDescriptor = new AnnotationDescriptor(FieldResult.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(fieldResultDescriptor, fieldResult, "name", true);
            JPAOverriddenAnnotationReader.copyStringAttribute(fieldResultDescriptor, fieldResult, "column", true);
            fieldResultAnnotations.add((FieldResult)AnnotationFactory.create((AnnotationDescriptor)fieldResultDescriptor));
        }
        entityResultDescriptor.setValue("fields", (Object)fieldResultAnnotations.toArray(new FieldResult[fieldResultAnnotations.size()]));
        return (EntityResult)AnnotationFactory.create((AnnotationDescriptor)entityResultDescriptor);
    }

    private static Class resolveClassReference(String className, XMLContext.Default defaults) {
        if (className == null) {
            throw new AnnotationException("<entity-result> without entity-class. Activate schema validation for more information");
        }
        try {
            return ReflectHelper.classForName(XMLContext.buildSafeClassName(className, defaults), JPAOverriddenAnnotationReader.class);
        }
        catch (ClassNotFoundException e) {
            throw new AnnotationException("Unable to find specified class: " + className, e);
        }
    }

    private static ColumnResult buildColumnResult(Element columnResultElement, XMLContext.Default defaults) {
        AnnotationDescriptor columnResultDescriptor = new AnnotationDescriptor(ColumnResult.class);
        JPAOverriddenAnnotationReader.copyStringAttribute(columnResultDescriptor, columnResultElement, "name", true);
        String columnTypeName = columnResultElement.attributeValue("class");
        if (StringHelper.isNotEmpty(columnTypeName)) {
            columnResultDescriptor.setValue("type", (Object)JPAOverriddenAnnotationReader.resolveClassReference(columnTypeName, defaults));
        }
        return (ColumnResult)AnnotationFactory.create((AnnotationDescriptor)columnResultDescriptor);
    }

    private static ConstructorResult buildConstructorResult(Element constructorResultElement, XMLContext.Default defaults) {
        AnnotationDescriptor constructorResultDescriptor = new AnnotationDescriptor(ConstructorResult.class);
        Class entityClass = JPAOverriddenAnnotationReader.resolveClassReference(constructorResultElement.attributeValue("target-class"), defaults);
        constructorResultDescriptor.setValue("targetClass", (Object)entityClass);
        ArrayList<ColumnResult> columnResultAnnotations = new ArrayList<ColumnResult>();
        for (Element columnResultElement : constructorResultElement.elements("column")) {
            columnResultAnnotations.add(JPAOverriddenAnnotationReader.buildColumnResult(columnResultElement, defaults));
        }
        constructorResultDescriptor.setValue("columns", (Object)columnResultAnnotations.toArray(new ColumnResult[columnResultAnnotations.size()]));
        return (ConstructorResult)AnnotationFactory.create((AnnotationDescriptor)constructorResultDescriptor);
    }

    private void addSqlResultsetMappingIfNeeded(SqlResultSetMapping annotation, List<SqlResultSetMapping> resultsets) {
        if (annotation != null) {
            String resultsetName = annotation.name();
            boolean present = false;
            for (SqlResultSetMapping current : resultsets) {
                if (!current.name().equals(resultsetName)) continue;
                present = true;
                break;
            }
            if (!present) {
                resultsets.add(annotation);
            }
        }
    }

    private NamedQueries getNamedQueries(Element tree, XMLContext.Default defaults) {
        List queries = JPAOverriddenAnnotationReader.buildNamedQueries(tree, false, defaults);
        if (defaults.canUseJavaAnnotations()) {
            NamedQuery annotation = this.getPhysicalAnnotation(NamedQuery.class);
            this.addNamedQueryIfNeeded(annotation, queries);
            NamedQueries annotations = this.getPhysicalAnnotation(NamedQueries.class);
            if (annotations != null) {
                for (NamedQuery current : annotations.value()) {
                    this.addNamedQueryIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedQueries.class);
            ad.setValue("value", (Object)queries.toArray(new NamedQuery[queries.size()]));
            return (NamedQueries)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void addNamedQueryIfNeeded(NamedQuery annotation, List<NamedQuery> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedQuery current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    private NamedEntityGraphs getNamedEntityGraphs(Element tree, XMLContext.Default defaults) {
        List<NamedEntityGraph> queries = JPAOverriddenAnnotationReader.buildNamedEntityGraph(tree, defaults);
        if (defaults.canUseJavaAnnotations()) {
            NamedEntityGraph annotation = this.getPhysicalAnnotation(NamedEntityGraph.class);
            this.addNamedEntityGraphIfNeeded(annotation, queries);
            NamedEntityGraphs annotations = this.getPhysicalAnnotation(NamedEntityGraphs.class);
            if (annotations != null) {
                for (NamedEntityGraph current : annotations.value()) {
                    this.addNamedEntityGraphIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedEntityGraphs.class);
            ad.setValue("value", (Object)queries.toArray(new NamedEntityGraph[queries.size()]));
            return (NamedEntityGraphs)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void addNamedEntityGraphIfNeeded(NamedEntityGraph annotation, List<NamedEntityGraph> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedEntityGraph current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    private NamedStoredProcedureQueries getNamedStoredProcedureQueries(Element tree, XMLContext.Default defaults) {
        List<NamedStoredProcedureQuery> queries = JPAOverriddenAnnotationReader.buildNamedStoreProcedureQueries(tree, defaults);
        if (defaults.canUseJavaAnnotations()) {
            NamedStoredProcedureQuery annotation = this.getPhysicalAnnotation(NamedStoredProcedureQuery.class);
            this.addNamedStoredProcedureQueryIfNeeded(annotation, queries);
            NamedStoredProcedureQueries annotations = this.getPhysicalAnnotation(NamedStoredProcedureQueries.class);
            if (annotations != null) {
                for (NamedStoredProcedureQuery current : annotations.value()) {
                    this.addNamedStoredProcedureQueryIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedStoredProcedureQueries.class);
            ad.setValue("value", (Object)queries.toArray(new NamedStoredProcedureQuery[queries.size()]));
            return (NamedStoredProcedureQueries)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void addNamedStoredProcedureQueryIfNeeded(NamedStoredProcedureQuery annotation, List<NamedStoredProcedureQuery> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedStoredProcedureQuery current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    private NamedNativeQueries getNamedNativeQueries(Element tree, XMLContext.Default defaults) {
        List queries = JPAOverriddenAnnotationReader.buildNamedQueries(tree, true, defaults);
        if (defaults.canUseJavaAnnotations()) {
            NamedNativeQuery annotation = this.getPhysicalAnnotation(NamedNativeQuery.class);
            this.addNamedNativeQueryIfNeeded(annotation, queries);
            NamedNativeQueries annotations = this.getPhysicalAnnotation(NamedNativeQueries.class);
            if (annotations != null) {
                for (NamedNativeQuery current : annotations.value()) {
                    this.addNamedNativeQueryIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedNativeQueries.class);
            ad.setValue("value", (Object)queries.toArray(new NamedNativeQuery[queries.size()]));
            return (NamedNativeQueries)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private void addNamedNativeQueryIfNeeded(NamedNativeQuery annotation, List<NamedNativeQuery> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedNativeQuery current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    private static void buildQueryHints(List<Element> elements, AnnotationDescriptor ann) {
        ArrayList<QueryHint> queryHints = new ArrayList<QueryHint>(elements.size());
        for (Element hint : elements) {
            AnnotationDescriptor hintDescriptor = new AnnotationDescriptor(QueryHint.class);
            String value = hint.attributeValue("name");
            if (value == null) {
                throw new AnnotationException("<hint> without name. Activate schema validation for more information");
            }
            hintDescriptor.setValue("name", (Object)value);
            value = hint.attributeValue("value");
            if (value == null) {
                throw new AnnotationException("<hint> without value. Activate schema validation for more information");
            }
            hintDescriptor.setValue("value", (Object)value);
            queryHints.add((QueryHint)AnnotationFactory.create((AnnotationDescriptor)hintDescriptor));
        }
        ann.setValue("hints", (Object)queryHints.toArray(new QueryHint[queryHints.size()]));
    }

    public static List buildNamedQueries(Element element, boolean isNative, XMLContext.Default defaults) {
        if (element == null) {
            return new ArrayList();
        }
        List namedQueryElementList = isNative ? element.elements("named-native-query") : element.elements("named-query");
        ArrayList<Annotation> namedQueries = new ArrayList<Annotation>();
        ListIterator it = namedQueryElementList.listIterator();
        while (it.hasNext()) {
            Element subelement = (Element)it.next();
            AnnotationDescriptor ann = new AnnotationDescriptor(isNative ? NamedNativeQuery.class : NamedQuery.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(ann, subelement, "name", false);
            Element queryElt = subelement.element("query");
            if (queryElt == null) {
                throw new AnnotationException("No <query> element found.Activate schema validation for more information");
            }
            JPAOverriddenAnnotationReader.copyStringElement(queryElt, ann, "query");
            List elements = subelement.elements("hint");
            JPAOverriddenAnnotationReader.buildQueryHints(elements, ann);
            String clazzName = subelement.attributeValue("result-class");
            if (StringHelper.isNotEmpty(clazzName)) {
                Class clazz;
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(clazzName, defaults), JPAOverriddenAnnotationReader.class);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
                }
                ann.setValue("resultClass", (Object)clazz);
            }
            JPAOverriddenAnnotationReader.copyStringAttribute(ann, subelement, "result-set-mapping", false);
            namedQueries.add(AnnotationFactory.create((AnnotationDescriptor)ann));
        }
        return namedQueries;
    }

    private TableGenerator getTableGenerator(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element(annotationToXml.get(TableGenerator.class)) : null;
        if (element != null) {
            return JPAOverriddenAnnotationReader.buildTableGeneratorAnnotation(element, defaults);
        }
        if (defaults.canUseJavaAnnotations() && this.isPhysicalAnnotationPresent(TableGenerator.class)) {
            TableGenerator tableAnn = this.getPhysicalAnnotation(TableGenerator.class);
            if (StringHelper.isNotEmpty(defaults.getSchema()) || StringHelper.isNotEmpty(defaults.getCatalog())) {
                AnnotationDescriptor annotation = new AnnotationDescriptor(TableGenerator.class);
                annotation.setValue("name", (Object)tableAnn.name());
                annotation.setValue("table", (Object)tableAnn.table());
                annotation.setValue("catalog", (Object)tableAnn.table());
                if (StringHelper.isEmpty((String)annotation.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                    annotation.setValue("catalog", (Object)defaults.getCatalog());
                }
                annotation.setValue("schema", (Object)tableAnn.table());
                if (StringHelper.isEmpty((String)annotation.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                    annotation.setValue("catalog", (Object)defaults.getSchema());
                }
                annotation.setValue("pkColumnName", (Object)tableAnn.pkColumnName());
                annotation.setValue("valueColumnName", (Object)tableAnn.valueColumnName());
                annotation.setValue("pkColumnValue", (Object)tableAnn.pkColumnValue());
                annotation.setValue("initialValue", (Object)tableAnn.initialValue());
                annotation.setValue("allocationSize", (Object)tableAnn.allocationSize());
                annotation.setValue("uniqueConstraints", (Object)tableAnn.uniqueConstraints());
                return (TableGenerator)AnnotationFactory.create((AnnotationDescriptor)annotation);
            }
            return tableAnn;
        }
        return null;
    }

    public static TableGenerator buildTableGeneratorAnnotation(Element element, XMLContext.Default defaults) {
        AnnotationDescriptor ad = new AnnotationDescriptor(TableGenerator.class);
        JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "name", false);
        JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "table", false);
        JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "catalog", false);
        JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "schema", false);
        JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "pk-column-name", false);
        JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "value-column-name", false);
        JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "pk-column-value", false);
        JPAOverriddenAnnotationReader.copyIntegerAttribute(ad, element, "initial-value");
        JPAOverriddenAnnotationReader.copyIntegerAttribute(ad, element, "allocation-size");
        JPAOverriddenAnnotationReader.buildUniqueConstraints(ad, element);
        if (StringHelper.isEmpty((String)ad.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
            ad.setValue("schema", (Object)defaults.getSchema());
        }
        if (StringHelper.isEmpty((String)ad.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
            ad.setValue("catalog", (Object)defaults.getCatalog());
        }
        return (TableGenerator)AnnotationFactory.create((AnnotationDescriptor)ad);
    }

    private SequenceGenerator getSequenceGenerator(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element(annotationToXml.get(SequenceGenerator.class)) : null;
        if (element != null) {
            return JPAOverriddenAnnotationReader.buildSequenceGeneratorAnnotation(element);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(SequenceGenerator.class);
        }
        return null;
    }

    public static SequenceGenerator buildSequenceGeneratorAnnotation(Element element) {
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(SequenceGenerator.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "name", false);
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "sequence-name", false);
            JPAOverriddenAnnotationReader.copyIntegerAttribute(ad, element, "initial-value");
            JPAOverriddenAnnotationReader.copyIntegerAttribute(ad, element, "allocation-size");
            return (SequenceGenerator)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private DiscriminatorColumn getDiscriminatorColumn(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("discriminator-column") : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(DiscriminatorColumn.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "name", false);
            JPAOverriddenAnnotationReader.copyStringAttribute(ad, element, "column-definition", false);
            String value = element.attributeValue("discriminator-type");
            DiscriminatorType type = DiscriminatorType.STRING;
            if (value != null) {
                if ("STRING".equals(value)) {
                    type = DiscriminatorType.STRING;
                } else if ("CHAR".equals(value)) {
                    type = DiscriminatorType.CHAR;
                } else if ("INTEGER".equals(value)) {
                    type = DiscriminatorType.INTEGER;
                } else {
                    throw new AnnotationException("Unknown DiscrimiatorType in XML: " + value + " (" + SCHEMA_VALIDATION + ")");
                }
            }
            ad.setValue("discriminatorType", (Object)type);
            JPAOverriddenAnnotationReader.copyIntegerAttribute(ad, element, "length");
            return (DiscriminatorColumn)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(DiscriminatorColumn.class);
        }
        return null;
    }

    private DiscriminatorValue getDiscriminatorValue(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("discriminator-value") : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(DiscriminatorValue.class);
            JPAOverriddenAnnotationReader.copyStringElement(element, ad, "value");
            return (DiscriminatorValue)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(DiscriminatorValue.class);
        }
        return null;
    }

    private Inheritance getInheritance(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("inheritance") : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Inheritance.class);
            Attribute attr = element.attribute("strategy");
            InheritanceType strategy = InheritanceType.SINGLE_TABLE;
            if (attr != null) {
                String value = attr.getValue();
                if ("SINGLE_TABLE".equals(value)) {
                    strategy = InheritanceType.SINGLE_TABLE;
                } else if ("JOINED".equals(value)) {
                    strategy = InheritanceType.JOINED;
                } else if ("TABLE_PER_CLASS".equals(value)) {
                    strategy = InheritanceType.TABLE_PER_CLASS;
                } else {
                    throw new AnnotationException("Unknown InheritanceType in XML: " + value + " (" + SCHEMA_VALIDATION + ")");
                }
            }
            ad.setValue("strategy", (Object)strategy);
            return (Inheritance)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(Inheritance.class);
        }
        return null;
    }

    private IdClass getIdClass(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree == null ? null : tree.element("id-class");
        if (element != null) {
            Attribute attr = element.attribute("class");
            if (attr != null) {
                Class clazz;
                AnnotationDescriptor ad = new AnnotationDescriptor(IdClass.class);
                try {
                    clazz = ReflectHelper.classForName(XMLContext.buildSafeClassName(attr.getValue(), defaults), this.getClass());
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find id-class: " + attr.getValue(), e);
                }
                ad.setValue("value", (Object)clazz);
                return (IdClass)AnnotationFactory.create((AnnotationDescriptor)ad);
            }
            throw new AnnotationException("id-class without class. Activate schema validation for more information");
        }
        if (defaults.canUseJavaAnnotations()) {
            return this.getPhysicalAnnotation(IdClass.class);
        }
        return null;
    }

    private PrimaryKeyJoinColumns getPrimaryKeyJoinColumns(Element element, XMLContext.Default defaults, boolean mergeWithAnnotations) {
        PrimaryKeyJoinColumn[] columns = this.buildPrimaryKeyJoinColumns(element);
        if (mergeWithAnnotations && columns.length == 0 && defaults.canUseJavaAnnotations()) {
            PrimaryKeyJoinColumn annotation = this.getPhysicalAnnotation(PrimaryKeyJoinColumn.class);
            if (annotation != null) {
                columns = new PrimaryKeyJoinColumn[]{annotation};
            } else {
                PrimaryKeyJoinColumns annotations = this.getPhysicalAnnotation(PrimaryKeyJoinColumns.class);
                PrimaryKeyJoinColumn[] primaryKeyJoinColumnArray = columns = annotations != null ? annotations.value() : columns;
            }
        }
        if (columns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(PrimaryKeyJoinColumns.class);
            ad.setValue("value", (Object)columns);
            return (PrimaryKeyJoinColumns)AnnotationFactory.create((AnnotationDescriptor)ad);
        }
        return null;
    }

    private Entity getEntity(Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return defaults.canUseJavaAnnotations() ? this.getPhysicalAnnotation(Entity.class) : null;
        }
        if ("entity".equals(tree.getName())) {
            Entity javaAnn;
            AnnotationDescriptor entity = new AnnotationDescriptor(Entity.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(entity, tree, "name", false);
            if (defaults.canUseJavaAnnotations() && StringHelper.isEmpty((String)entity.valueOf("name")) && (javaAnn = this.getPhysicalAnnotation(Entity.class)) != null) {
                entity.setValue("name", (Object)javaAnn.name());
            }
            return (Entity)AnnotationFactory.create((AnnotationDescriptor)entity);
        }
        return null;
    }

    private MappedSuperclass getMappedSuperclass(Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return defaults.canUseJavaAnnotations() ? this.getPhysicalAnnotation(MappedSuperclass.class) : null;
        }
        if ("mapped-superclass".equals(tree.getName())) {
            AnnotationDescriptor entity = new AnnotationDescriptor(MappedSuperclass.class);
            return (MappedSuperclass)AnnotationFactory.create((AnnotationDescriptor)entity);
        }
        return null;
    }

    private Embeddable getEmbeddable(Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return defaults.canUseJavaAnnotations() ? this.getPhysicalAnnotation(Embeddable.class) : null;
        }
        if ("embeddable".equals(tree.getName())) {
            AnnotationDescriptor entity = new AnnotationDescriptor(Embeddable.class);
            return (Embeddable)AnnotationFactory.create((AnnotationDescriptor)entity);
        }
        return null;
    }

    private Table getTable(Element tree, XMLContext.Default defaults) {
        Element subelement;
        Element element = subelement = tree == null ? null : tree.element("table");
        if (subelement == null) {
            if (StringHelper.isNotEmpty(defaults.getCatalog()) || StringHelper.isNotEmpty(defaults.getSchema())) {
                Table table;
                AnnotationDescriptor annotation = new AnnotationDescriptor(Table.class);
                if (defaults.canUseJavaAnnotations() && (table = this.getPhysicalAnnotation(Table.class)) != null) {
                    annotation.setValue("name", (Object)table.name());
                    annotation.setValue("schema", (Object)table.schema());
                    annotation.setValue("catalog", (Object)table.catalog());
                    annotation.setValue("uniqueConstraints", (Object)table.uniqueConstraints());
                    annotation.setValue("indexes", (Object)table.indexes());
                }
                if (StringHelper.isEmpty((String)annotation.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                    annotation.setValue("schema", (Object)defaults.getSchema());
                }
                if (StringHelper.isEmpty((String)annotation.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                    annotation.setValue("catalog", (Object)defaults.getCatalog());
                }
                return (Table)AnnotationFactory.create((AnnotationDescriptor)annotation);
            }
            if (defaults.canUseJavaAnnotations()) {
                return this.getPhysicalAnnotation(Table.class);
            }
            return null;
        }
        AnnotationDescriptor annotation = new AnnotationDescriptor(Table.class);
        JPAOverriddenAnnotationReader.copyStringAttribute(annotation, subelement, "name", false);
        JPAOverriddenAnnotationReader.copyStringAttribute(annotation, subelement, "catalog", false);
        if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
            annotation.setValue("catalog", (Object)defaults.getCatalog());
        }
        JPAOverriddenAnnotationReader.copyStringAttribute(annotation, subelement, "schema", false);
        if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
            annotation.setValue("schema", (Object)defaults.getSchema());
        }
        JPAOverriddenAnnotationReader.buildUniqueConstraints(annotation, subelement);
        JPAOverriddenAnnotationReader.buildIndex(annotation, subelement);
        return (Table)AnnotationFactory.create((AnnotationDescriptor)annotation);
    }

    private SecondaryTables getSecondaryTables(Element tree, XMLContext.Default defaults) {
        List elements = tree == null ? new ArrayList() : tree.elements("secondary-table");
        ArrayList<SecondaryTable> secondaryTables = new ArrayList<SecondaryTable>(3);
        for (Element element : elements) {
            AnnotationDescriptor annotation = new AnnotationDescriptor(SecondaryTable.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(annotation, element, "name", false);
            JPAOverriddenAnnotationReader.copyStringAttribute(annotation, element, "catalog", false);
            if (StringHelper.isNotEmpty(defaults.getCatalog()) && StringHelper.isEmpty((String)annotation.valueOf("catalog"))) {
                annotation.setValue("catalog", (Object)defaults.getCatalog());
            }
            JPAOverriddenAnnotationReader.copyStringAttribute(annotation, element, "schema", false);
            if (StringHelper.isNotEmpty(defaults.getSchema()) && StringHelper.isEmpty((String)annotation.valueOf("schema"))) {
                annotation.setValue("schema", (Object)defaults.getSchema());
            }
            JPAOverriddenAnnotationReader.buildUniqueConstraints(annotation, element);
            JPAOverriddenAnnotationReader.buildIndex(annotation, element);
            annotation.setValue("pkJoinColumns", (Object)this.buildPrimaryKeyJoinColumns(element));
            secondaryTables.add((SecondaryTable)AnnotationFactory.create((AnnotationDescriptor)annotation));
        }
        if (secondaryTables.size() == 0 && defaults.canUseJavaAnnotations()) {
            SecondaryTable secTableAnn = this.getPhysicalAnnotation(SecondaryTable.class);
            this.overridesDefaultInSecondaryTable(secTableAnn, defaults, secondaryTables);
            SecondaryTables secTablesAnn = this.getPhysicalAnnotation(SecondaryTables.class);
            if (secTablesAnn != null) {
                for (SecondaryTable table : secTablesAnn.value()) {
                    this.overridesDefaultInSecondaryTable(table, defaults, secondaryTables);
                }
            }
        }
        if (secondaryTables.size() > 0) {
            AnnotationDescriptor descriptor = new AnnotationDescriptor(SecondaryTables.class);
            descriptor.setValue("value", (Object)secondaryTables.toArray(new SecondaryTable[secondaryTables.size()]));
            return (SecondaryTables)AnnotationFactory.create((AnnotationDescriptor)descriptor);
        }
        return null;
    }

    private void overridesDefaultInSecondaryTable(SecondaryTable secTableAnn, XMLContext.Default defaults, List<SecondaryTable> secondaryTables) {
        if (secTableAnn != null) {
            if (StringHelper.isNotEmpty(defaults.getCatalog()) || StringHelper.isNotEmpty(defaults.getSchema())) {
                AnnotationDescriptor annotation = new AnnotationDescriptor(SecondaryTable.class);
                annotation.setValue("name", (Object)secTableAnn.name());
                annotation.setValue("schema", (Object)secTableAnn.schema());
                annotation.setValue("catalog", (Object)secTableAnn.catalog());
                annotation.setValue("uniqueConstraints", (Object)secTableAnn.uniqueConstraints());
                annotation.setValue("pkJoinColumns", (Object)secTableAnn.pkJoinColumns());
                if (StringHelper.isEmpty((String)annotation.valueOf("schema")) && StringHelper.isNotEmpty(defaults.getSchema())) {
                    annotation.setValue("schema", (Object)defaults.getSchema());
                }
                if (StringHelper.isEmpty((String)annotation.valueOf("catalog")) && StringHelper.isNotEmpty(defaults.getCatalog())) {
                    annotation.setValue("catalog", (Object)defaults.getCatalog());
                }
                secondaryTables.add((SecondaryTable)AnnotationFactory.create((AnnotationDescriptor)annotation));
            } else {
                secondaryTables.add(secTableAnn);
            }
        }
    }

    private static void buildIndex(AnnotationDescriptor annotation, Element element) {
        List indexElementList = element.elements("index");
        Index[] indexes = new Index[indexElementList.size()];
        for (int i = 0; i < indexElementList.size(); ++i) {
            Element subelement = (Element)indexElementList.get(i);
            AnnotationDescriptor indexAnn = new AnnotationDescriptor(Index.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(indexAnn, subelement, "name", false);
            JPAOverriddenAnnotationReader.copyStringAttribute(indexAnn, subelement, "column-list", true);
            JPAOverriddenAnnotationReader.copyBooleanAttribute(indexAnn, subelement, "unique");
            indexes[i] = (Index)AnnotationFactory.create((AnnotationDescriptor)indexAnn);
        }
        annotation.setValue("indexes", (Object)indexes);
    }

    private static void buildUniqueConstraints(AnnotationDescriptor annotation, Element element) {
        List uniqueConstraintElementList = element.elements("unique-constraint");
        UniqueConstraint[] uniqueConstraints = new UniqueConstraint[uniqueConstraintElementList.size()];
        int ucIndex = 0;
        ListIterator ucIt = uniqueConstraintElementList.listIterator();
        while (ucIt.hasNext()) {
            Element subelement = (Element)ucIt.next();
            List columnNamesElements = subelement.elements("column-name");
            String[] columnNames = new String[columnNamesElements.size()];
            int columnNameIndex = 0;
            ListIterator it = columnNamesElements.listIterator();
            while (it.hasNext()) {
                Element columnNameElt = (Element)it.next();
                columnNames[columnNameIndex++] = columnNameElt.getTextTrim();
            }
            AnnotationDescriptor ucAnn = new AnnotationDescriptor(UniqueConstraint.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(ucAnn, subelement, "name", false);
            ucAnn.setValue("columnNames", (Object)columnNames);
            uniqueConstraints[ucIndex++] = (UniqueConstraint)AnnotationFactory.create((AnnotationDescriptor)ucAnn);
        }
        annotation.setValue("uniqueConstraints", (Object)uniqueConstraints);
    }

    private PrimaryKeyJoinColumn[] buildPrimaryKeyJoinColumns(Element element) {
        if (element == null) {
            return new PrimaryKeyJoinColumn[0];
        }
        List pkJoinColumnElementList = element.elements("primary-key-join-column");
        PrimaryKeyJoinColumn[] pkJoinColumns = new PrimaryKeyJoinColumn[pkJoinColumnElementList.size()];
        int index = 0;
        ListIterator pkIt = pkJoinColumnElementList.listIterator();
        while (pkIt.hasNext()) {
            Element subelement = (Element)pkIt.next();
            AnnotationDescriptor pkAnn = new AnnotationDescriptor(PrimaryKeyJoinColumn.class);
            JPAOverriddenAnnotationReader.copyStringAttribute(pkAnn, subelement, "name", false);
            JPAOverriddenAnnotationReader.copyStringAttribute(pkAnn, subelement, "referenced-column-name", false);
            JPAOverriddenAnnotationReader.copyStringAttribute(pkAnn, subelement, "column-definition", false);
            pkJoinColumns[index++] = (PrimaryKeyJoinColumn)AnnotationFactory.create((AnnotationDescriptor)pkAnn);
        }
        return pkJoinColumns;
    }

    private static void copyStringAttribute(AnnotationDescriptor annotation, Element element, String attributeName, boolean mandatory) {
        JPAOverriddenAnnotationReader.copyStringAttribute(annotation, element, JPAOverriddenAnnotationReader.getJavaAttributeNameFromXMLOne(attributeName), attributeName, mandatory);
    }

    private static void copyStringAttribute(AnnotationDescriptor annotation, Element element, String annotationAttributeName, String attributeName, boolean mandatory) {
        String attribute = element.attributeValue(attributeName);
        if (attribute != null) {
            annotation.setValue(annotationAttributeName, (Object)attribute);
        } else if (mandatory) {
            throw new AnnotationException(element.getName() + "." + attributeName + " is mandatory in XML overriding. " + SCHEMA_VALIDATION);
        }
    }

    private static void copyIntegerAttribute(AnnotationDescriptor annotation, Element element, String attributeName) {
        String attribute = element.attributeValue(attributeName);
        if (attribute != null) {
            String annotationAttributeName = JPAOverriddenAnnotationReader.getJavaAttributeNameFromXMLOne(attributeName);
            annotation.setValue(annotationAttributeName, (Object)attribute);
            try {
                int length = Integer.parseInt(attribute);
                annotation.setValue(annotationAttributeName, (Object)length);
            }
            catch (NumberFormatException e) {
                throw new AnnotationException(element.getPath() + attributeName + " not parseable: " + attribute + " (" + SCHEMA_VALIDATION + ")");
            }
        }
    }

    private static String getJavaAttributeNameFromXMLOne(String attributeName) {
        StringBuilder annotationAttributeName = new StringBuilder(attributeName);
        int index = annotationAttributeName.indexOf(WORD_SEPARATOR);
        while (index != -1) {
            annotationAttributeName.deleteCharAt(index);
            annotationAttributeName.setCharAt(index, Character.toUpperCase(annotationAttributeName.charAt(index)));
            index = annotationAttributeName.indexOf(WORD_SEPARATOR);
        }
        return annotationAttributeName.toString();
    }

    private static void copyStringElement(Element element, AnnotationDescriptor ad, String annotationAttribute) {
        String discr = element.getTextTrim();
        ad.setValue(annotationAttribute, (Object)discr);
    }

    private static void copyBooleanAttribute(AnnotationDescriptor descriptor, Element element, String attribute) {
        String attributeValue = element.attributeValue(attribute);
        if (StringHelper.isNotEmpty(attributeValue)) {
            String javaAttribute = JPAOverriddenAnnotationReader.getJavaAttributeNameFromXMLOne(attribute);
            descriptor.setValue(javaAttribute, (Object)Boolean.parseBoolean(attributeValue));
        }
    }

    private <T extends Annotation> T getPhysicalAnnotation(Class<T> annotationType) {
        return this.element.getAnnotation(annotationType);
    }

    private <T extends Annotation> boolean isPhysicalAnnotationPresent(Class<T> annotationType) {
        return this.element.isAnnotationPresent(annotationType);
    }

    private Annotation[] getPhysicalAnnotations() {
        return this.element.getAnnotations();
    }

    static {
        annotationToXml.put(Entity.class, "entity");
        annotationToXml.put(MappedSuperclass.class, "mapped-superclass");
        annotationToXml.put(Embeddable.class, "embeddable");
        annotationToXml.put(Table.class, "table");
        annotationToXml.put(SecondaryTable.class, "secondary-table");
        annotationToXml.put(SecondaryTables.class, "secondary-table");
        annotationToXml.put(PrimaryKeyJoinColumn.class, "primary-key-join-column");
        annotationToXml.put(PrimaryKeyJoinColumns.class, "primary-key-join-column");
        annotationToXml.put(IdClass.class, "id-class");
        annotationToXml.put(Inheritance.class, "inheritance");
        annotationToXml.put(DiscriminatorValue.class, "discriminator-value");
        annotationToXml.put(DiscriminatorColumn.class, "discriminator-column");
        annotationToXml.put(SequenceGenerator.class, "sequence-generator");
        annotationToXml.put(TableGenerator.class, "table-generator");
        annotationToXml.put(NamedEntityGraph.class, "named-entity-graph");
        annotationToXml.put(NamedEntityGraphs.class, "named-entity-graph");
        annotationToXml.put(NamedQuery.class, "named-query");
        annotationToXml.put(NamedQueries.class, "named-query");
        annotationToXml.put(NamedNativeQuery.class, "named-native-query");
        annotationToXml.put(NamedNativeQueries.class, "named-native-query");
        annotationToXml.put(NamedStoredProcedureQuery.class, "named-stored-procedure-query");
        annotationToXml.put(NamedStoredProcedureQueries.class, "named-stored-procedure-query");
        annotationToXml.put(SqlResultSetMapping.class, "sql-result-set-mapping");
        annotationToXml.put(SqlResultSetMappings.class, "sql-result-set-mapping");
        annotationToXml.put(ExcludeDefaultListeners.class, "exclude-default-listeners");
        annotationToXml.put(ExcludeSuperclassListeners.class, "exclude-superclass-listeners");
        annotationToXml.put(AccessType.class, "access");
        annotationToXml.put(AttributeOverride.class, "attribute-override");
        annotationToXml.put(AttributeOverrides.class, "attribute-override");
        annotationToXml.put(AttributeOverride.class, "association-override");
        annotationToXml.put(AttributeOverrides.class, "association-override");
        annotationToXml.put(AttributeOverride.class, "map-key-attribute-override");
        annotationToXml.put(AttributeOverrides.class, "map-key-attribute-override");
        annotationToXml.put(Id.class, "id");
        annotationToXml.put(EmbeddedId.class, "embedded-id");
        annotationToXml.put(GeneratedValue.class, "generated-value");
        annotationToXml.put(Column.class, "column");
        annotationToXml.put(Columns.class, "column");
        annotationToXml.put(Temporal.class, "temporal");
        annotationToXml.put(Lob.class, "lob");
        annotationToXml.put(Enumerated.class, "enumerated");
        annotationToXml.put(Version.class, "version");
        annotationToXml.put(Transient.class, "transient");
        annotationToXml.put(Basic.class, "basic");
        annotationToXml.put(Embedded.class, "embedded");
        annotationToXml.put(ManyToOne.class, "many-to-one");
        annotationToXml.put(OneToOne.class, "one-to-one");
        annotationToXml.put(OneToMany.class, "one-to-many");
        annotationToXml.put(ManyToMany.class, "many-to-many");
        annotationToXml.put(Any.class, "any");
        annotationToXml.put(ManyToAny.class, "many-to-any");
        annotationToXml.put(JoinTable.class, "join-table");
        annotationToXml.put(JoinColumn.class, "join-column");
        annotationToXml.put(JoinColumns.class, "join-column");
        annotationToXml.put(MapKey.class, "map-key");
        annotationToXml.put(OrderBy.class, "order-by");
        annotationToXml.put(EntityListeners.class, "entity-listeners");
        annotationToXml.put(PrePersist.class, "pre-persist");
        annotationToXml.put(PreRemove.class, "pre-remove");
        annotationToXml.put(PreUpdate.class, "pre-update");
        annotationToXml.put(PostPersist.class, "post-persist");
        annotationToXml.put(PostRemove.class, "post-remove");
        annotationToXml.put(PostUpdate.class, "post-update");
        annotationToXml.put(PostLoad.class, "post-load");
        annotationToXml.put(CollectionTable.class, "collection-table");
        annotationToXml.put(MapKeyClass.class, "map-key-class");
        annotationToXml.put(MapKeyTemporal.class, "map-key-temporal");
        annotationToXml.put(MapKeyEnumerated.class, "map-key-enumerated");
        annotationToXml.put(MapKeyColumn.class, "map-key-column");
        annotationToXml.put(MapKeyJoinColumn.class, "map-key-join-column");
        annotationToXml.put(MapKeyJoinColumns.class, "map-key-join-column");
        annotationToXml.put(OrderColumn.class, "order-column");
        annotationToXml.put(Cacheable.class, "cacheable");
        annotationToXml.put(Index.class, "index");
        annotationToXml.put(ForeignKey.class, "foreign-key");
        annotationToXml.put(Convert.class, "convert");
        annotationToXml.put(Converts.class, "convert");
        annotationToXml.put(ConstructorResult.class, "constructor-result");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyType {
        PROPERTY,
        FIELD,
        METHOD;

    }
}

