/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.NamedStoredProcedureQuery;
import javax.persistence.ParameterMode;
import javax.persistence.StoredProcedureParameter;
import org.hibernate.MappingException;
import org.hibernate.cfg.annotations.QueryHintDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.procedure.ProcedureCallMemento;
import org.hibernate.procedure.internal.ProcedureCallMementoImpl;
import org.hibernate.procedure.internal.Util;
import org.hibernate.procedure.spi.ParameterStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedProcedureCallDefinition {
    private final String registeredName;
    private final String procedureName;
    private final Class[] resultClasses;
    private final String[] resultSetMappings;
    private final ParameterDefinitions parameterDefinitions;
    private final Map<String, Object> hints;

    NamedProcedureCallDefinition(NamedStoredProcedureQuery annotation) {
        boolean specifiesResultSetMappings;
        this.registeredName = annotation.name();
        this.procedureName = annotation.procedureName();
        this.resultClasses = annotation.resultClasses();
        this.resultSetMappings = annotation.resultSetMappings();
        this.parameterDefinitions = new ParameterDefinitions(annotation.parameters());
        this.hints = new QueryHintDefinition(annotation.hints()).getHintsMap();
        boolean specifiesResultClasses = this.resultClasses != null && this.resultClasses.length > 0;
        boolean bl = specifiesResultSetMappings = this.resultSetMappings != null && this.resultSetMappings.length > 0;
        if (specifiesResultClasses && specifiesResultSetMappings) {
            throw new MappingException(String.format("NamedStoredProcedureQuery [%s] specified both resultClasses and resultSetMappings", this.registeredName));
        }
    }

    public String getRegisteredName() {
        return this.registeredName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public ProcedureCallMemento toMemento(final SessionFactoryImpl sessionFactory, final Map<String, ResultSetMappingDefinition> resultSetMappingDefinitions) {
        boolean specifiesResultSetMappings;
        final ArrayList collectedQueryReturns = new ArrayList();
        final HashSet<String> collectedQuerySpaces = new HashSet<String>();
        boolean specifiesResultClasses = this.resultClasses != null && this.resultClasses.length > 0;
        boolean bl = specifiesResultSetMappings = this.resultSetMappings != null && this.resultSetMappings.length > 0;
        if (specifiesResultClasses) {
            Util.resolveResultClasses(new Util.ResultClassesResolutionContext(){

                public SessionFactoryImplementor getSessionFactory() {
                    return sessionFactory;
                }

                public void addQueryReturns(NativeSQLQueryReturn ... queryReturns) {
                    Collections.addAll(collectedQueryReturns, queryReturns);
                }

                public void addQuerySpaces(String ... spaces) {
                    Collections.addAll(collectedQuerySpaces, spaces);
                }
            }, this.resultClasses);
        } else if (specifiesResultSetMappings) {
            Util.resolveResultSetMappings(new Util.ResultSetMappingResolutionContext(){

                public SessionFactoryImplementor getSessionFactory() {
                    return sessionFactory;
                }

                public ResultSetMappingDefinition findResultSetMapping(String name) {
                    return (ResultSetMappingDefinition)resultSetMappingDefinitions.get(name);
                }

                public void addQueryReturns(NativeSQLQueryReturn ... queryReturns) {
                    Collections.addAll(collectedQueryReturns, queryReturns);
                }

                public void addQuerySpaces(String ... spaces) {
                    Collections.addAll(collectedQuerySpaces, spaces);
                }
            }, this.resultSetMappings);
        }
        return new ProcedureCallMementoImpl(this.procedureName, collectedQueryReturns.toArray(new NativeSQLQueryReturn[collectedQueryReturns.size()]), this.parameterDefinitions.getParameterStrategy(), this.parameterDefinitions.toMementos(sessionFactory), collectedQuerySpaces, this.hints);
    }

    private static String normalize(String name) {
        return StringHelper.isNotEmpty(name) ? name : null;
    }

    static class ParameterDefinition {
        private final Integer position;
        private final String name;
        private final ParameterMode parameterMode;
        private final Class type;

        ParameterDefinition(int position, StoredProcedureParameter annotation) {
            this.position = position;
            this.name = NamedProcedureCallDefinition.normalize(annotation.name());
            this.parameterMode = annotation.mode();
            this.type = annotation.type();
        }

        public ProcedureCallMementoImpl.ParameterMemento toMemento(SessionFactoryImpl sessionFactory) {
            return new ProcedureCallMementoImpl.ParameterMemento(this.position, this.name, this.parameterMode, this.type, sessionFactory.getTypeResolver().heuristicType(this.type.getName()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParameterDefinitions {
        private final ParameterStrategy parameterStrategy;
        private final ParameterDefinition[] parameterDefinitions;

        ParameterDefinitions(StoredProcedureParameter[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.parameterStrategy = ParameterStrategy.POSITIONAL;
                this.parameterDefinitions = new ParameterDefinition[0];
            } else {
                this.parameterStrategy = StringHelper.isNotEmpty(parameters[0].name()) ? ParameterStrategy.NAMED : ParameterStrategy.POSITIONAL;
                this.parameterDefinitions = new ParameterDefinition[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    this.parameterDefinitions[i] = new ParameterDefinition(i + 1, parameters[i]);
                }
            }
        }

        public ParameterStrategy getParameterStrategy() {
            return this.parameterStrategy;
        }

        public List<ProcedureCallMementoImpl.ParameterMemento> toMementos(SessionFactoryImpl sessionFactory) {
            ArrayList<ProcedureCallMementoImpl.ParameterMemento> mementos = new ArrayList<ProcedureCallMementoImpl.ParameterMemento>();
            for (ParameterDefinition definition : this.parameterDefinitions) {
                mementos.add(definition.toMemento(sessionFactory));
            }
            return mementos;
        }
    }
}

