/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.spi;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateTimestampsCache {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)UpdateTimestampsCache.class.getName());
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();
    public static final String REGION_NAME = UpdateTimestampsCache.class.getName();
    private final SessionFactoryImplementor factory;
    private final TimestampsRegion region;

    public UpdateTimestampsCache(Settings settings, Properties props, SessionFactoryImplementor factory) {
        this.factory = factory;
        String prefix = settings.getCacheRegionPrefix();
        String regionName = prefix == null ? REGION_NAME : prefix + '.' + REGION_NAME;
        LOG.startingUpdateTimestampsCache(regionName);
        this.region = settings.getRegionFactory().buildTimestampsRegion(regionName, props);
    }

    public UpdateTimestampsCache(Settings settings, Properties props) {
        this(settings, props, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvalidate(Serializable[] spaces, SessionImplementor session) throws CacheException {
        boolean stats = this.factory != null && this.factory.getStatistics().isStatisticsEnabled();
        Long ts = this.region.nextTimestamp() + (long)this.region.getTimeout();
        for (Serializable space : spaces) {
            if (DEBUG_ENABLED) {
                LOG.debugf("Pre-invalidating space [%s], timestamp: %s", space, ts);
            }
            try {
                session.getEventListenerManager().cachePutStart();
                this.region.put(space, ts);
            }
            finally {
                session.getEventListenerManager().cachePutEnd();
            }
            if (!stats) continue;
            this.factory.getStatisticsImplementor().updateTimestampsCachePut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Serializable[] spaces, SessionImplementor session) throws CacheException {
        boolean stats = this.factory != null && this.factory.getStatistics().isStatisticsEnabled();
        Long ts = this.region.nextTimestamp();
        for (Serializable space : spaces) {
            if (DEBUG_ENABLED) {
                LOG.debugf("Invalidating space [%s], timestamp: %s", space, ts);
            }
            try {
                session.getEventListenerManager().cachePutStart();
                this.region.put(space, ts);
            }
            finally {
                session.getEventListenerManager().cachePutEnd();
            }
            if (!stats) continue;
            this.factory.getStatisticsImplementor().updateTimestampsCachePut();
        }
    }

    public boolean isUpToDate(Set<Serializable> spaces, Long timestamp, SessionImplementor session) throws CacheException {
        boolean stats = this.factory != null && this.factory.getStatistics().isStatisticsEnabled();
        for (Serializable space : spaces) {
            Long lastUpdate = this.getLastUpdateTimestampForSpace(space, session);
            if (lastUpdate == null) {
                if (!stats) continue;
                this.factory.getStatisticsImplementor().updateTimestampsCacheMiss();
                continue;
            }
            if (DEBUG_ENABLED) {
                LOG.debugf("[%s] last update timestamp: %s", space, lastUpdate + ", result set timestamp: " + timestamp);
            }
            if (stats) {
                this.factory.getStatisticsImplementor().updateTimestampsCacheHit();
            }
            if (lastUpdate < timestamp) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getLastUpdateTimestampForSpace(Serializable space, SessionImplementor session) {
        Long ts = null;
        try {
            session.getEventListenerManager().cacheGetStart();
            ts = (Long)this.region.get(space);
            session.getEventListenerManager().cacheGetEnd(ts != null);
        }
        catch (Throwable throwable) {
            session.getEventListenerManager().cacheGetEnd(ts != null);
            throw throwable;
        }
        return ts;
    }

    public void clear() throws CacheException {
        this.region.evictAll();
    }

    public void destroy() {
        try {
            this.region.destroy();
        }
        catch (Exception e) {
            LOG.unableToDestroyUpdateTimestampsCache(this.region.getName(), e.getMessage());
        }
    }

    public TimestampsRegion getRegion() {
        return this.region;
    }

    public String toString() {
        return "UpdateTimestampsCache";
    }
}

