/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCommitInsertEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityInsertAction
extends AbstractEntityInsertAction {
    private Object version;
    private Object cacheEntry;

    public EntityInsertAction(Serializable id, Object[] state, Object instance, Object version, EntityPersister persister, boolean isVersionIncrementDisabled, SessionImplementor session) {
        super(id, state, instance, isVersionIncrementDisabled, persister, session);
        this.version = version;
    }

    public boolean isEarlyInsert() {
        return false;
    }

    protected EntityKey getEntityKey() {
        return this.getSession().generateEntityKey(this.getId(), this.getPersister());
    }

    public void execute() throws HibernateException {
        this.nullifyTransientReferencesIfNotAlready();
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        Serializable id = this.getId();
        boolean veto = this.preInsert();
        if (!veto) {
            persister.insert(id, this.getState(), instance, session);
            EntityEntry entry = session.getPersistenceContext().getEntry(instance);
            if (entry == null) {
                throw new AssertionFailure("possible non-threadsafe access to session");
            }
            entry.postInsert(this.getState());
            if (persister.hasInsertGeneratedProperties()) {
                persister.processInsertGeneratedProperties(id, instance, this.getState(), session);
                if (persister.isVersionPropertyGenerated()) {
                    this.version = Versioning.getVersion(this.getState(), persister);
                }
                entry.postUpdate(instance, this.getState(), this.version);
            }
            this.getSession().getPersistenceContext().registerInsertedKey(this.getPersister(), this.getId());
        }
        SessionFactoryImplementor factory = this.getSession().getFactory();
        if (this.isCachePutEnabled(persister, session)) {
            CacheEntry ce = persister.buildCacheEntry(instance, this.getState(), this.version, session);
            this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
            CacheKey ck = session.generateCacheKey(id, persister.getIdentifierType(), persister.getRootEntityName());
            boolean put = this.cacheInsert(persister, ck);
            if (put && factory.getStatistics().isStatisticsEnabled()) {
                factory.getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
            }
        }
        this.handleNaturalIdPostSaveNotifications(id);
        this.postInsert();
        if (factory.getStatistics().isStatisticsEnabled() && !veto) {
            factory.getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
        this.markExecuted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheInsert(EntityPersister persister, CacheKey ck) {
        try {
            this.getSession().getEventListenerManager().cachePutStart();
            boolean bl = persister.getCacheAccessStrategy().insert(ck, this.cacheEntry, this.version);
            return bl;
        }
        finally {
            this.getSession().getEventListenerManager().cachePutEnd();
        }
    }

    private void postInsert() {
        EventListenerGroup<PostInsertEventListener> listenerGroup = this.listenerGroup(EventType.POST_INSERT);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent event = new PostInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
        for (PostInsertEventListener listener : listenerGroup.listeners()) {
            listener.onPostInsert(event);
        }
    }

    private void postCommitInsert(boolean success) {
        EventListenerGroup<PostInsertEventListener> listenerGroup = this.listenerGroup(EventType.POST_COMMIT_INSERT);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostInsertEvent event = new PostInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
        for (PostInsertEventListener listener : listenerGroup.listeners()) {
            if (PostCommitInsertEventListener.class.isInstance(listener)) {
                if (success) {
                    listener.onPostInsert(event);
                    continue;
                }
                ((PostCommitInsertEventListener)listener).onPostInsertCommitFailed(event);
                continue;
            }
            listener.onPostInsert(event);
        }
    }

    private boolean preInsert() {
        boolean veto = false;
        EventListenerGroup<PreInsertEventListener> listenerGroup = this.listenerGroup(EventType.PRE_INSERT);
        if (listenerGroup.isEmpty()) {
            return veto;
        }
        PreInsertEvent event = new PreInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
        for (PreInsertEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreInsert(event);
        }
        return veto;
    }

    public void doAfterTransactionCompletion(boolean success, SessionImplementor session) throws HibernateException {
        CacheKey ck;
        boolean put;
        EntityPersister persister = this.getPersister();
        if (success && this.isCachePutEnabled(persister, this.getSession()) && (put = this.cacheAfterInsert(persister, ck = this.getSession().generateCacheKey(this.getId(), persister.getIdentifierType(), persister.getRootEntityName()))) && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCacheAccessStrategy().getRegion().getName());
        }
        this.postCommitInsert(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheAfterInsert(EntityPersister persister, CacheKey ck) {
        try {
            this.getSession().getEventListenerManager().cachePutStart();
            boolean bl = persister.getCacheAccessStrategy().afterInsert(ck, this.cacheEntry, this.version);
            return bl;
        }
        finally {
            this.getSession().getEventListenerManager().cachePutEnd();
        }
    }

    protected boolean hasPostCommitEventListeners() {
        EventListenerGroup<PostInsertEventListener> group = this.listenerGroup(EventType.POST_COMMIT_INSERT);
        for (PostInsertEventListener listener : group.listeners()) {
            if (!listener.requiresPostCommitHanding(this.getPersister())) continue;
            return true;
        }
        return false;
    }

    private boolean isCachePutEnabled(EntityPersister persister, SessionImplementor session) {
        return persister.hasCache() && !persister.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled();
    }
}

