/*
 * Decompiled with CFR 0.152.
 */
package response.syno.api.info;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import connect.Connection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import response.Response;
import response.helper.ResponseContainer;
import response.statuscode.Status;
import response.syno.api.info.API_Description_Object;

public class QueryInfoResponse
extends Response<Status, String> {
    private static final long serialVersionUID = 7879182902125441172L;
    private List<API_Description_Object> apiList = new ArrayList<API_Description_Object>();

    public ResponseContainer<Status, String> handleResponse(HttpResponse response) {
        HttpEntity entity;
        int status = response.getStatusLine().getStatusCode();
        Status enumStatus = Status.getErrorCode(status);
        String content = "";
        if (enumStatus == Status.STATUS_200 && (entity = response.getEntity()) != null) {
            String temp = null;
            try {
                temp = EntityUtils.toString((HttpEntity)entity);
            }
            catch (IOException | ParseException throwable) {
                // empty catch block
            }
            if (temp != null) {
                content = temp;
            }
        }
        return new ResponseContainer<Status, String>(enumStatus, content);
    }

    @Override
    public Response<Status, String> setHttpResponse(HttpResponse httpResponse) {
        Object responseContainer = this.handleResponse(httpResponse);
        Connection.fireIAPIMessage(((Status)((Object)((ResponseContainer)responseContainer).getStatusCode())).getStatusCode(), (String)((ResponseContainer)responseContainer).getAnswerValue());
        if (((ResponseContainer)responseContainer).getStatusCode() == Status.STATUS_200) {
            return this.fillResponseObjectString(this, (String)((ResponseContainer)responseContainer).getAnswerValue());
        }
        return this;
    }

    @Override
    protected boolean useOwnParser() {
        return true;
    }

    public void clearAPIList() {
        this.apiList = new ArrayList<API_Description_Object>();
    }

    public List<API_Description_Object> getAPIList() {
        return this.apiList;
    }

    public void addAPIObject(API_Description_Object apiObject) {
        if (this.apiList == null) {
            this.apiList = new ArrayList<API_Description_Object>();
        }
        this.apiList.add(apiObject);
    }

    @Override
    protected Response<Status, String> setValuesWithOwnParser(Response responseObject, String body) {
        QueryInfoResponse rueckgabe = (QueryInfoResponse)responseObject;
        rueckgabe.clearAPIList();
        try {
            JsonFactory jfactory = new JsonFactory();
            JsonParser jParser = jfactory.createParser(body);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = (JsonNode)mapper.readTree(jParser);
            Iterator rootIt = rootNode.fields();
            Map.Entry dataMap = (Map.Entry)rootIt.next();
            JsonNode dataNode = (JsonNode)dataMap.getValue();
            Iterator iterator = dataNode.fields();
            List<API_Description_Object> objectList = API_Description_Object.getAPIList();
            while (iterator.hasNext()) {
                Map.Entry objectField = (Map.Entry)iterator.next();
                API_Description_Object apiDescription = null;
                if (!((String)objectField.getKey()).startsWith("SYNO")) continue;
                JsonNode objectNode = (JsonNode)objectField.getValue();
                int i = 0;
                while (i < objectList.size()) {
                    if (objectList.get(i).getAPIName().equalsIgnoreCase((String)objectField.getKey())) {
                        apiDescription = objectList.get(i);
                        break;
                    }
                    ++i;
                }
                Iterator obIt = objectNode.fields();
                if (apiDescription != null) {
                    while (obIt.hasNext()) {
                        Map.Entry mapIt = (Map.Entry)obIt.next();
                        if (((String)mapIt.getKey()).equals("path")) {
                            apiDescription.setAPIEntry(((JsonNode)mapIt.getValue()).textValue());
                            continue;
                        }
                        if (((String)mapIt.getKey()).equals("minVersion")) {
                            apiDescription.setMinVersion(((JsonNode)mapIt.getValue()).intValue());
                            continue;
                        }
                        if (!((String)mapIt.getKey()).equals("maxVersion")) continue;
                        apiDescription.setMaxVersion(((JsonNode)mapIt.getValue()).intValue());
                    }
                }
                if (apiDescription == null) continue;
                rueckgabe.addAPIObject(apiDescription);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rueckgabe;
    }
}

