/*
 * Decompiled with CFR 0.152.
 */
package response.statuscode.api.auth;

import java.util.Arrays;
import java.util.List;

public enum StatusAuth {
    STATUS_200(200, "ok"),
    ERROR_100(100, "Unknown error"),
    ERROR_101(101, "The account parameter is not specified."),
    ERROR_400(400, "Invalid password."),
    ERROR_401(401, "Guest or disabled account."),
    ERROR_402(402, "Permission denied."),
    ERROR_403(403, "One time password not specified."),
    ERROR_404(404, "One time password authenticate failed."),
    ERROR_405(405, "App portal incorrect."),
    ERROR_406(406, "OTP code enforced."),
    ERROR_407(407, "Max Tries (if auto blocking is set to true).");

    private String description;
    private int statusCode;

    private StatusAuth(int statusCode, String description) {
        this.statusCode = statusCode;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private boolean isStatusCode(int statusFromResponse) {
        return statusFromResponse == this.statusCode;
    }

    public static StatusAuth getErrorCode(int statusFromResponse) {
        List<StatusAuth> list = Arrays.asList(StatusAuth.values());
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).isStatusCode(statusFromResponse)) {
                return list.get(i);
            }
            ++i;
        }
        return STATUS_200;
    }
}

