/*
 * Decompiled with CFR 0.152.
 */
package response.statuscode;

import java.util.Arrays;
import java.util.List;

public enum Status {
    STATUS_200(200, "ok"),
    ERROR_100(100, "Unknown error"),
    ERROR_101(101, "Invalid Parameters"),
    ERROR_102(102, "API does not exist"),
    ERROR_103(103, "Method does not exist"),
    ERROR_104(104, "This API version is not supported"),
    ERROR_105(105, "Insufficient user privilege"),
    ERROR_106(106, "Connection time out"),
    ERROR_107(107, "Multiple login detected");

    private String description;
    private int statusCode;

    private Status(int statusCode, String description) {
        this.statusCode = statusCode;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private boolean isStatusCode(int statusFromResponse) {
        return statusFromResponse == this.statusCode;
    }

    public static Status getErrorCode(int statusFromResponse) {
        List<Status> list = Arrays.asList(Status.values());
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).isStatusCode(statusFromResponse)) {
                return list.get(i);
            }
            ++i;
        }
        return STATUS_200;
    }
}

