/*
 * Decompiled with CFR 0.152.
 */
package connect.mjpeg.test.dritterVersuch;

import connect.interfaces.IMotionThread;
import connect.mjpeg.test.dritterVersuch.MJPEGStream3;
import connect.mjpeg.test.dritterVersuch.Verarbeitung;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import request.syno.helper.CAMERA_ID;

public class MJPEGThread3
extends Thread
implements IMotionThread {
    private MJPEGStream3 meg = null;
    private CAMERA_ID cameraID;
    private static final int HEADER_MAX_LENGTH = 100;
    private static final int FRAME_MAX_LENGTH = 100050;
    private boolean running = false;
    private DataInputStream inputStream;
    private String boundary;
    private final String CONTENT_LENGTH = "Content-Length".toLowerCase();
    private final byte[] EOI_MARKER = new byte[]{-1, -39};
    private final byte[] SOI_MARKER = new byte[]{-1, -40};
    private Verarbeitung verarbeitung;

    public MJPEGThread3(InputStream in, CAMERA_ID cameraID, String boundary) {
        this.verarbeitung = new Verarbeitung(boundary, cameraID);
        this.verarbeitung.start();
        this.inputStream = new DataInputStream(new BufferedInputStream(in, 100050));
        this.boundary = boundary;
        this.cameraID = cameraID;
        this.running = true;
    }

    @Override
    public void run() {
        boolean s = false;
        boolean i = false;
        int zaehler = 1;
        Object header = null;
        Object frame = null;
        ArrayList tempByteList = new ArrayList();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Object byteBuffer = null;
        while (this.running) {
            try {
                byte unsigneByte = (byte)this.inputStream.readUnsignedByte();
                baos.write(unsigneByte);
                if (baos.size() == 10000) {
                    baos.flush();
                    this.verarbeitung.append(ArrayUtils.toObject((byte[])baos.toByteArray()));
                    baos.reset();
                }
                ++zaehler;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void stopThread() {
        this.running = false;
    }

    private int parseContentLength(byte[] headerBytes) throws IOException, NumberFormatException {
        System.out.println("headerBytes laenge " + headerBytes.length);
        ByteArrayInputStream bais = new ByteArrayInputStream(headerBytes);
        InputStreamReader isr = new InputStreamReader(bais);
        BufferedReader br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] parts;
            if (!line.toLowerCase().startsWith(this.CONTENT_LENGTH) || (parts = line.split(":")).length != 2) continue;
            int valueToReturn = Integer.parseInt(parts[1].trim());
            return valueToReturn;
        }
        return 0;
    }
}

