/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import com.wibu.xpm.Janitor;
import com.wibu.xpm.Logger;
import com.wibu.xpm.MessageHandler;
import com.wibu.xpm.Runtime;
import com.wibu.xpm.Starter;
import com.wibu.xpm.Version;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ToolsSysCl
extends ClassLoader
implements Runnable {
    static final int major = 10;
    static final int minor = 0;
    static final int build = 2560;
    static final int release = 500;
    static final int year = 2017;
    static final int month = 2;
    static final int day = 23;
    protected Version mVersion = new Version(10, 0, 2560, 500, 2017, 2, 23);
    protected Runtime mRuntime = null;
    protected boolean mfInitialized = false;
    protected boolean mfRuntimeCheckFailed = false;
    protected Logger mLogger = null;
    protected Thread mthrSecurity = null;

    public ToolsSysCl(ClassLoader parent) {
        super(parent);
    }

    private void init() {
        if (!this.mfInitialized) {
            this.mthrSecurity = new Thread(this);
            try {
                Starter starter = Starter.getInstance();
                starter.setVerbose(false, null);
                MessageHandler msghandler = starter.createMessageHandler();
                Runtime.init(msghandler);
                msghandler.messageStart();
                starter.openClassLoader(false);
                this.mfInitialized = true;
            }
            catch (Exception ex) {
                this.mLogger.error(ex.getMessage());
                ex.printStackTrace();
            }
            this.mRuntime = Runtime.getInstance();
            Janitor.addShutdownHook(this.mRuntime);
            this.mLogger.fine("ToolsSysCl initialized.");
        }
    }

    @Override
    public void run() {
        int nSecondsToLoop = 4;
        block6: while (true) {
            try {
                while (true) {
                    Thread.sleep((long)nSecondsToLoop * 1000L);
                    this.mLogger.debug("Executing Runtime Check");
                    int nResult = this.mRuntime.runtimeCheck();
                    this.mLogger.debug("Runtime Check returned " + Integer.toString(nResult));
                    switch (nResult) {
                        case 0: {
                            nSecondsToLoop = 5;
                            continue block6;
                        }
                        case -1: {
                            this.mLogger.error("Runtime check failed!");
                            this.mfRuntimeCheckFailed = true;
                            System.exit(0);
                            continue block6;
                        }
                    }
                    nSecondsToLoop = Math.abs(nResult);
                }
            }
            catch (Exception ex) {
                this.mLogger.debug("Exception in Security Thread: " + ex.getLocalizedMessage());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        ToolsSysCl toolsSysCl = this;
        synchronized (toolsSysCl) {
            if (null == this.mLogger) {
                this.mLogger = Logger.getLogger(true);
                this.init();
            } else if (!this.mthrSecurity.isAlive()) {
                this.mthrSecurity.start();
            }
        }
        if (this.mfInitialized) {
            this.mLogger.trace("ToolsSysCl.loadClass(" + name + ")");
        }
        if ((clazz = super.findLoadedClass(name)) != null) {
            if (this.mfInitialized) {
                this.mLogger.info("Found already loaded class " + name);
            }
            return clazz;
        }
        clazz = super.loadClass(name, resolve);
        if (this.mfInitialized) {
            this.mLogger.fine("System loaded " + name);
        }
        return clazz;
    }

    protected void addPackage(String strClassName, URL url) {
        int i = strClassName.lastIndexOf(46);
        if (i != -1) {
            String strPkgName = strClassName.substring(0, i);
            String specTitle = null;
            String specVersion = null;
            String specVendor = null;
            String implTitle = null;
            String implVersion = null;
            String implVendor = null;
            URL sealBase = null;
            Package pkg = this.getPackage(strPkgName);
            if (null != pkg) {
                return;
            }
            try {
                Attributes mainAttributes;
                JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                Manifest manifest = jarConnection.getManifest();
                if (null != manifest && null != (mainAttributes = manifest.getMainAttributes())) {
                    specTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
                    specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                    specVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
                    implTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                    implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                    implVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.definePackage(strPkgName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        }
    }

    public String toString() {
        return "com.wibu.xpm.ToolsSysCl " + this.mVersion.toString();
    }
}

