/*
 * Decompiled with CFR 0.152.
 */
package com.wibu.xpm;

import com.wibu.xpm.Runtime;

public class Janitor
extends Thread {
    private Runtime mruntime;
    private static Janitor mpInstance = null;

    private Janitor(Runtime runtime) {
        this.mruntime = runtime;
    }

    private static synchronized Janitor getInstance(Runtime runtime) {
        if (mpInstance == null) {
            mpInstance = new Janitor(runtime);
            mpInstance.addShutdownHook();
        }
        return mpInstance;
    }

    @Override
    public void run() {
        mpInstance.removeShutdownHook();
        if (null != this.mruntime) {
            this.mruntime.cleanUp();
        }
        mpInstance = null;
    }

    public static Janitor addShutdownHook(Runtime runtime) {
        return Janitor.getInstance(runtime);
    }

    private void addShutdownHook() {
        java.lang.Runtime.getRuntime().addShutdownHook(this);
    }

    private void removeShutdownHook() {
        if (mpInstance != null) {
            try {
                java.lang.Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

