/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.sn.cc.vid.schemes;

import de.bscgmbh.sn.cc.vid.IVIDScheme;
import de.bscgmbh.sn.cc.vid.VID;

public class Type0
implements IVIDScheme {
    public static final int SCHEME_ID = 0;
    public static final String CREDENTIAL_SEPERATOR = "@";
    public static final String PASSWORD_SEPERATOR = ":";
    private int serviceID = -1;
    private String smartNodeID = null;
    private String user = null;
    private String password = null;

    public Type0() {
    }

    public Type0(String vID) {
        if (VID.parseSchemeID(vID) != 0) {
            throw new IllegalArgumentException("unsupported scheme id for " + this.getClass().getName());
        }
        this.parseVID(vID);
    }

    @Override
    public boolean parseVID(String vID) {
        String[] data = vID.split("#", 3);
        if (data.length == 3) {
            try {
                this.serviceID = Integer.parseInt(data[1]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return this.parseSmartNodeID(data[2]);
        }
        return false;
    }

    protected boolean parseSmartNodeID(String smartNodeID) {
        if (smartNodeID == null || smartNodeID.isEmpty()) {
            return false;
        }
        if (smartNodeID.contains(CREDENTIAL_SEPERATOR)) {
            String[] data = smartNodeID.split(CREDENTIAL_SEPERATOR, 2);
            String credentials = data[0];
            this.smartNodeID = data[1];
            if (credentials.contains(PASSWORD_SEPERATOR)) {
                String[] credentialData = credentials.split(PASSWORD_SEPERATOR, 2);
                this.password = credentialData[1];
                this.user = credentialData[0].charAt(1) == VID.SEPERATOR_CHAR && credentialData[0].charAt(3) == VID.SEPERATOR_CHAR ? credentialData[0].replaceFirst(".{1}#.{1}#", "") : credentialData[0];
            } else {
                this.user = credentials;
            }
        } else {
            this.smartNodeID = smartNodeID;
        }
        return true;
    }

    public int getServiceID() {
        return this.serviceID;
    }

    public void setServiceID(int serviceID) {
        this.serviceID = serviceID;
    }

    public String getSmartNodeID() {
        return this.smartNodeID;
    }

    public void setSmartNodeID(String smartNodeID) {
        this.smartNodeID = smartNodeID;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(0);
        sb.append("#");
        sb.append(this.serviceID);
        sb.append("#");
        if (this.user != null) {
            sb.append(this.user);
            if (this.password != null) {
                sb.append(PASSWORD_SEPERATOR);
                sb.append(this.password);
            }
            sb.append(CREDENTIAL_SEPERATOR);
        }
        sb.append(this.smartNodeID);
        return sb.toString();
    }

    @Override
    public int getSchemeID() {
        return 0;
    }
}

