/*
 * Decompiled with CFR 0.152.
 */
package de.bscgmbh.tools.pdfcreator.attachment.text;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.bscgmbh.tools.pdfcreator.attachment.misc.RGBColor;
import java.beans.Transient;

public class TextLine {
    protected String text = null;
    protected RGBColor color = null;
    protected boolean bold = false;

    protected TextLine() {
    }

    public TextLine(String text) {
        this.text = text;
    }

    public TextLine(String text, RGBColor color, boolean bold) {
        this.text = text;
        this.color = color;
        this.bold = bold;
    }

    public String getText() {
        if (this.text == null) {
            this.text = "";
        }
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Transient
    public RGBColor getColorOrDefault() {
        return this.color == null ? RGBColor.createBlackColor() : this.color;
    }

    public RGBColor getColor() {
        return this.color;
    }

    public void setColor(RGBColor color) {
        this.color = color;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public String toString() {
        return "TextLine [text=" + this.text + ", color=" + this.color + ", bold=" + this.bold + "]";
    }
}

