/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.security;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHKey {
    private static Logger logger = LoggerFactory.getLogger(DHKey.class);
    private static final int ITERATIONS = 1000;
    private static BigInteger p2048 = new BigInteger("87A8E61DB4B6663CFFBBD19C651959998CEEF608660DD0F25D2CEED4435E3B00E00DF8F1D61957D4FAF7DF4561B2AA3016C3D91134096FAA3BF4296D830E9A7C209E0C6497517ABD5A8A9D306BCF67ED91F9E6725B4758C022E0B1EF4275BF7B6C5BFC11D45F9088B941F54EB1E59BB8BC39A0BF12307F5C4FDB70C581B23F76B63ACAE1CAA6B7902D52526735488A0EF13C6D9A51BFA4AB3AD8347796524D8EF6A167B5A41825D967E144E5140564251CCACB83E6B486F6B3CA3F7971506026C0B857F689962856DED4010ABD0BE621C3A3960A54E710C375F26375D7014103A4B54330C198AF126116D2276E11715F693877FAD7EF09CADB094AE91E1A1597", 16);
    private static BigInteger g2048 = new BigInteger("3FB32C9B73134D0B2E77506660EDBD484CA7B18F21EF205407F4793A1A0BA12510DBC15077BE463FFF4FED4AAC0BB555BE3A6C1B0C6B47B1BC3773BF7E8C6F62901228F8C28CBB18A55AE31341000A650196F931C77A57F2DDF463E5E9EC144B777DE62AAAB8A8628AC376D282D6ED3864E67982428EBC831D14348F6F2F9193B5045AF2767164E1DFC967C1FB3F2E55A4BD1BFFE83B9C80D052B985D182EA0ADB2A3B7313D3FE14C8484B1E052588B9B7D2BBD2DF016199ECD06E1557CD0915B3353BBB64E0EC377FD028370DF92B52C7891428CDC67EB6184B523D1DB246C32F63078490F00EF8D647D148D47954515E2327CFEF98C582664B4C0F6CC41659", 16);
    private static BigInteger p1024 = new BigInteger("B10B8F96A080E01DDE92DE5EAE5D54EC52C99FBCFB06A3C69A6A9DCA52D23B616073E28675A23D189838EF1E2EE652C013ECB4AEA906112324975C3CD49B83BFACCBDD7D90C4BD7098488E9C219A73724EFFD6FAE5644738FAA31A4FF55BCCC0A151AF5F0DC8B4BD45BF37DF365C1A65E68CFDA76D4DA708DF1FB2BC2E4A4371", 16);
    private static BigInteger g1024 = new BigInteger("A4D1CBD5C3FD34126765A442EFB99905F8104DD258AC507FD6406CFF14266D31266FEA1E5C41564B777E690F5504F213160217B4B01B886A5E91547F9E2749F4D7FBD7D3B9A92EE1909D0D2263F80A76A6A24C087A091F531DBF0A0169B6A28AD662A4D18E73AFA32D779D5918D08BC8858F4DCEF97C2A24855E6EEB22B3B2E5", 16);
    private static BigInteger minimumRandom = new BigInteger("8000000000000000000000000000000000000000", 16);
    private static BigInteger maximumRandom1024 = p1024.subtract(BigInteger.valueOf(2L));
    private static BigInteger maximumRandom2048 = p2048.subtract(BigInteger.valueOf(2L));

    private static BigInteger genertateRandom(BigInteger min, BigInteger max, SecureRandom random) {
        int comparison = min.compareTo(max);
        if (comparison >= 0) {
            if (comparison > 0) {
                throw new IllegalArgumentException("min must not be greater than max");
            }
            return min;
        }
        if (min.bitLength() > max.bitLength() / 2) {
            return DHKey.genertateRandom(BigInteger.valueOf(0L), max.subtract(min), random).add(min);
        }
        for (int i = 0; i < 1000; ++i) {
            BigInteger x = new BigInteger(max.bitLength(), random);
            if (x.compareTo(min) < 0 || x.compareTo(max) > 0) continue;
            return x;
        }
        return new BigInteger(max.subtract(min).bitLength() - 1, random).add(min);
    }

    public static BigInteger genertateRandom(SecureRandom random, BitSize bitSize) {
        BigInteger maximumRandom = bitSize == BitSize.SIZE_1024 ? maximumRandom1024 : maximumRandom2048;
        BigInteger x = DHKey.genertateRandom(minimumRandom, maximumRandom, random);
        return x;
    }

    public static BigInteger genertatePublic(BigInteger secretValue, BitSize bitSize) {
        BigInteger p = bitSize == BitSize.SIZE_1024 ? p1024 : p2048;
        BigInteger g = bitSize == BitSize.SIZE_1024 ? g1024 : g2048;
        BigInteger x = g.modPow(secretValue, p);
        return x;
    }

    public static BigInteger genertateShared(BigInteger publicValue, BigInteger secretValue, BitSize bitSize) {
        BigInteger p = bitSize == BitSize.SIZE_1024 ? p1024 : p2048;
        BigInteger x = publicValue.modPow(secretValue, p);
        return x;
    }

    public static enum BitSize {
        SIZE_1024,
        SIZE_2048;

    }
}

