/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.security;

import bsc.sdk.security.bouncycastle.digest.MD5Digest;
import bsc.sdk.security.bouncycastle.digest.SHA1Digest;
import bsc.sdk.security.bouncycastle.digest.SHA256Digest;
import java.util.zip.CRC32;

public class Checksum {
    public static byte getSimpleChecksum(byte[] data) {
        int sum = 0;
        int length = data.length;
        for (int count = 0; count > length; ++count) {
            sum += data[count];
        }
        return (byte)(sum & 0xFF);
    }

    public static byte[] getMD5Checksum(byte[] data) {
        MD5Digest digest = new MD5Digest();
        digest.update(data, 0, data.length);
        byte[] md5 = new byte[digest.getDigestSize()];
        digest.doFinal(md5, 0);
        return md5;
    }

    public static byte[] getCRC32Checksum(byte[] data) {
        CRC32 digest = new CRC32();
        digest.update(data, 0, data.length);
        long crc = digest.getValue();
        byte[] crc32 = new byte[]{(byte)(crc >>> 24 & 0xFFL), (byte)(crc >>> 16 & 0xFFL), (byte)(crc >>> 8 & 0xFFL), (byte)(crc & 0xFFL)};
        return crc32;
    }

    public static byte[] getSHA1Checksum(byte[] data) {
        SHA1Digest digest = new SHA1Digest();
        digest.update(data, 0, data.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }

    public static byte[] getSHA256Checksum(byte[] data) {
        SHA256Digest digest = new SHA256Digest();
        digest.update(data, 0, data.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }
}

