/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.net.sockets;

import bsc.sdk.io.Base64;
import bsc.sdk.net.ISocket;
import bsc.sdk.security.Checksum;
import bsc.sdk.tools.Tools;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocket
implements ISocket {
    private static Logger logger = LoggerFactory.getLogger(WebSocket.class);
    protected boolean fRequireMask = false;
    protected boolean fMasking = false;
    protected boolean fClosedByMe = false;
    protected boolean fClosedByPeer = false;
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private WebSocketInputStream webSocketInputStream;
    private WebSocketOutputStream webSocketOutputStream;
    private WebSocketParameter parameter;
    private boolean closed;

    public static WebSocket createWebSocket(Socket socket, InputStream inputStream, OutputStream outputStream, String protocol) throws IOException, SocketException {
        if (!inputStream.markSupported()) {
            throw new IOException("Inputstream is not markable. Unable to check for type websocket without consuming data from inputstream.");
        }
        inputStream.mark(4096);
        WebSocketParameter parameter = null;
        try {
            parameter = WebSocket.getParameter(inputStream, outputStream, protocol);
        }
        catch (IOException e) {
            inputStream.reset();
            throw e;
        }
        WebSocket webSocket = new WebSocket(socket, inputStream, outputStream, parameter);
        return webSocket;
    }

    private static WebSocketParameter getParameter(InputStream inputStream, OutputStream outputStream, String desiredProtocol) throws IOException {
        byte[] tmpB;
        BufferedReader sr = new BufferedReader(new InputStreamReader(inputStream));
        PrintWriter sw = new PrintWriter(outputStream);
        String line = "";
        String get = "";
        String cookie = "-";
        String extension = "-";
        String origin = "-";
        String protocol = "-";
        String host = "";
        String port = "";
        String resourceName = "";
        String version = "";
        String separator = ":";
        String separator2 = " ";
        boolean doCreate = true;
        String key = "";
        int resultHTTP = 101;
        HashMap<String, String> headers = new HashMap<String, String>();
        WebSocketParameter webSocketParameter = new WebSocketParameter();
        try {
            String tmpS;
            String[] parts;
            char[] start = new char[3];
            sr.read(start);
            get = String.valueOf(start);
            if (get.equals("GET")) {
                get = get + sr.readLine();
            }
            if (get != null) {
                parts = get.split(separator2);
                if (get.toUpperCase().indexOf("GET ") > -1 && get.toUpperCase().indexOf(" HTTP/1.1") > -1 && parts.length >= 3) {
                    parts = get.split(separator2, 2);
                    resourceName = parts[1].trim();
                    parts = resourceName.split(separator2, 2);
                    resourceName = parts[0].trim();
                }
            }
            boolean bl = doCreate = resourceName != "";
            if (doCreate) {
                do {
                    if ((line = sr.readLine()) == null || line.equals("")) continue;
                    parts = line.split(separator, 2);
                    headers.put(parts[0].toLowerCase(), parts.length == 2 ? parts[1] : "");
                } while (line != null && !line.equals(""));
                if (line == null) {
                    doCreate = false;
                }
            }
            if (doCreate) {
                if (headers.containsKey("host")) {
                    parts = ((String)headers.get("host")).split(separator);
                    host = parts[0].trim();
                    if (parts.length > 1) {
                        port = parts[1].trim();
                    }
                }
                boolean bl2 = doCreate = doCreate && host != "";
            }
            if (doCreate) {
                if (headers.containsKey("sec-websocket-key")) {
                    tmpS = ((String)headers.get("sec-websocket-key")).trim();
                    tmpB = Base64.decodeBase64(tmpS);
                    if ((tmpS = new String(tmpB, "ASCII")).length() == 16) {
                        key = ((String)headers.get("sec-websocket-key")).trim();
                    }
                }
                boolean bl3 = doCreate = doCreate && key != "";
            }
            if (doCreate) {
                int iTmpS;
                if (headers.containsKey("sec-websocket-version") && (iTmpS = Integer.parseInt(tmpS = ((String)headers.get("sec-websocket-version")).trim())) >= 7 && iTmpS <= 16) {
                    version = tmpS;
                }
                boolean bl4 = doCreate = doCreate && version != "";
            }
            if (doCreate) {
                boolean bl5 = doCreate = doCreate && headers.containsKey("upgrade") && ((String)headers.get("upgrade")).trim().toLowerCase().equals("websocket") && headers.containsKey("connection") && ((String)headers.get("connection")).trim().toLowerCase().indexOf("upgrade") > -1;
            }
            if (doCreate) {
                if (headers.containsKey("sec-websocket-origin")) {
                    origin = ((String)headers.get("sec-websocket-origin")).trim();
                }
                if (headers.containsKey("sec-websocket-protocol")) {
                    protocol = ((String)headers.get("sec-websocket-protocol")).trim();
                }
                if (headers.containsKey("sec-websocket-extensions")) {
                    extension = ((String)headers.get("sec-websocket-extensions")).trim();
                }
                if (headers.containsKey("cookie")) {
                    cookie = ((String)headers.get("cookie")).trim();
                }
            }
        }
        catch (SocketException e) {
            logger.error(e.getMessage(), (Throwable)e);
            doCreate = false;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            doCreate = false;
        }
        if (doCreate && resultHTTP != 101) {
            sw.print(MessageFormat.format("HTTP/1.1 {0} {1}\r\n", resultHTTP, WebSocket.httpCode(resultHTTP)));
            sw.print(MessageFormat.format("{0} {1}\r\n", resultHTTP, WebSocket.httpCode(resultHTTP)));
            sw.print("\r\n");
            sw.flush();
            doCreate = false;
        }
        if (!doCreate) {
            throw new SocketException("Not a websocket or wrong socket parameter");
        }
        webSocketParameter.fCookie = cookie;
        webSocketParameter.fExtension = extension;
        webSocketParameter.fOrigin = origin;
        webSocketParameter.fProtocol = Arrays.asList(protocol.trim().split(separator2));
        webSocketParameter.fHost = host;
        webSocketParameter.fResourceName = resourceName;
        if (desiredProtocol != null && !desiredProtocol.isEmpty()) {
            doCreate &= webSocketParameter.fProtocol.contains(desiredProtocol);
        }
        if (version != null && !version.isEmpty()) {
            webSocketParameter.fVersion = Integer.parseInt(version);
        }
        if (port != null && !port.isEmpty()) {
            webSocketParameter.fPort = Integer.parseInt(port);
        }
        webSocketParameter.fHeaders = headers;
        if (doCreate) {
            tmpB = (key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes("ASCII");
            key = Base64.encodeBase64String(Checksum.getSHA1Checksum(tmpB));
            sw.print("HTTP/1.1 101 Switching Protocols\r\n");
            sw.print("Upgrade: websocket\r\n");
            sw.print("Connection: Upgrade\r\n");
            sw.print(MessageFormat.format("Sec-WebSocket-Accept: {0}\r\n", key));
            if (protocol != "-") {
                sw.print(MessageFormat.format("Sec-WebSocket-Protocol: {0}\r\n", protocol));
            }
            sw.print("\r\n");
            sw.flush();
            return webSocketParameter;
        }
        throw new SocketException("Not a websocket or wrong socket parameter");
    }

    private static String httpCode(int code) {
        String result = "unknown code: " + code;
        switch (code) {
            case 100: {
                result = "Continue";
                break;
            }
            case 101: {
                result = "Switching Protocols";
                break;
            }
            case 200: {
                result = "OK";
                break;
            }
            case 201: {
                result = "Created";
                break;
            }
            case 202: {
                result = "Accepted";
                break;
            }
            case 203: {
                result = "Non-Authoritative Information";
                break;
            }
            case 204: {
                result = "No Content";
                break;
            }
            case 205: {
                result = "Reset Content";
                break;
            }
            case 206: {
                result = "Partial Content";
                break;
            }
            case 300: {
                result = "Multiple Choices";
                break;
            }
            case 301: {
                result = "Moved Permanently";
                break;
            }
            case 302: {
                result = "Found";
                break;
            }
            case 303: {
                result = "See Other";
                break;
            }
            case 304: {
                result = "Not Modified";
                break;
            }
            case 305: {
                result = "Use Proxy";
                break;
            }
            case 307: {
                result = "Temporary Redirect";
                break;
            }
            case 400: {
                result = "Bad Request";
                break;
            }
            case 401: {
                result = "Unauthorized";
                break;
            }
            case 402: {
                result = "Payment Required";
                break;
            }
            case 403: {
                result = "Forbidden";
                break;
            }
            case 404: {
                result = "Not Found";
                break;
            }
            case 405: {
                result = "Method Not Allowed";
                break;
            }
            case 406: {
                result = "Not Acceptable";
                break;
            }
            case 407: {
                result = "Proxy Authentication Required";
                break;
            }
            case 408: {
                result = "Request Time-out";
                break;
            }
            case 409: {
                result = "Conflict";
                break;
            }
            case 410: {
                result = "Gone";
                break;
            }
            case 411: {
                result = "Length Required";
                break;
            }
            case 412: {
                result = "Precondition Failed";
                break;
            }
            case 413: {
                result = "Request Entity Too Large";
                break;
            }
            case 414: {
                result = "Request-URI Too Large";
                break;
            }
            case 415: {
                result = "Unsupported Media Type";
                break;
            }
            case 416: {
                result = "Requested range not satisfiable";
                break;
            }
            case 417: {
                result = "Expectation Failed";
                break;
            }
            case 500: {
                result = "Internal Server Error";
                break;
            }
            case 501: {
                result = "Not Implemented";
                break;
            }
            case 502: {
                result = "Bad Gateway";
                break;
            }
            case 503: {
                result = "Service Unavailable";
                break;
            }
            case 504: {
                result = "Gateway Time-out";
            }
        }
        return result;
    }

    private WebSocket(Socket socket, InputStream inputStream, OutputStream outputStream, WebSocketParameter parameter) {
        this.socket = socket;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.parameter = parameter;
        this.webSocketInputStream = new WebSocketInputStream(this);
        this.webSocketOutputStream = new WebSocketOutputStream(this);
    }

    public int available() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        return this.inputStream.available();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.webSocketOutputStream;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.webSocketInputStream;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public int getPort() {
        return this.parameter.fPort;
    }

    @Override
    public void close() throws IOException {
        this.close(1001, "");
    }

    private void close(int code, String reason) throws IOException {
        if (this.closed) {
            return;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.fClosedByMe = true;
        if (!this.fClosedByPeer) {
            byte[] bytes = new byte[]{(byte)(code / 256), (byte)(code % 256)};
            bout.write(bytes, 0, 2);
            try {
                bytes = reason.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = reason.getBytes();
            }
            while (bytes.length > 123) {
                reason = reason.substring(0, reason.length() - 1);
                try {
                    bytes = reason.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    bytes = reason.getBytes();
                }
            }
            bout.write(bytes, 0, bytes.length);
            byte[] array = bout.toByteArray();
            this.writeFrame(8, array, array.length);
        }
        this.socket.close();
        this.closed = true;
    }

    private boolean ping(String data) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        pout.print(data);
        pout.flush();
        byte[] array = bout.toByteArray();
        return this.writeFrame(9, array, array.length);
    }

    private boolean pong(String data) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        pout.print(data);
        pout.flush();
        byte[] array = bout.toByteArray();
        return this.writeFrame(10, array, array.length);
    }

    private boolean sendBinary(byte[] data, int length) throws IOException {
        return this.writeFrame(2, data, length);
    }

    private boolean sendText(String data) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bout);
        pout.print(data);
        pout.flush();
        byte[] array = bout.toByteArray();
        return this.writeFrame(1, array, array.length);
    }

    private boolean writeFrame(int frameType, byte[] data, int length) throws IOException {
        boolean result;
        boolean bl = result = !this.closed && (frameType == 8 || !this.fClosedByMe);
        if (!result) {
            return result;
        }
        int bt = 0;
        long len = 0L;
        byte[] masks = new byte[4];
        Random rand = new Random();
        try {
            bt = 128;
            this.outputStream.write((byte)(bt += frameType));
            len = (this.fMasking ? 1 : 0) * 128;
            len = length < 126 ? (len += (long)length) : (length < 65536 ? (len += 126L) : (len += 127L));
            this.outputStream.write((byte)len);
            if (length >= 126) {
                byte[] bytes = length < 65536 ? Tools.getBytes((short)length) : Tools.getBytes((long)length);
                this.outputStream.write(bytes, 0, bytes.length);
            }
            if (this.fMasking) {
                masks[0] = (byte)rand.nextInt(256);
                masks[1] = (byte)rand.nextInt(256);
                masks[2] = (byte)rand.nextInt(256);
                masks[3] = (byte)rand.nextInt(256);
                this.outputStream.write(masks, 0, masks.length);
            }
            if (this.fMasking) {
                for (int i = 0; i < length; ++i) {
                    data[i] = (byte)(data[i] ^ masks[i % 4]);
                }
            }
            this.outputStream.write(data, 0, length);
            this.outputStream.flush();
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private Frame readFrame() throws IOException {
        if (this.closed) {
            return null;
        }
        Frame webSocketFrame = new Frame();
        boolean mask = false;
        byte[] masks = new byte[4];
        int value = this.inputStream.read();
        webSocketFrame.isFinal = (value & 0x80) == 128;
        webSocketFrame.res1 = (value & 0x40) == 64;
        webSocketFrame.res2 = (value & 0x20) == 32;
        webSocketFrame.res3 = (value & 0x10) == 16;
        webSocketFrame.type = value & 0xF;
        value = this.inputStream.read();
        mask = (value & 0x80) == 128;
        long length = value & 0x7F;
        if (length == 126L) {
            value = this.inputStream.read();
            length = value * 256;
            value = this.inputStream.read();
            length += (long)value;
        } else if (length == 127L) {
            long multiplier = 0x100000000000000L;
            length = 0L;
            for (int i = 0; i < 8; ++i) {
                value = this.inputStream.read();
                length += (long)value * (multiplier >= 256L ? multiplier : 1L);
                multiplier /= 256L;
            }
        }
        if (this.fRequireMask && !mask) {
            this.close(1002, "");
            throw new IOException("Protocol error");
        }
        if (mask) {
            this.inputStream.read(masks);
        }
        byte[] buffer = new byte[(int)length];
        int offset = 0;
        int oldTimeout = this.socket.getSoTimeout();
        this.socket.setSoTimeout(0x6DDD00);
        while (length > 0L) {
            int read = this.inputStream.read(buffer, offset, (int)Math.min(length, Integer.MAX_VALUE));
            offset += read;
            length -= (long)read;
        }
        this.socket.setSoTimeout(oldTimeout);
        if (mask) {
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = (byte)(buffer[i] ^ masks[i % 4]);
            }
        }
        Frame.access$102(webSocketFrame, buffer);
        return webSocketFrame;
    }

    private static final class FrameType {
        private static final int Continuation = 0;
        private static final int Text = 1;
        private static final int Binary = 2;
        private static final int Close = 8;
        private static final int Ping = 9;
        private static final int Pong = 10;

        private FrameType() {
        }
    }

    private static final class CloseCode {
        private static final int Normal = 1000;
        private static final int Shutdown = 1001;
        private static final int ProtocolError = 1002;
        private static final int DataError = 1003;
        private static final int FrameTooLarge = 1004;
        private static final int NoStatus = 1005;
        private static final int CloseError = 1006;
        private static final int UTF8Error = 1007;

        private CloseCode() {
        }
    }

    private static final class Frame {
        private boolean res1;
        private boolean res2;
        private boolean res3;
        private boolean isFinal;
        private byte[] data;
        private int type;

        private Frame() {
        }

        static /* synthetic */ byte[] access$102(Frame x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }

    private static final class WebSocketOutputStream
    extends OutputStream {
        private static final int BUFFERSIZE = 65535;
        private WebSocket webSocket;
        private byte[] buffer;
        private int bufferPosition;
        private boolean closed;

        private WebSocketOutputStream(WebSocket webSocket) {
            this.webSocket = webSocket;
            this.buffer = new byte[65535];
            this.bufferPosition = 0;
            this.closed = false;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new IllegalArgumentException("Buffer is null");
            }
            if (off + len > b.length) {
                throw new IllegalArgumentException("The sum of offset and length is greater then the size of the buffer");
            }
            if (off < 0 || len < 0) {
                throw new IllegalArgumentException("Offset or length are negative");
            }
            if (len == 0) {
                return;
            }
            while (this.bufferPosition >= this.buffer.length || this.buffer.length - this.bufferPosition <= len) {
                this.growBuffer();
            }
            System.arraycopy(b, off, this.buffer, this.bufferPosition, len);
            this.bufferPosition += len;
        }

        private void growBuffer() {
            byte[] newBuffer = new byte[this.buffer.length + 65535];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (this.closed) {
                throw new SocketException("Stream closed");
            }
            if (this.bufferPosition >= this.buffer.length) {
                this.growBuffer();
            }
            this.buffer[this.bufferPosition++] = (byte)b;
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.bufferPosition <= 0) {
                return;
            }
            this.webSocket.sendBinary(this.buffer, this.bufferPosition);
            this.buffer = new byte[65535];
            this.bufferPosition = 0;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.webSocket.outputStream.close();
        }
    }

    private static final class WebSocketInputStream
    extends InputStream {
        private WebSocket webSocket;
        private byte[] data;
        private int dataPosition;
        private boolean closed;

        private WebSocketInputStream(WebSocket webSocket) {
            this.webSocket = webSocket;
            this.data = new byte[0];
            this.dataPosition = 0;
            this.closed = false;
        }

        @Override
        public synchronized int read(byte[] data) throws IOException {
            return this.read(data, 0, data.length);
        }

        @Override
        public synchronized int read(byte[] data, int offset, int length) throws IOException {
            if (data == null) {
                throw new NullPointerException("byte[] b must not be null");
            }
            if (data.length < offset + length) {
                throw new InvalidParameterException("byte[] b is too small");
            }
            int bytesRead = 0;
            for (int i = 0; i < length; ++i) {
                if (this.data.length == 0 || this.dataPosition < this.data.length) {
                    try {
                        int value = this.read();
                        if (value == -1) {
                            if (i != 0) break;
                            bytesRead = value;
                            break;
                        }
                        data[offset + i] = (byte)value;
                        ++bytesRead;
                        continue;
                    }
                    catch (SocketTimeoutException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                this.data = new byte[0];
                break;
            }
            return bytesRead;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.closed) {
                throw new SocketException("Stream closed");
            }
            while (this.data.length == 0 || this.dataPosition >= this.data.length) {
                Frame frame = this.webSocket.readFrame();
                this.data = frame.data;
                this.dataPosition = 0;
                if (frame.type == 8) {
                    this.closed = true;
                    throw new SocketException("Socket closed");
                }
                while (!frame.isFinal) {
                    Frame nextFrame = this.webSocket.readFrame();
                    byte[] newData = new byte[this.data.length + nextFrame.data.length];
                    System.arraycopy(this.data, 0, newData, 0, this.data.length);
                    System.arraycopy(nextFrame.data, 0, newData, this.data.length, nextFrame.data.length);
                }
            }
            int value = this.data[this.dataPosition++] & 0xFF;
            return value;
        }

        @Override
        public void close() throws IOException {
            System.out.println("Closing WebSocket input stream");
            this.closed = true;
            this.webSocket.inputStream.close();
            System.out.println("WebSocket input stream closed");
        }

        @Override
        public int available() throws IOException {
            return this.webSocket.available();
        }
    }

    private static final class WebSocketParameter {
        private String fCookie;
        private String fExtension;
        private String fOrigin;
        private List<String> fProtocol;
        private String fHost;
        private int fPort;
        private String fResourceName;
        private int fVersion;
        private HashMap<String, String> fHeaders;

        private WebSocketParameter() {
        }
    }
}

