/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.net.sockets;

import bsc.sdk.net.ISocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class MobileSocket
implements ISocket {
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;

    public MobileSocket(Socket socket, InputStream inputStream, OutputStream outputStream) {
        if (socket == null) {
            throw new IllegalArgumentException("Socket is null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream is null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("OutputStream is null");
        }
        this.socket = socket;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        return this.socket.getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        return this.socket.getInputStream();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }
}

