/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver.state.server;

import bsc.api.transport.TransmissionObject;
import bsc.api.transport.commands.DisconnectCommand;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverState;
import bsc.sdk.kernel.transceiver.ChannelWorker;
import bsc.sdk.kernel.transceiver.ITransceiverState;
import bsc.sdk.kernel.transceiver.state.AStateExit;
import bsc.sdk.kernel.transceiver.state.StateConfiguration;
import bsc.sdk.kernel.transceiver.state.StateFactory;

public class StateDisconnect
extends AStateExit {
    private Stage currentStage = Stage.WAITING_FOR_ACKNOWLEDGE;

    public StateDisconnect(StateConfiguration stateSettings) {
        super(stateSettings);
        this.connector.transceiverStateChanged(TransceiverState.STATE.DISCONNECT, null);
    }

    @Override
    public int getLevel() {
        return 4;
    }

    @Override
    public ITransceiverState execute() {
        this.connector.getTransceiver().write(new TransmissionObject(this.getNewTransmissionId(), new DisconnectCommand()), false, new ChannelWorker.WriteMode[0]);
        return StateFactory.getDefaultFactory().createState(new StateConfiguration(StateFactory.TYPE.SERVER, StateFactory.STATE.TERMINATE, this.connector));
    }

    @Override
    public ITransceiverState error(TransceiverException exception) {
        return null;
    }

    @Override
    public ITransceiverState disconnect(boolean terminate) {
        return this;
    }

    private static enum Stage {
        WAITING_FOR_ACKNOWLEDGE,
        EXITING,
        DONE;

    }
}

