/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver.state;

import bsc.api.transport.model.Caps;
import bsc.sdk.kernel.bus.messages.api.AddMetaInformations;
import bsc.sdk.kernel.transceiver.state.ATransceiverState;
import bsc.sdk.kernel.transceiver.state.StateConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AStateInit
extends ATransceiverState {
    private Map<String, String> capsMetaData;

    public AStateInit(StateConfiguration stateSettings) {
        super(stateSettings);
        this.capsMetaData = stateSettings.getMetaInformations();
    }

    protected Caps getCaps() {
        Caps c = new Caps();
        c.setProtocols(this.connector.getApplicationSettings().getProtocols());
        c.setEncryptions(this.connector.getApplicationSettings().getEncryptions());
        c.setCompressions(this.connector.getApplicationSettings().getCompressions());
        c.setApiVersions(this.connector.getApplicationSettings().getApiVersions());
        c.setApiExtensions(this.getExtensionList());
        this.connector.fireMessage(new AddMetaInformations(c));
        return c;
    }

    private List<String> getExtensionList() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.connector.getApiExtensionSet());
        return result;
    }

    public Map<String, String> getCapsMetaData() {
        return this.capsMetaData;
    }

    protected void setCapsMetaData(Map<String, String> metaData) {
        this.capsMetaData = metaData;
    }
}

