/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver;

import bsc.api.Enumerations;
import bsc.api.transport.TransmissionObject;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.protocol.ProtocolFactory;
import bsc.sdk.kernel.modules.io.IConnectionAdapter;
import bsc.sdk.kernel.transceiver.AChannelHandler;
import bsc.sdk.kernel.transceiver.ATransceiver;
import bsc.sdk.kernel.transceiver.ChannelWorker;
import bsc.sdk.net.ISocket;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelHandlerSync
extends AChannelHandler {
    private static Logger logger = LoggerFactory.getLogger(ChannelHandlerSync.class);
    private OutputStream channelOut;
    private InputStream channelIn;
    private ISocket channel;
    private Object writeLock = new Object();

    public ChannelHandlerSync(ISocket channel, IConnectionAdapter connector) {
        super(connector);
        this.protocol = ProtocolFactory.newInstance(Enumerations.ProtocolType.JSON);
        this.channel = channel;
        try {
            this.channelOut = channel.getOutputStream();
            this.channelIn = channel.getInputStream();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public void closeChannel() {
        try {
            this.channel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.channelOut.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.channelIn.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(TransmissionObject transmission, ChannelWorker.WriteMode ... writeModes) {
        Object object = this.writeLock;
        synchronized (object) {
            AChannelHandler.TransmissionContainer container = new AChannelHandler.TransmissionContainer();
            container.transmissionObject = transmission;
            if (writeModes.length == 0) {
                ArrayList<ChannelWorker.WriteMode> allModes = new ArrayList<ChannelWorker.WriteMode>();
                if (this.protocolType != null) {
                    allModes.add(ChannelWorker.WriteMode.PROTOCOL);
                }
                if (this.encryptionType != Enumerations.EncryptionType.NONE && this.encryptionType != null) {
                    allModes.add(ChannelWorker.WriteMode.ENCRYPTED);
                }
                if (this.compressionType != Enumerations.CompressionType.NONE && this.compressionType != null) {
                    allModes.add(ChannelWorker.WriteMode.COMPRESSED);
                }
                container.writeModes = allModes.toArray(new ChannelWorker.WriteMode[0]);
            } else {
                container.writeModes = writeModes;
            }
            try {
                this.writeContainer(container);
            }
            catch (Throwable t) {
                this.sendErrorData(t, true);
                return;
            }
        }
    }

    @Override
    public int writeData(List<Byte> writeByteBuffer) throws TransceiverException {
        if (writeByteBuffer.size() < 1) {
            return 0;
        }
        byte[] message = new byte[writeByteBuffer.size()];
        for (int i = 0; i < message.length; ++i) {
            message[i] = writeByteBuffer.get(i);
        }
        int writtenBytes = 0;
        try {
            this.channelOut.write(message, 0, message.length);
            this.channelOut.flush();
            writtenBytes = message.length;
            for (int i = 0; i < writtenBytes; ++i) {
                writeByteBuffer.remove(0);
            }
        }
        catch (Throwable e) {
            throw new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error during writing", e);
        }
        return writtenBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List list = this.readByteBuffer;
        synchronized (list) {
            block13: {
                try {
                    byte[] bytes = new byte[4096];
                    int nBytes = this.channelIn.read(bytes);
                    if (nBytes == -1) {
                        throw new TransceiverException(Enumerations.ErrorType.END_OF_STREAM_REACHED, "received -1");
                    }
                    this.inBytes += (long)nBytes;
                    for (int i = 0; i < nBytes; ++i) {
                        this.readByteBuffer.add(bytes[i]);
                    }
                }
                catch (Throwable e) {
                    TransceiverException t = new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error during reading from channel", e);
                    this.sendErrorData(t, true);
                    return;
                }
                try {
                    ATransceiver.DataPacket dataPacket = new ATransceiver.DataPacket();
                    this.readDataPacket(this.readByteBuffer, dataPacket);
                    if (dataPacket.data == null) break block13;
                    TransmissionObject transmission = this.read(dataPacket, false);
                    ConcurrentLinkedQueue i = this.incoming;
                    synchronized (i) {
                        this.incoming.offer(transmission);
                    }
                    this.connector.execute(this.transceiver);
                }
                catch (Throwable t) {
                    TransceiverException ex;
                    Enumerations.ErrorType type;
                    boolean endCommunication = false;
                    if (t instanceof TransceiverException && ((type = (ex = (TransceiverException)t).getErrorType()) == Enumerations.ErrorType.UNEXPECTED_SEQUENCE || type == Enumerations.ErrorType.CIPHER_FAILED || type == Enumerations.ErrorType.UNKNOWN_ENCRYPTION || type == Enumerations.ErrorType.COMPRESSION_FAILED || type == Enumerations.ErrorType.UNKNOWN_COMPRESSION || type == Enumerations.ErrorType.UNSUPPORTED_API_VERSION || type == Enumerations.ErrorType.UNKNOWN_PROTOCOL || type == Enumerations.ErrorType.PROTOCOL_FAILED)) {
                        endCommunication = true;
                    }
                    this.sendErrorData(t, endCommunication);
                }
            }
        }
        this.connector.execute(this);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        InetAddress address = this.channel.getInetAddress();
        if (address != null) {
            return new InetSocketAddress(address, this.channel.getPort());
        }
        return null;
    }
}

