/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver;

import bsc.api.Enumerations;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.FailResult;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.exception.transceiver.UnknownMessageException;
import bsc.sdk.api.protocol.ProtocolFactory;
import bsc.sdk.kernel.modules.io.IConnectionAdapter;
import bsc.sdk.kernel.transceiver.AChannelHandler;
import bsc.sdk.kernel.transceiver.ATransceiver;
import bsc.sdk.kernel.transceiver.BSCAsynchronousSocketChannel;
import bsc.sdk.kernel.transceiver.CompletionHandler;
import bsc.sdk.net.ISocket;
import bsc.sdk.tools.Tools;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelHandlerCompletionSync
extends AChannelHandler
implements CompletionHandler<Integer, ByteArrayOutputStream> {
    private static Logger logger = LoggerFactory.getLogger(ChannelHandlerCompletionSync.class);
    private BSCAsynchronousSocketChannel clientChannel;
    private final ISocket channel;
    private static final int PAGE_SIZE = 4096;
    private static final int GET_TYPE = 0;
    private static final int GET_LENGTH = 1;
    private static final int SYNC_SIZE = 1;
    private static final int TYPE_LENGTH_SIZE = 8;
    private static final int API_REVISION_SIZE = 4;
    private static final int SEQUENCE_SIZE = 4;
    private static final int HEADER_SIZE = 17;
    private ByteBuffer buffer = ByteBuffer.allocate(4096);

    public ChannelHandlerCompletionSync(ISocket channel, IConnectionAdapter connector) {
        super(connector);
        this.channel = Objects.requireNonNull(channel, "channel must not be null!");
        this.protocol = ProtocolFactory.newInstance(Enumerations.ProtocolType.JSON);
        try {
            DataOutputStream channelOut = new DataOutputStream(channel.getOutputStream());
            DataInputStream channelIn = new DataInputStream(new BufferedInputStream(channel.getInputStream()));
            this.clientChannel = new BSCAsynchronousSocketChannel(channelIn, channelOut);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AChannelHandler.Op currentOp;
        Collection collection = this.ops;
        synchronized (collection) {
            currentOp = (AChannelHandler.Op)((Object)this.ops.poll());
            if (currentOp == null) {
                return;
            }
        }
        switch (currentOp) {
            case READ: {
                try {
                    ByteArrayOutputStream internalBuffer = new ByteArrayOutputStream();
                    this.clientChannel.read(this.buffer, internalBuffer, this);
                    break;
                }
                catch (Throwable e) {
                    TransceiverException t = new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error during reading from channel", e);
                    this.sendErrorData(t, true);
                    return;
                }
            }
            case WRITE: {
                collection = this.writeByteBuffer;
                synchronized (collection) {
                    try {
                        this.write();
                    }
                    catch (Throwable t) {
                        this.sendErrorData(t, true);
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void closeChannel() {
        try {
            this.clientChannel.close();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public int writeData(List<Byte> writeByteBuffer) throws TransceiverException {
        if (writeByteBuffer.size() < 1) {
            return 0;
        }
        byte[] message = new byte[writeByteBuffer.size()];
        for (int i = 0; i < message.length; ++i) {
            message[i] = writeByteBuffer.get(i);
        }
        int writtenBytes = 0;
        try {
            int nBytes;
            ByteBuffer buffer = ByteBuffer.wrap(message);
            writtenBytes = nBytes = this.clientChannel.write(buffer);
            for (int i = 0; i < writtenBytes; ++i) {
                writeByteBuffer.remove(0);
            }
            buffer.clear();
        }
        catch (Throwable e) {
            throw new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error during writing", e);
        }
        return writtenBytes;
    }

    private int[] analyzeTypeAndLength(byte[] typeAndLength) {
        if (typeAndLength == null || typeAndLength.length != 8) {
            throw new IllegalArgumentException("Header is not the correct size (8 bytes) or 'null'");
        }
        int start = 0;
        int type = (typeAndLength[start++] & 0xFF) << 24 | (typeAndLength[start++] & 0xFF) << 16 | (typeAndLength[start++] & 0xFF) << 8 | typeAndLength[start++] & 0xFF;
        int length = (typeAndLength[start++] & 0xFF) << 24 | (typeAndLength[start++] & 0xFF) << 16 | (typeAndLength[start++] & 0xFF) << 8 | typeAndLength[start++] & 0xFF;
        return new int[]{type, length};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDataPacket(byte[] data, int type, byte[] apiRevision, byte[] sequence) throws Throwable {
        try {
            FailResult result;
            ATransceiver.DataPacket dataPacket = new ATransceiver.DataPacket();
            dataPacket.packetType = Enumerations.MessageType.values()[type];
            dataPacket.data = data;
            dataPacket.sequence = Tools.byteArrayToInt(sequence);
            dataPacket.apiRevision = Tools.byteArrayToInt(apiRevision);
            TransmissionObject transmission = this.read(dataPacket, false);
            if (transmission.getObject() instanceof FailResult && ((result = (FailResult)transmission.getObject()).getErrorType().equals((Object)Enumerations.ErrorType.SESSION_NOT_FOUND) || result.getErrorType().equals((Object)Enumerations.ErrorType.USER_ALREADY_CONNECTED))) {
                this.connector.debug((Object)result.getErrorType());
            }
            ConcurrentLinkedQueue concurrentLinkedQueue = this.incoming;
            synchronized (concurrentLinkedQueue) {
                this.incoming.offer(transmission);
                this.connector.execute(this.transceiver);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new UnknownMessageException();
        }
    }

    @Override
    public void completed(Integer result, ByteArrayOutputStream attachment) {
        try {
            this.buffer.flip();
            int nBytes = result;
            if (nBytes == -1) {
                throw new TransceiverException(Enumerations.ErrorType.END_OF_STREAM_REACHED, "received -1");
            }
            this.inBytes += (long)nBytes;
            byte[] remainingIO = new byte[this.buffer.remaining()];
            this.buffer.get(remainingIO);
            attachment.write(remainingIO);
            this.buffer.clear();
            this.checkForCompletedMessages(attachment);
            this.clientChannel.read(this.buffer, attachment, this);
        }
        catch (Throwable t) {
            TransceiverException ex;
            Enumerations.ErrorType type;
            boolean endCommunication = false;
            if (t instanceof TransceiverException && ((type = (ex = (TransceiverException)t).getErrorType()) == Enumerations.ErrorType.UNEXPECTED_SEQUENCE || type == Enumerations.ErrorType.CIPHER_FAILED || type == Enumerations.ErrorType.UNKNOWN_ENCRYPTION || type == Enumerations.ErrorType.COMPRESSION_FAILED || type == Enumerations.ErrorType.UNKNOWN_COMPRESSION || type == Enumerations.ErrorType.UNSUPPORTED_API_VERSION || type == Enumerations.ErrorType.END_OF_STREAM_REACHED || type == Enumerations.ErrorType.UNKNOWN_PROTOCOL || type == Enumerations.ErrorType.PROTOCOL_FAILED)) {
                endCommunication = true;
            }
            this.buffer.clear();
            attachment.reset();
            this.sendErrorData(t, endCommunication);
        }
    }

    @Override
    public void failed(Throwable exc, ByteArrayOutputStream attachment) {
        TransceiverException t = new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error during reading from channel", exc);
        this.sendErrorData(t, true);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        InetAddress address = this.channel.getInetAddress();
        if (address != null) {
            return new InetSocketAddress(address, this.channel.getPort());
        }
        return null;
    }

    private void checkForCompletedMessages(ByteArrayOutputStream attachment) throws Throwable {
        ByteArrayInputStream bais = new ByteArrayInputStream(attachment.toByteArray());
        if (bais.available() >= 9) {
            byte[] sync = new byte[1];
            byte[] header = new byte[8];
            bais.read(sync);
            bais.read(header);
            int[] analysis = this.analyzeTypeAndLength(header);
            int type = analysis[0];
            int length = analysis[1];
            if (length <= bais.available() - 8) {
                byte[] apiRevision = new byte[4];
                byte[] sequence = new byte[4];
                bais.read(apiRevision);
                bais.read(sequence);
                byte[] data = new byte[length];
                bais.read(data);
                byte[] remaining = new byte[bais.available()];
                bais.read(remaining);
                bais.reset();
                attachment.reset();
                attachment.write(remaining);
                this.buildDataPacket(data, type, apiRevision, sequence);
                this.checkForCompletedMessages(attachment);
            }
        }
    }
}

