/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver;

import bsc.api.Enumerations;
import bsc.api.transport.TransmissionObject;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.protocol.ProtocolFactory;
import bsc.sdk.kernel.modules.io.IConnectionAdapter;
import bsc.sdk.kernel.transceiver.AChannelHandler;
import bsc.sdk.kernel.transceiver.ATransceiver;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelHandler
extends AChannelHandler {
    private static Logger logger = LoggerFactory.getLogger(ChannelHandler.class);
    private AsynchronousSocketChannel clientChannel;

    public ChannelHandler(AsynchronousSocketChannel channel, IConnectionAdapter connector) {
        super(connector);
        this.clientChannel = channel;
        this.protocol = ProtocolFactory.newInstance(Enumerations.ProtocolType.JSON);
    }

    @Override
    public void closeChannel() {
        try {
            this.clientChannel.close();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public int writeData(List<Byte> writeByteBuffer) throws TransceiverException {
        if (writeByteBuffer.size() < 1) {
            return 0;
        }
        byte[] message = new byte[writeByteBuffer.size()];
        for (int i = 0; i < message.length; ++i) {
            message[i] = writeByteBuffer.get(i);
        }
        int writtenBytes = 0;
        try {
            ByteBuffer buffer = ByteBuffer.wrap(message);
            Future<Integer> result = this.clientChannel.write(buffer);
            writtenBytes = result.get();
            for (int i = 0; i < writtenBytes; ++i) {
                writeByteBuffer.remove(0);
            }
            buffer.clear();
        }
        catch (Throwable e) {
            throw new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error during writing", e);
        }
        return writtenBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        AChannelHandler.Op currentOp;
        ConcurrentLinkedQueue concurrentLinkedQueue = this.ops;
        synchronized (concurrentLinkedQueue) {
            currentOp = (AChannelHandler.Op)((Object)this.ops.poll());
            if (currentOp == null) {
                return;
            }
        }
        switch (currentOp) {
            case READ: {
                List list = this.readByteBuffer;
                synchronized (list) {
                    try {
                        ByteBuffer buffer = ByteBuffer.allocate(32);
                        Future<Integer> read = this.clientChannel.read(buffer);
                        int nBytes = read.get();
                        if (nBytes == -1) {
                            throw new TransceiverException(Enumerations.ErrorType.END_OF_STREAM_REACHED, "received -1");
                        }
                        this.inBytes += (long)nBytes;
                        buffer.flip();
                        byte[] bytes = buffer.array();
                        for (int i = 0; i < nBytes; ++i) {
                            this.readByteBuffer.add(bytes[i]);
                        }
                        buffer.clear();
                    }
                    catch (Throwable e) {
                        TransceiverException t = new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error during reading from channel", e);
                        this.sendErrorData(t, true);
                        return;
                    }
                    try {
                        ATransceiver.DataPacket dataPacket = new ATransceiver.DataPacket();
                        this.readDataPacket(this.readByteBuffer, dataPacket);
                        if (dataPacket.data != null) {
                            TransmissionObject transmission = this.read(dataPacket, false);
                            ConcurrentLinkedQueue nBytes = this.incoming;
                            synchronized (nBytes) {
                                this.incoming.offer(transmission);
                                this.connector.execute(this.transceiver);
                            }
                        }
                    }
                    catch (Throwable t) {
                        TransceiverException ex;
                        Enumerations.ErrorType type;
                        boolean endCommunication = false;
                        if (t instanceof TransceiverException && ((type = (ex = (TransceiverException)t).getErrorType()) == Enumerations.ErrorType.UNEXPECTED_SEQUENCE || type == Enumerations.ErrorType.CIPHER_FAILED || type == Enumerations.ErrorType.UNKNOWN_ENCRYPTION || type == Enumerations.ErrorType.COMPRESSION_FAILED || type == Enumerations.ErrorType.UNKNOWN_COMPRESSION || type == Enumerations.ErrorType.UNSUPPORTED_API_VERSION || type == Enumerations.ErrorType.UNKNOWN_PROTOCOL || type == Enumerations.ErrorType.PROTOCOL_FAILED)) {
                            endCommunication = true;
                        }
                        this.sendErrorData(t, endCommunication);
                    }
                }
                ConcurrentLinkedQueue concurrentLinkedQueue2 = this.ops;
                synchronized (concurrentLinkedQueue2) {
                    this.ops.offer(AChannelHandler.Op.READ);
                    break;
                }
            }
            case WRITE: {
                List list = this.writeByteBuffer;
                synchronized (list) {
                    try {
                        this.write();
                    }
                    catch (Throwable t) {
                        this.sendErrorData(t, true);
                        return;
                    }
                }
            }
        }
        this.connector.execute(this);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (this.clientChannel != null) {
            try {
                SocketAddress sa = this.clientChannel.getRemoteAddress();
                if (sa instanceof InetSocketAddress) {
                    return (InetSocketAddress)sa;
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

