/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.transceiver;

import bsc.api.Enumerations;
import bsc.api.IApiObject;
import bsc.api.basic.commands.Command;
import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.Result;
import bsc.sdk.api.compression.ICompression;
import bsc.sdk.api.crypt.ICipher;
import bsc.sdk.api.exception.TransceiverException;
import bsc.sdk.api.exception.crypt.CipherException;
import bsc.sdk.api.protocol.IProtocol;
import bsc.sdk.api.transceiver.transmission.ITransmission;
import bsc.sdk.api.transceiver.transmission.Transmission;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverState;
import bsc.sdk.kernel.modules.io.IConnectionAdapter;
import bsc.sdk.kernel.transceiver.ChannelWorker;
import bsc.sdk.kernel.transceiver.ITransceiver;
import bsc.sdk.kernel.transceiver.ITransceiverState;
import bsc.sdk.kernel.transceiver.state.AStateExit;
import bsc.sdk.tools.Tools;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATransceiver
implements ITransceiver,
Runnable {
    private static Logger logger = LoggerFactory.getLogger(ATransceiver.class);
    protected IConnectionAdapter connector;
    protected ChannelWorker channelHandler;
    private ITransceiverState state;
    private IUserCredential connectedUser;
    private final long creationTime;
    private IApiObject lastObjectToSend;
    private Object stateLock = new Object();
    private final InetSocketAddress remoteAddress;
    protected TransceiverState.STATE transceiverState = null;
    protected final String transceiverID;

    public ATransceiver(String transceiverID, ChannelWorker channelWorker, ITransceiverState state, IConnectionAdapter connector) throws SocketException {
        this.transceiverID = transceiverID;
        this.connector = connector;
        this.creationTime = System.currentTimeMillis();
        this.channelHandler = channelWorker;
        this.channelHandler.setTransceiver(this);
        this.state = state;
        this.remoteAddress = channelWorker.getRemoteAddress();
        this.transceiverStateChanged(TransceiverState.STATE.CREATED, null);
    }

    public void setConnectedUser(IUserCredential connectedUser) {
        this.connectedUser = connectedUser;
    }

    public IUserCredential getConnectedUser() {
        return this.connectedUser;
    }

    @Override
    public void initialize(String currentSessionID) throws CipherException {
        this.channelHandler.initialize(currentSessionID);
    }

    @Override
    public void setTransceiverState(ITransceiverState state) {
        int newStateLevel;
        int currentStateLevel = this.state != null ? this.state.getLevel() : 0;
        int n = newStateLevel = state != null ? state.getLevel() : 6;
        if (newStateLevel >= currentStateLevel) {
            this.state = state;
        }
    }

    @Override
    public TransmissionObject nextIncomingTransmission() {
        return this.channelHandler.nextIncomingTransmission();
    }

    @Override
    public void closeChannel() {
        this.channelHandler.closeChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.state != null) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state != null) {
                    this.setTransceiverState(this.state.execute());
                    while (this.state != null && this.state instanceof AStateExit) {
                        this.setTransceiverState(this.state.execute());
                    }
                }
            }
        }
    }

    @Override
    public void error(TransceiverException e) {
        this.fireErrorOccured(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(boolean terminate) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != null) {
                this.setTransceiverState(this.state.disconnect(terminate));
                this.connector.execute(this);
            } else {
                logger.warn("ATransceiver#disconnect(boolean) called when state was already null.");
            }
        }
    }

    @Override
    public void exit() {
        this.channelHandler.markAsShutdownInProgress();
        this.closeChannel();
        logger.trace("ATransceiver disconnected");
        this.printStatistics();
    }

    @Override
    public void connect() {
        this.connector.execute(this);
    }

    @Override
    public void shutdownAfterSending(IApiObject apiObject) {
        this.lastObjectToSend = apiObject;
    }

    public IApiObject getLastObjectToSend() {
        return this.lastObjectToSend;
    }

    @Override
    public void fireErrorOccured(TransceiverException e) {
        this.connector.errorOccured(e);
    }

    @Override
    public ITransmission write(TransmissionObject transmissionObject, ChannelWorker.WriteMode ... writeModes) {
        return this.write(transmissionObject, true, writeModes);
    }

    @Override
    public ITransmission write(TransmissionObject transmissionObject, boolean notifyTransmissionManager, ChannelWorker.WriteMode ... writeModes) {
        Transmission result = null;
        if (notifyTransmissionManager && !(transmissionObject.getObject() instanceof Result)) {
            result = new Transmission(transmissionObject);
            this.connector.objectUpdated(result);
        }
        this.channelHandler.write(transmissionObject, writeModes);
        return result;
    }

    @Override
    public void printStatistics() {
        this.channelHandler.printStatistics();
    }

    @Override
    public void setCipher(ICipher cipher) {
        this.channelHandler.setCipher(cipher);
    }

    @Override
    public ICipher getCipher() {
        return this.channelHandler.getCipher();
    }

    @Override
    public void setCompression(ICompression compression) {
        this.channelHandler.setCompression(compression);
    }

    @Override
    public ICompression getCompression() {
        return this.channelHandler.getCompression();
    }

    @Override
    public void setProtocol(IProtocol protocol) {
        this.channelHandler.setProtocol(protocol);
    }

    @Override
    public IProtocol getProtocol() {
        return this.channelHandler.getProtocol();
    }

    @Override
    public ITransmission sendCommand(Command command) {
        TransmissionObject transmissionObject = new TransmissionObject(this.getNewTransmissionId(), command);
        return this.write(transmissionObject, new ChannelWorker.WriteMode[0]);
    }

    @Override
    public ITransmission sendObject(IApiObject object) {
        if (this.transceiverState.equals((Object)TransceiverState.STATE.WORK)) {
            logger.debug("Send object: " + object.getClass().getName());
            TransmissionObject transmissionObject = null;
            transmissionObject = object instanceof TransmissionObject ? (TransmissionObject)object : new TransmissionObject(this.getNewTransmissionId(), object);
            return this.write(transmissionObject, new ChannelWorker.WriteMode[0]);
        }
        logger.debug("Failed to send: not authenticated");
        return null;
    }

    private String getNewTransmissionId() {
        return this.connector.getNewTransmissionID();
    }

    @Override
    public ITransceiverState getTransceiverState() {
        return this.state;
    }

    @Override
    public ChannelWorker getChannelHandler() {
        return this.channelHandler;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getInBytes() {
        return this.channelHandler.getInBytes();
    }

    @Override
    public long getOutBytes() {
        return this.channelHandler.getOutBytes();
    }

    @Override
    public TransceiverState.STATE getState() {
        return this.transceiverState;
    }

    public void transceiverStateChanged(TransceiverState.STATE newState, String stage) {
        this.transceiverState = newState;
        if (newState.equals((Object)TransceiverState.STATE.WORK)) {
            this.channelHandler.setVerifyPacketApiRevision(true);
        }
        this.connector.transceiverStateChanged(newState, stage);
    }

    public static final class ErrorData {
        int errorType;
        String message;

        public ErrorData(int errorType, String message) {
            this.errorType = errorType;
            this.message = message;
        }

        public byte[] toByteArray() throws TransceiverException {
            byte[] data = null;
            ByteArrayOutputStream bout = null;
            FilterOutputStream dout = null;
            try {
                bout = new ByteArrayOutputStream();
                dout = new DataOutputStream(bout);
                ((DataOutputStream)dout).writeInt(this.errorType);
                Tools.writeString((DataOutputStream)dout, this.message);
                ((DataOutputStream)dout).flush();
                data = bout.toByteArray();
            }
            catch (IOException e) {
                throw new TransceiverException(Enumerations.ErrorType.IO_EXCEPTION, "io error occurred", e);
            }
            finally {
                try {
                    dout.close();
                    bout.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            return data;
        }

        public String toString() {
            String className = this.getClass().getSimpleName();
            return MessageFormat.format("{0}: ErrorType = {1}, Message = {2}", className, this.errorType, this.message);
        }
    }

    public static final class DataPacket {
        Enumerations.MessageType packetType;
        byte[] data;
        int sequence;
        int apiRevision;

        public String toString() {
            String className = this.getClass().getSimpleName();
            return MessageFormat.format("{0}: PacketType = {1}, Data = [{2}]", new Object[]{className, this.packetType, Tools.toHexString(this.data)});
        }
    }
}

