/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.user;

import bsc.sdk.api.user.session.ISession;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.application.RefreshSessionRequest;
import bsc.sdk.kernel.bus.messages.module.user.MarkSessionForRenewal;
import bsc.sdk.kernel.modules.user.SessionManager;
import java.util.HashMap;
import java.util.Map;
import net.engio.mbassy.listener.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutorenewSessionManager
extends SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(AutorenewSessionManager.class);
    private static final String VID_KEY = "M2M->VID";
    private static final String AT = "@";
    private Map<String, String> latestInvalidatedSessions = new HashMap<String, String>();

    public AutorenewSessionManager(AApplicationKernel kernel) {
        super(kernel);
    }

    @Override
    public synchronized void cleanupSessions() {
        this.latestInvalidatedSessions.clear();
        super.cleanupSessions();
        int nRenew = this.maxSessions - this.sessions.size();
        int count = 0;
        logger.trace("can renew up to: " + nRenew + " sessions");
        for (Map.Entry<String, String> entry : this.latestInvalidatedSessions.entrySet()) {
            String sessionID = entry.getKey();
            String usernameAtVid = entry.getValue();
            if (count >= nRenew) continue;
            logger.info("request new session for: " + usernameAtVid + ", invalidated sessionID: " + sessionID);
            RefreshSessionRequest reconnectRequest = new RefreshSessionRequest(sessionID, usernameAtVid);
            this.postKernelMessage(reconnectRequest).asynchronously();
            ++count;
        }
    }

    @Handler
    private void markSessionForRenewal(MarkSessionForRenewal message) {
        ISession s = message.getSession();
        String vid = s.getCapsMetaData().get(VID_KEY);
        if (vid != null) {
            logger.trace("Session: " + s.getSessionID() + " has been marked as invalid.");
            String user = s.getUserCredentialID();
            this.latestInvalidatedSessions.put(s.getSessionID(), user + AT + vid);
        }
    }
}

