/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.io;

import bsc.api.Enumerations;
import bsc.api.basic.commands.Command;
import bsc.sdk.api.transceiver.transmission.ITransmission;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.filter.ObjectTargetFilter;
import bsc.sdk.kernel.bus.messages.application.RefreshSessionRequest;
import bsc.sdk.kernel.bus.messages.kernel.io.ReceivedMisc;
import bsc.sdk.kernel.bus.messages.kernel.io.SendCommand;
import bsc.sdk.kernel.bus.messages.kernel.io.TransceiverState;
import bsc.sdk.kernel.bus.messages.kernel.io.UpdateTransmission;
import bsc.sdk.kernel.bus.messages.kernel.user.AddUser;
import bsc.sdk.kernel.bus.messages.module.CloudStateLookup;
import bsc.sdk.kernel.bus.messages.module.ConnectionRequest;
import bsc.sdk.kernel.bus.messages.module.Debug;
import bsc.sdk.kernel.bus.messages.module.DisconnectRequest;
import bsc.sdk.kernel.bus.messages.module.handler.ObjectUpdated;
import bsc.sdk.kernel.bus.messages.module.user.UpdateSession;
import bsc.sdk.kernel.impl.BasicApiKernel;
import bsc.sdk.kernel.modules.IKernelModule;
import bsc.sdk.kernel.modules.io.ClientConnector;
import bsc.sdk.kernel.modules.io.TransmissionManager;
import bsc.sdk.kernel.modules.user.AutorenewSessionManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.listener.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IKernelModule.ModuleSettings(supportedKernels={BasicApiKernel.class}, dependencies={AutorenewSessionManager.class, TransmissionManager.class})
public class ObservantClientConnector
extends ClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(ObservantClientConnector.class);
    private static final String AT = "@";
    private Map<String, ClientConnector.ConnectionProfile> cachedConnections;
    private String persistenceFile = "cachedConnections.bin";
    private List<String> connectionIDsToDisconnect;

    public ObservantClientConnector(AApplicationKernel kernel) throws UnknownHostException, IOException {
        super(kernel);
        if (!this.load()) {
            this.cachedConnections = new ConcurrentHashMap<String, ClientConnector.ConnectionProfile>();
        }
        this.connectionIDsToDisconnect = new ArrayList<String>();
    }

    @Handler
    private void handleAddUser(AddUser addUser) {
        logger.trace("> added: " + addUser.getUser().getUserName());
    }

    @Handler
    private void handleReceivedMisc(ReceivedMisc receivedMisc) {
        logger.trace("> received: " + receivedMisc);
    }

    @Handler
    private void handleObjectUpdated(ObjectUpdated objectUpdated) {
        logger.trace("> updated: " + objectUpdated);
    }

    @Override
    @Handler
    protected void disconnect(DisconnectRequest disconnectRequest) {
        logger.debug("acknowledged request for a disconnect using: " + disconnectRequest.getTarget());
        ClientConnector.ClientConnection connection = (ClientConnector.ClientConnection)this.connections.get(disconnectRequest.getTarget());
        if (connection != null) {
            logger.debug("calling disconnect()");
            connection.disconnect(false);
            logger.debug("removing connection");
            this.connections.remove(connection.getId());
        }
        logger.debug("unregistering target: " + disconnectRequest.getTarget());
        ObjectTargetFilter.unregisterDynamicFilterValue(this.getUniqueID(), disconnectRequest.getTarget());
    }

    @Override
    @Handler
    protected void sendCommand(SendCommand sendCommand) {
        ClientConnector.ClientConnection connection = (ClientConnector.ClientConnection)this.connections.get(sendCommand.getTarget());
        if (connection != null) {
            long timeout = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(2L);
            while (!connection.isConnectionReadyForOperation() && System.currentTimeMillis() < timeout) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            ITransmission transmission = connection.sendCommand((Command)sendCommand.getObject());
            this.postKernelMessage(new UpdateTransmission(transmission)).now();
            sendCommand.setTransmission(transmission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    private void handleConnectionState(TransceiverState connectionState) {
        boolean disconnected;
        boolean connected;
        String connectionID = connectionState.getSource();
        boolean bl = connected = connectionState.getState().equals((Object)TransceiverState.STATE.WORK) && connectionState.getStage().equals("working");
        if (connected) {
            logger.debug(connectionID + " is connected");
        }
        if (disconnected = connectionState.getState().equals((Object)TransceiverState.STATE.TERMINATED)) {
            logger.debug(connectionID + " is disconnected");
        }
        if (connected) {
            List<String> list = this.connectionIDsToDisconnect;
            synchronized (list) {
                if (this.connectionIDsToDisconnect.contains(connectionID)) {
                    this.connectionIDsToDisconnect.remove(connectionID);
                    logger.debug("request a disconnect using: " + connectionID);
                    DisconnectRequest disconnectRequest = new DisconnectRequest(connectionID);
                    this.postKernelMessage(disconnectRequest).asynchronously();
                }
            }
        }
    }

    @Handler
    public void handleUpdateSession(UpdateSession sessionUpdate) {
        String sessionID = sessionUpdate.getSession().getSessionID();
        String vid = sessionUpdate.getSession().getCapsMetaData().get("M2M->VID");
        String username = sessionUpdate.getSession().getUserCredentialID();
        if (vid != null && !vid.isEmpty()) {
            logger.debug("updating cache entry for: " + username + AT + vid + " with new sessionID: " + sessionID);
            ClientConnector.ConnectionProfile existingProfile = this.cachedConnections.get(username + AT + vid);
            if (existingProfile != null) {
                existingProfile.setSessionID(sessionID);
            } else {
                logger.debug("no cache entry found for: " + username + AT + vid);
            }
        } else {
            logger.debug("no vid was submitted in meta data. cannot update cache entry with new sessionID.");
        }
    }

    @Override
    @Handler
    protected void connect(ConnectionRequest connectionRequest) {
        ClientConnector.ConnectionProfile connectionProfile = connectionRequest.getConnectionProfile();
        String username = connectionProfile.getUser();
        String vid = connectionProfile.getVid();
        ClientConnector.ConnectionProfile existingProfile = this.cachedConnections.get(username + AT + vid);
        if (existingProfile != null) {
            String existingSessionID = existingProfile.getSessionID();
            logger.debug("previous connection found. using sessionID: " + existingSessionID);
            connectionProfile.setSessionID(existingSessionID);
        } else {
            logger.debug("new connection. creating cache entry for: " + username + AT + vid);
            this.cachedConnections.put(username + AT + vid, connectionProfile);
        }
        super.connect(connectionRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    protected void reconnect(RefreshSessionRequest reconnectRequest) {
        String sessionID = reconnectRequest.getInvalidatedSessionID();
        String usernameAtVid = reconnectRequest.getUsernameAtVid();
        logger.debug("acknowledged request for new session for: " + usernameAtVid + ", invalidated sessionID: " + sessionID);
        ClientConnector.ConnectionProfile connectionProfile = this.cachedConnections.get(usernameAtVid);
        if (connectionProfile != null && sessionID.equals(connectionProfile.getSessionID())) {
            logger.debug("attempting reconnect...");
            ClientConnector.ConnectionProfile cTemp = this.cachedConnections.remove(usernameAtVid);
            if (cTemp != null) {
                logger.debug("cache entry removed. cache persisted.");
                this.save();
            }
            List<String> list = this.connectionIDsToDisconnect;
            synchronized (list) {
                String vid = usernameAtVid.substring(usernameAtVid.indexOf(AT) + 1);
                String user = usernameAtVid.substring(0, usernameAtVid.indexOf(AT));
                CloudStateLookup discover = new CloudStateLookup(vid, user, null);
                this.postKernelMessage(discover).now();
                String randomIP_at_InsideM2M = discover.getIp();
                int randomPort_at_InsideM2M = discover.getPort();
                connectionProfile.setSessionID(null);
                connectionProfile.setPort(randomPort_at_InsideM2M);
                connectionProfile.setServer(randomIP_at_InsideM2M);
                ConnectionRequest connectionRequest = new ConnectionRequest(connectionProfile);
                this.postKernelMessage(connectionRequest).now();
                String connectionID = connectionRequest.getCreatedTarget();
                this.connectionIDsToDisconnect.add(connectionID);
            }
        } else {
            logger.debug("no cache entry found or session id mismatch. session will not be refreshed.");
        }
        logger.debug("refreshing connection done.");
    }

    @Handler
    private void handleTransceiverException(Debug exceptionMessage) {
        String connectionID = exceptionMessage.getIdent();
        Enumerations.ErrorType exception = (Enumerations.ErrorType)((Object)exceptionMessage.getObject());
        logger.error("unexpected transceiver data for connectionID: " + connectionID);
        logger.error("ErrorType : " + (Object)((Object)exception));
        if (exception.equals((Object)Enumerations.ErrorType.SESSION_NOT_FOUND)) {
            String usernameAtVid = exceptionMessage.getUsernameAtVid();
            logger.debug("session rejected by server. removing cached connection entry for: " + usernameAtVid);
            ClientConnector.ConnectionProfile profile = this.cachedConnections.remove(usernameAtVid);
            if (profile != null) {
                logger.debug("cache entry removed. cache persisted.");
                this.save();
            }
        }
    }

    @Override
    public void unload() {
        super.unload();
        this.save();
    }

    private boolean load() {
        File file = new File(this.persistenceFile);
        if (file.exists()) {
            try (FileInputStream fin = new FileInputStream(file);
                 ObjectInputStream oin = new ObjectInputStream(fin);){
                this.cachedConnections = (ConcurrentHashMap)oin.readObject();
            }
            catch (Exception e) {
                logger.error("Unable to load cached connections file", (Throwable)e);
            }
        }
        return this.cachedConnections != null;
    }

    private synchronized void save() {
        File file = new File(this.persistenceFile);
        try (FileOutputStream fout = new FileOutputStream(file);
             ObjectOutputStream oout = new ObjectOutputStream(fout);){
            oout.writeObject(this.cachedConnections);
            oout.flush();
        }
        catch (Throwable e) {
            logger.error("Unable to save cached connections file", e);
        }
    }
}

