/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.idpool;

import bsc.sdk.kernel.modules.idpool.IdPool;
import java.util.Objects;

public class IdPoolSettings {
    private final String id;
    private final IdPool.GENERATOR_TYPE type;
    private final long timeToLive;
    private final String prefix;
    private final String suffix;
    private final int baseLength;
    private final String insert;
    private final int insertPeriod;

    public IdPoolSettings(String id, IdPool.GENERATOR_TYPE type) {
        this(id, type, 25);
    }

    public IdPoolSettings(String id, IdPool.GENERATOR_TYPE type, String prefix) {
        this(id, type, 25, prefix);
    }

    public IdPoolSettings(String id, IdPool.GENERATOR_TYPE type, int baseLength) {
        this(id, type, baseLength, "");
    }

    public IdPoolSettings(String id, IdPool.GENERATOR_TYPE type, int baseLength, String prefix) {
        this(id, type, 0L, prefix, "", baseLength, "", 0);
    }

    public IdPoolSettings(String id, IdPool.GENERATOR_TYPE type, long timeToLive, String prefix, String suffix, int baseLength, String insert, int insertPeriod) {
        this.id = Objects.requireNonNull(id, "id must not be null!");
        this.type = Objects.requireNonNull(type, "type must not be null!");
        this.timeToLive = timeToLive;
        this.prefix = Objects.requireNonNull(prefix, "preFix must not be null!");
        this.suffix = Objects.requireNonNull(suffix, "suffix must not be null!");
        this.baseLength = baseLength;
        this.insert = Objects.requireNonNull(insert, "insert must not be null!");
        this.insertPeriod = insertPeriod;
    }

    public IdPool.GENERATOR_TYPE getType() {
        return this.type;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int getBaseLength() {
        return this.baseLength;
    }

    public String getInsert() {
        return this.insert;
    }

    public int getInsertPeriod() {
        return this.insertPeriod;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getId() {
        return this.id;
    }
}

