/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.modules.api;

import bsc.api.basic.model.ADevice;
import bsc.api.modules.camera.commands.MoveCameraCommand;
import bsc.api.modules.camera.commands.StartCameraCommand;
import bsc.api.modules.camera.commands.StartStreamCommand;
import bsc.api.modules.camera.commands.StopCameraCommand;
import bsc.api.modules.camera.commands.StopStreamCommand;
import bsc.api.modules.camera.commands.offer.MoveCameraOffer;
import bsc.api.modules.camera.commands.offer.StartStreamOffer;
import bsc.api.modules.camera.commands.offer.StopStreamOffer;
import bsc.api.modules.camera.model.Camera;
import bsc.api.transport.result.OkResult;
import bsc.api.transport.result.Result;
import bsc.sdk.api.user.group.Permission;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.filter.ObjectContainerFilter;
import bsc.sdk.kernel.bus.messages.module.handler.HandleCommand;
import bsc.sdk.kernel.bus.messages.module.objects.AddCommandOffers;
import bsc.sdk.kernel.bus.messages.module.user.permission.device.GetDevicePermission;
import bsc.sdk.kernel.modules.api.AApiExtensionModule;
import net.engio.mbassy.listener.Filter;
import net.engio.mbassy.listener.Handler;

public class CAMERA
extends AApiExtensionModule {
    public CAMERA(AApplicationKernel kernel) {
        super(kernel);
    }

    @Handler(filters={@Filter(value=CameraOfferFilter.class)})
    protected void addCommandOffers(AddCommandOffers request) {
        ADevice device = (ADevice)request.getObject();
        GetDevicePermission getDevicePermission = new GetDevicePermission(request.getUserName(), device.getDeviceID());
        this.postKernelMessage(getDevicePermission).now();
        if (getDevicePermission.getPermissions().contains((Object)Permission.VIEW_EXTENDED)) {
            device.addCommandOffer(new StartStreamOffer());
            device.addCommandOffer(new StopStreamOffer());
            device.addCommandOffer(new MoveCameraOffer());
        }
    }

    @Handler(filters={@Filter(value=CameraCommandFilter.class)})
    protected void handleCommand(HandleCommand message) {
        Result result = null;
        if (message.getObject() instanceof MoveCameraCommand) {
            result = this.handleCommand((MoveCameraCommand)message.getObject());
        } else if (message.getObject() instanceof StartCameraCommand) {
            result = this.handleCommand((StartCameraCommand)message.getObject());
        } else if (message.getObject() instanceof StartStreamCommand) {
            result = this.handleCommand((StartStreamCommand)message.getObject());
        } else if (message.getObject() instanceof StopCameraCommand) {
            result = this.handleCommand((StopCameraCommand)message.getObject());
        } else if (message.getObject() instanceof StopStreamCommand) {
            result = this.handleCommand((StopStreamCommand)message.getObject());
        }
        if (result != null) {
            message.setResult(result);
        }
    }

    protected Result handleCommand(MoveCameraCommand command) {
        return new OkResult();
    }

    protected Result handleCommand(StartCameraCommand command) {
        return new OkResult();
    }

    protected Result handleCommand(StartStreamCommand command) {
        return new OkResult();
    }

    protected Result handleCommand(StopCameraCommand command) {
        return new OkResult();
    }

    protected Result handleCommand(StopStreamCommand command) {
        return new OkResult();
    }

    @ObjectContainerFilter.ObjectContainerFilterSettings(supportedClasses={MoveCameraCommand.class, StartCameraCommand.class, StartStreamCommand.class, StopCameraCommand.class, StopStreamCommand.class})
    public static class CameraCommandFilter
    extends ObjectContainerFilter {
    }

    @ObjectContainerFilter.ObjectContainerFilterSettings(supportedClasses={Camera.class})
    public static class CameraOfferFilter
    extends ObjectContainerFilter {
    }
}

