/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.bus.messages.module.devicecache;

import bsc.api.IIdentifiableApiObject;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.environment.EnvironmentRegistry;
import bsc.sdk.api.objects.manager.cache.IDeviceCacheProcessor;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.kernel.AApplicationKernel;
import bsc.sdk.kernel.bus.messages.devicecache.AddToDeviceCache;
import bsc.sdk.kernel.bus.messages.devicecache.RemoveFromDeviceCache;
import bsc.sdk.kernel.bus.messages.devicecache.UpdateDeviceCache;
import java.util.Collection;
import java.util.Set;

public class SDKCompatibilityBridge
extends AApplicationKernel.KernelModule
implements IDeviceCacheProcessor {
    public SDKCompatibilityBridge(AApplicationKernel kernel) {
        super(kernel);
    }

    @Override
    public void unload() {
        this.unregisterAtSDKEnvironments();
    }

    @Override
    public void init() {
        this.registerAtSDKEnvironments();
    }

    @Override
    public void addToDeviceCache(UserCredentialIdentifier user, IIdentifiableApiObject object) {
        this.postKernelMessage(new AddToDeviceCache(user, object)).now();
    }

    @Override
    public void updateDeviceCache(UserCredentialIdentifier user, Set<IIdentifiableApiObject> objects) {
        this.postKernelMessage(new UpdateDeviceCache(user, objects)).now();
    }

    @Override
    public void removeFromDeviceCache(UserCredentialIdentifier user, String id) {
        this.postKernelMessage(new RemoveFromDeviceCache(user, id)).now();
    }

    protected void registerAtSDKEnvironments() {
        final SDKCompatibilityBridge me = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                Collection<Environment> envs = EnvironmentRegistry.getAllRegistryEntries();
                SDKCompatibilityBridge.this.logger.debug("waiting for SDK...");
                while (envs.size() == 0) {
                    SDKCompatibilityBridge.this.logger.trace("still waiting for SDK...");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        SDKCompatibilityBridge.this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    envs = EnvironmentRegistry.getAllRegistryEntries();
                }
                SDKCompatibilityBridge.this.logger.debug("SDK is ready!");
                for (Environment environment : envs) {
                    SDKCompatibilityBridge.this.logger.debug("Register at " + environment.getApplicationName() + " (" + environment.getApplicationId() + ")");
                    environment.getObjectManager().registerDeviceCacheProcessor(me);
                }
            }
        }).start();
    }

    protected void unregisterAtSDKEnvironments() {
        Collection<Environment> envs = EnvironmentRegistry.getAllRegistryEntries();
        for (Environment environment : envs) {
            environment.getObjectManager().registerDeviceCacheProcessor(this);
        }
    }
}

