/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel.bus.impl;

import bsc.sdk.kernel.bus.impl.DefaultMessageBus;
import bsc.sdk.kernel.bus.impl.TypedMessageBus;
import net.engio.mbassy.bus.MessagePublication;
import net.engio.mbassy.bus.common.DeadMessage;
import net.engio.mbassy.bus.common.FilteredMessage;
import net.engio.mbassy.bus.config.BusConfiguration;
import net.engio.mbassy.bus.config.Feature;
import net.engio.mbassy.bus.config.IBusConfiguration;
import net.engio.mbassy.bus.error.IPublicationErrorHandler;
import net.engio.mbassy.bus.error.PublicationError;
import net.engio.mbassy.listener.Handler;
import net.engio.mbassy.listener.MetadataReader;
import net.engio.mbassy.subscription.ISubscriptionManagerProvider;
import net.engio.mbassy.subscription.SubscriptionFactory;
import net.engio.mbassy.subscription.SubscriptionManagerProvider;
import org.slf4j.Logger;

public class MessageBusFactory {
    public static DefaultMessageBus createDefaultMessageBus(String name, Logger logger) {
        logger.trace("Create " + name + " DefaultMessageBus");
        return new DefaultMessageBus(MessageBusFactory.createDefaultBusConfiguration(name, MessageBusFactory.createLoggingErrorHandler(name, logger)));
    }

    public static <T> TypedMessageBus<T> createTypedMessageBus(Class<T> clazz, String name, Logger logger) {
        logger.trace("Create " + name + " TypedMessageBus " + clazz.getName());
        return new TypedMessageBus(MessageBusFactory.createDefaultBusConfiguration(name, MessageBusFactory.createLoggingErrorHandler(name, logger)));
    }

    public static IBusConfiguration createDefaultBusConfiguration(String name, IPublicationErrorHandler errorHandler) {
        return new BusConfiguration().addFeature((Feature)new Feature.SyncPubSub().setMetadataReader(new MetadataReader()).setPublicationFactory(new MessagePublication.Factory()).setSubscriptionFactory(new SubscriptionFactory()).setSubscriptionManagerProvider((ISubscriptionManagerProvider)new SubscriptionManagerProvider())).addFeature((Feature)Feature.AsynchronousHandlerInvocation.Default()).addFeature((Feature)Feature.AsynchronousMessageDispatch.Default()).addPublicationErrorHandler(errorHandler).setProperty("bus.id", (Object)name);
    }

    public static IPublicationErrorHandler createLoggingErrorHandler(String name, Logger logger) {
        return new DefaultMessageBusErrorHandler(name, logger);
    }

    public static class DefaultMessageBusErrorHandler
    implements IPublicationErrorHandler {
        protected Logger logger;
        protected String name;

        public DefaultMessageBusErrorHandler(String name, Logger logger) {
            this.name = name;
            this.logger = logger;
            logger.trace(name + " message bus error handler created.");
        }

        public void handleError(PublicationError error) {
            this.logger.error("Error while publishing message at " + this.name + " bus for " + error.getListener() == null ? "null" : (error.getListener().getClass().getName() + "#" + error.getHandler() == null ? "null" : error.getHandler().getName()), error.getCause() == null ? "null" : error.getCause().getCause());
        }

        @Handler
        protected void handleDeadMessage(DeadMessage deadMessage) {
            this.logger.warn("No handler at " + this.name + " bus for " + deadMessage.getMessage().getClass().getName());
        }

        @Handler
        protected void handleFilteredMessage(FilteredMessage filteredMessage) {
            this.logger.warn("Message at " + this.name + " bus was filtered out: " + filteredMessage.getMessage().getClass().getName());
        }
    }
}

