/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.kernel;

import bsc.sdk.kernel.IKernelSettings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AKernelSettings
implements IKernelSettings {
    protected Map<String, String> settings = null;

    protected Map<String, String> getSettingsMap() {
        if (this.settings == null) {
            this.settings = new HashMap<String, String>();
        }
        return this.settings;
    }

    @Override
    public String getSetting(String key) {
        return this.getSettingsMap().get(key);
    }

    @Override
    public Map<String, String> getSettings(String ... keys) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String k : keys) {
            String value = this.getSetting(k);
            if (value == null) continue;
            result.put(k, value);
        }
        return result;
    }

    @Override
    public Map<String, String> getAllSettings() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.getSettingsMap());
        return result;
    }

    @Override
    public void put(String key, String value) {
        this.getSettingsMap().put(key, value);
    }

    @Override
    public void putAll(Map<String, String> settings) {
        this.getSettingsMap().putAll(settings);
    }

    @Override
    public void remove(String key) {
        this.getSettingsMap().remove(key);
    }

    @Override
    public void removeAll(Collection<String> keys) {
        if (keys != null) {
            for (String k : keys) {
                this.remove(k);
            }
        }
    }

    @Override
    public void init() {
        this.settings = new HashMap<String, String>();
        this.importSettings();
    }

    @Override
    public void shutdown() {
        this.exportSettings();
    }

    @Override
    public boolean exportSettings() {
        return this.exportSettings(new String[0]);
    }

    @Override
    public boolean importSettings() {
        return this.importSettings(new String[0]);
    }

    @Override
    public boolean contains(String key) {
        return this.getSettingsMap().containsKey(key);
    }
}

