/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.group.manager;

import bsc.api.IUpdateableObject;
import bsc.sdk.api.AManager;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.group.IUserGroup;
import bsc.sdk.api.user.group.UserGroupFactory;
import bsc.sdk.api.user.group.UserGroupIdentifier;
import bsc.sdk.api.user.group.manager.IUserGroupManager;
import java.util.Objects;

public abstract class AUserGroupManager
extends AManager<UserGroupIdentifier, IUserGroup>
implements IUserGroupManager {
    @Override
    protected IUserGroup getNewObjectInstance(IUserGroup orgObject) {
        return UserGroupFactory.createNewInstance(Objects.requireNonNull(orgObject, "orgObject must not be null!"));
    }

    @Override
    public boolean removeObject(UserGroupIdentifier objectIdentifier) {
        boolean result = super.removeObject(objectIdentifier);
        for (UserCredentialIdentifier user : objectIdentifier.getMembers()) {
            user.leaveGroup(objectIdentifier);
        }
        return result;
    }

    @Override
    public boolean updateObject(IUpdateableObject object) {
        IUserGroup group;
        UserGroupIdentifier identifier;
        boolean result = super.updateObject(object);
        if (object instanceof IUserGroup && (identifier = (UserGroupIdentifier)this.getIdentifierInstance(group = (IUserGroup)object)) != null) {
            for (UserCredentialIdentifier user : identifier.getMembers()) {
                user.rebuildObjectCache();
            }
        }
        return result;
    }

    @Override
    public void objectReceived(String tag, Object object) {
    }

    @Override
    public UserGroupIdentifier getUserGroupByID(String userGroupID) {
        for (UserGroupIdentifier identifier : this.identifierCache.values()) {
            if (!Objects.requireNonNull(userGroupID, "userGroupID must not be null!").equals(identifier.getUserGroupID())) continue;
            return identifier;
        }
        return null;
    }
}

