/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.user.credential.manager;

import bsc.sdk.api.AManager;
import bsc.sdk.api.user.credential.IUserCredential;
import bsc.sdk.api.user.credential.manager.IUserCredentialManager;
import bsc.sdk.api.user.credential.manager.UserCredentialIdentifier;
import bsc.sdk.api.user.group.UserGroupIdentifier;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AUserCredentialManager
extends AManager<UserCredentialIdentifier, IUserCredential>
implements IUserCredentialManager {
    public static final String userCredentialPoolId = "UserCredentials";

    @Override
    public UserCredentialIdentifier getUserCredential(String username) {
        if (username != null) {
            for (IUserCredential user : this.objects.values()) {
                if (!user.getUserName().equals(username)) continue;
                return (UserCredentialIdentifier)this.getIdentifierInstance(user);
            }
        }
        return null;
    }

    @Override
    public Set<UserGroupIdentifier> getUserGroups(UserCredentialIdentifier user) {
        IUserCredential credential = (IUserCredential)this.getObjectInstance(user);
        HashSet<UserGroupIdentifier> result = new HashSet<UserGroupIdentifier>();
        if (credential != null) {
            for (String groupID : credential.getGroupIDs()) {
                try {
                    result.add(UserGroupIdentifier.createIdentifierInstance(groupID, this.getEnvironment()));
                }
                catch (URISyntaxException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public Set<UserCredentialIdentifier> getGroupMembers(UserGroupIdentifier group) {
        HashSet<UserCredentialIdentifier> result = new HashSet<UserCredentialIdentifier>();
        if (group != null) {
            for (IUserCredential user : this.objects.values()) {
                if (!user.getGroupIDs().contains(group.getUserGroupID())) continue;
                result.add((UserCredentialIdentifier)this.getIdentifierInstance(user));
            }
        }
        return result;
    }

    @Override
    public boolean removeUserCredential(UserCredentialIdentifier user) {
        return this.removeObject(user);
    }

    @Override
    public boolean removeUserCredential(Collection<UserCredentialIdentifier> users) {
        boolean result = true;
        for (UserCredentialIdentifier identifier : users) {
            if (this.removeUserCredential(identifier)) continue;
            result = false;
        }
        return result;
    }

    @Override
    protected IUserCredential getNewObjectInstance(IUserCredential orgObject) {
        return orgObject;
    }

    @Override
    public List<UserCredentialIdentifier> getUserCredentialList() {
        ArrayList<UserCredentialIdentifier> result = new ArrayList<UserCredentialIdentifier>();
        for (IUserCredential value : this.objects.values()) {
            result.add((UserCredentialIdentifier)this.getIdentifierInstance(value));
        }
        return result;
    }

    @Override
    public UserCredentialIdentifier addObject(IUserCredential object, boolean rebuildPermissionCache) {
        UserCredentialIdentifier identifier = (UserCredentialIdentifier)super.addObject(object);
        if (rebuildPermissionCache) {
            this.getEnvironment().getObjectManager().rebuildUserObjectCache(identifier);
        }
        return identifier;
    }

    @Override
    public Collection<UserCredentialIdentifier> addObject(Collection<IUserCredential> object, boolean rebuildPermissionCache) {
        HashSet<UserCredentialIdentifier> result = new HashSet<UserCredentialIdentifier>();
        for (IUserCredential obj : object) {
            result.add(this.addObject(obj, rebuildPermissionCache));
        }
        return result;
    }

    @Override
    public boolean removeObject(UserCredentialIdentifier objectIdentifier) {
        boolean result = super.removeObject(objectIdentifier);
        this.getEnvironment().getObjectManager().rebuildUserObjectCache(objectIdentifier);
        return result;
    }

    @Override
    public boolean updateObject(IUserCredential object) {
        return this.updateObject(object, true);
    }

    @Override
    public boolean updateObject(IUserCredential object, boolean rebuildPermissionCache) {
        boolean result = super.updateObject(object);
        if (rebuildPermissionCache) {
            this.getEnvironment().getObjectManager().rebuildUserObjectCache((UserCredentialIdentifier)this.getIdentifierInstance(object));
        }
        return result;
    }

    @Override
    public void objectReceived(String tag, Object object) {
    }
}

