/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.transmission.manager;

import bsc.api.transport.TransmissionObject;
import bsc.api.transport.result.Result;
import bsc.sdk.api.application.environment.Environment;
import bsc.sdk.api.application.identifier.AIdentifier;
import bsc.sdk.api.transceiver.transmission.ITransmission;
import bsc.sdk.api.transceiver.transmission.Progress;
import bsc.sdk.api.user.credential.IUserCredential;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Objects;

public class TransmissionIdentifier
extends AIdentifier<ITransmission> {
    public static int TRANSMISSION_ID_PART = 0;
    private final String transmissionID = this.getPathPart(TRANSMISSION_ID_PART);

    public TransmissionIdentifier(URI uri) throws URISyntaxException {
        super(uri);
    }

    public String getTransmissionID() {
        return this.transmissionID;
    }

    public static URI generateURI(String transmissionID, String applicationID, String host) {
        if (transmissionID != null && applicationID != null && host != null) {
            try {
                String uriString = ITransmission.class.getSimpleName() + "://" + applicationID + "@" + host + "/" + URLEncoder.encode(transmissionID, "UTF-8");
                return new URI(uriString);
            }
            catch (UnsupportedEncodingException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static URI generateURI(String transmissionID, Environment enviromentSettings) {
        return TransmissionIdentifier.generateURI(transmissionID, Objects.requireNonNull(enviromentSettings, "enviromentSettings must not be null!").getApplicationId(), enviromentSettings.getHostID());
    }

    public static TransmissionIdentifier createIdentifierInstance(String transmissionID, Environment enviromentSettings) throws URISyntaxException {
        return new TransmissionIdentifier(TransmissionIdentifier.generateURI(transmissionID, enviromentSettings));
    }

    public static TransmissionIdentifier createIdentifierInstance(IUserCredential transmission, Environment enviromentSettings) throws URISyntaxException {
        return new TransmissionIdentifier(TransmissionIdentifier.generateURI(Objects.requireNonNull(transmission, "transmission must not be null!").getUserName(), enviromentSettings));
    }

    @Override
    public ITransmission getObjectInstance() {
        return (ITransmission)this.environment.getTransmissionManager().getObjectInstance(this);
    }

    @Override
    public boolean deleteObject() {
        return this.environment.getTransmissionManager().removeObject(this);
    }

    @Override
    public boolean updateObject(ITransmission objectInstance) {
        return false;
    }

    @Override
    public boolean saveObject() {
        return this.environment.getTransmissionManager().save(this);
    }

    public boolean hasProgress() {
        boolean result;
        ITransmission transmission = this.getObjectInstance();
        boolean bl = result = transmission != null;
        if (result) {
            result = transmission.hasProgress();
        }
        return result;
    }

    public Progress getProgress() {
        ITransmission transmission = this.getObjectInstance();
        Progress result = null;
        if (transmission != null) {
            result = transmission.getProgress();
        }
        return result;
    }

    public Result getResult() {
        ITransmission transmission = this.getObjectInstance();
        Result result = null;
        if (transmission != null) {
            result = transmission.getResult();
        }
        return result;
    }

    public long getResultTimestamp() {
        ITransmission transmission = this.getObjectInstance();
        long result = 0L;
        if (transmission != null) {
            result = transmission.getResultTimestamp();
        }
        return result;
    }

    public long getCreationTimestamp() {
        ITransmission transmission = this.getObjectInstance();
        long result = 0L;
        if (transmission != null) {
            result = transmission.getCreationTimestamp();
        }
        return result;
    }

    public TransmissionObject getTransmissionObject() {
        ITransmission transmission = this.getObjectInstance();
        TransmissionObject result = null;
        if (transmission != null) {
            result = transmission.getTransmissionObject();
        }
        return result;
    }
}

