/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.transmission;

import bsc.api.transport.model.ProgressStatus;
import bsc.sdk.tools.Tools;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Progress {
    private final String progressID;
    private final HashMap<ProgressStatus, Long> progressStatus;
    private boolean finished = false;
    private ProgressStatus.STATE currentState = ProgressStatus.STATE.WAITING;
    private final Set<Runnable> callbacks;

    public Progress(String progressID) {
        this.progressID = Objects.requireNonNull(progressID, "progressID must not be null!");
        this.progressStatus = new HashMap();
        this.callbacks = new HashSet<Runnable>();
    }

    public String getProgressID() {
        return this.progressID;
    }

    public Map<ProgressStatus, Long> getProgressStatus() {
        return Tools.sortByValue(this.progressStatus);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean attachProgressStatus(ProgressStatus progressStatus) {
        boolean result = false;
        if (progressStatus != null && !this.progressStatus.containsKey(progressStatus)) {
            this.progressStatus.put(progressStatus, System.currentTimeMillis());
            result = true;
            this.currentState = progressStatus.getState();
            switch (this.currentState) {
                case DROPPED: 
                case ABORTED: 
                case FINISHED: {
                    this.finished = true;
                    break;
                }
                case RUNNING: {
                    break;
                }
                case WAITING: {
                    break;
                }
            }
            this.executeCallbacks();
        }
        return result;
    }

    public ProgressStatus.STATE getCurrentState() {
        return this.currentState;
    }

    public void addCallback(Runnable runnable) {
        this.callbacks.add(runnable);
    }

    private void executeCallbacks() {
        for (Runnable runnable : this.callbacks) {
            runnable.run();
        }
    }
}

