/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.transmission;

import bsc.sdk.api.transceiver.transmission.manager.TransmissionIdentifier;
import java.util.HashSet;

public class FutureTransmission {
    private HashSet<Runnable> callbacks = new HashSet();
    private TransmissionIdentifier transmissionIdentifier = null;

    public FutureTransmission() {
    }

    public FutureTransmission(TransmissionIdentifier transmissionIdentifier) {
        this.setTransmissionIdentifier(transmissionIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCallback(Runnable runnable) {
        boolean result = false;
        if (runnable != null) {
            if (!this.hasFinished()) {
                HashSet<Runnable> hashSet = this.callbacks;
                synchronized (hashSet) {
                    result = this.callbacks.add(runnable);
                }
            } else {
                runnable.run();
            }
        }
        return result;
    }

    public TransmissionIdentifier getTransmissionIdentifier() {
        return this.getTransmissionIdentifier(false);
    }

    public TransmissionIdentifier getTransmissionIdentifier(boolean waitUntilAvailable) {
        if (waitUntilAvailable) {
            this.waitForCompletion();
        }
        return this.transmissionIdentifier;
    }

    public void waitForCompletion() {
        while (!this.hasFinished()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransmissionIdentifier(TransmissionIdentifier transmissionIdentifier) {
        if (this.transmissionIdentifier == null) {
            this.transmissionIdentifier = transmissionIdentifier;
            HashSet<Runnable> hashSet = this.callbacks;
            synchronized (hashSet) {
                for (Runnable runnable : this.callbacks) {
                    runnable.run();
                }
                this.callbacks.clear();
            }
        }
    }

    public boolean hasFinished() {
        return this.transmissionIdentifier != null;
    }
}

