/*
 * Decompiled with CFR 0.152.
 */
package bsc.sdk.api.transceiver.state;

import bsc.sdk.api.application.client.transceiver.state.StateDisconnect;
import bsc.sdk.api.application.client.transceiver.state.StateError;
import bsc.sdk.api.application.client.transceiver.state.StateInit;
import bsc.sdk.api.application.server.transceiver.state.StateAuth;
import bsc.sdk.api.application.server.transceiver.state.StateTerminate;
import bsc.sdk.api.application.server.transceiver.state.StateWork;
import bsc.sdk.api.transceiver.state.ITransceiverState;
import bsc.sdk.api.transceiver.state.StateConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateFactory {
    private static Logger logger = LoggerFactory.getLogger(StateFactory.class);
    private static StateFactory defaultFactory = null;

    public static StateFactory getDefaultFactory() {
        if (defaultFactory == null) {
            defaultFactory = StateFactory.createDefaultFactory();
        }
        return defaultFactory;
    }

    public static void setDefaultFactory(StateFactory factory) {
        defaultFactory = factory;
    }

    public static StateFactory createDefaultFactory() {
        return new StateFactory(){
            private Map<TYPE, Map<STATE, Class<? extends ITransceiverState>>> classMapping = new HashMap<TYPE, Map<STATE, Class<? extends ITransceiverState>>>();
            {
                HashMap<STATE, Class> serverMap = new HashMap<STATE, Class>();
                serverMap.put(STATE.INIT, bsc.sdk.api.application.server.transceiver.state.StateInit.class);
                serverMap.put(STATE.AUTH, StateAuth.class);
                serverMap.put(STATE.DISCONNECT, bsc.sdk.api.application.server.transceiver.state.StateDisconnect.class);
                serverMap.put(STATE.ERROR, bsc.sdk.api.application.server.transceiver.state.StateError.class);
                serverMap.put(STATE.TERMINATE, StateTerminate.class);
                serverMap.put(STATE.WORK, StateWork.class);
                this.classMapping.put(TYPE.SERVER, serverMap);
                HashMap<STATE, Class> clientMap = new HashMap<STATE, Class>();
                clientMap.put(STATE.INIT, StateInit.class);
                clientMap.put(STATE.AUTH, bsc.sdk.api.application.client.transceiver.state.StateAuth.class);
                clientMap.put(STATE.DISCONNECT, StateDisconnect.class);
                clientMap.put(STATE.ERROR, StateError.class);
                clientMap.put(STATE.TERMINATE, bsc.sdk.api.application.client.transceiver.state.StateTerminate.class);
                clientMap.put(STATE.WORK, bsc.sdk.api.application.client.transceiver.state.StateWork.class);
                this.classMapping.put(TYPE.CLIENT, clientMap);
            }

            @Override
            public ITransceiverState createState(StateConfiguration settings) {
                Class<? extends ITransceiverState> clazz = this.classMapping.get((Object)settings.getType()).get((Object)settings.getState());
                try {
                    Constructor<? extends ITransceiverState> c = clazz.getConstructor(StateConfiguration.class);
                    ITransceiverState iTransceiverState = c.newInstance(settings);
                    return iTransceiverState;
                }
                catch (NoSuchMethodException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (SecurityException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (InstantiationException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                return null;
            }
        };
    }

    public abstract ITransceiverState createState(StateConfiguration var1);

    public static enum STATE {
        INIT,
        AUTH,
        WORK,
        ERROR,
        DISCONNECT,
        TERMINATE;

    }

    public static enum TYPE {
        SERVER,
        CLIENT;

    }
}

